/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class PainlessExecuteAction
extends Action<Request, Response, RequestBuilder> {
    static final PainlessExecuteAction INSTANCE = new PainlessExecuteAction();
    private static final String NAME = "cluster:admin/scripts/painless/execute";

    private PainlessExecuteAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    static class RestAction
    extends BaseRestHandler {
        RestAction(Settings settings, RestController controller) {
            super(settings);
            controller.registerHandler(RestRequest.Method.GET, "/_scripts/painless/_execute", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, "/_scripts/painless/_execute", (RestHandler)this);
        }

        public String getName() {
            return "_scripts_painless_execute";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
            Request request = Request.parse(restRequest.contentOrSourceParamParser());
            return channel -> client.executeLocally((GenericAction)INSTANCE, (ActionRequest)request, (ActionListener)new RestBuilderListener<Response>(channel){

                public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
                    response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final ScriptService scriptService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService) {
            super(settings, PainlessExecuteAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.scriptService = scriptService;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            switch (request.context) {
                case PAINLESS_TEST: {
                    PainlessTestScript.Factory factory = (PainlessTestScript.Factory)this.scriptService.compile(request.script, PainlessTestScript.CONTEXT);
                    PainlessTestScript painlessTestScript = factory.newInstance(request.script.getParams());
                    String result = Objects.toString(painlessTestScript.execute());
                    listener.onResponse((Object)new Response(result));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported context [" + (Object)((Object)request.context) + "]");
                }
            }
        }
    }

    public static abstract class PainlessTestScript {
        private final Map<String, Object> params;
        public static final String[] PARAMETERS = new String[0];
        public static final ScriptContext<Factory> CONTEXT = new ScriptContext("painless_test", Factory.class);

        public PainlessTestScript(Map<String, Object> params) {
            this.params = params;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public abstract Object execute();

        public static interface Factory {
            public PainlessTestScript newInstance(Map<String, Object> var1);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Object result;

        Response() {
        }

        Response(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.result = in.readGenericValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeGenericValue(this.result);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("result", this.result);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.result, response.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContent {
        private static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
        private static final ParseField CONTEXT_FIELD = new ParseField("context", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("painless_execute_request", args -> new Request((Script)args[0], (SupportedContext)((Object)((Object)args[1]))));
        private Script script;
        private SupportedContext context;

        static Request parse(XContentParser parser) throws IOException {
            return (Request)((Object)PARSER.parse(parser, null));
        }

        Request(Script script, SupportedContext context) {
            this.script = Objects.requireNonNull(script);
            this.context = context != null ? context : SupportedContext.PAINLESS_TEST;
        }

        Request() {
        }

        public Script getScript() {
            return this.script;
        }

        public SupportedContext getContext() {
            return this.context;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.script.getType() != ScriptType.INLINE) {
                validationException = ValidateActions.addValidationError((String)"only inline scripts are supported", validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.script = new Script(in);
            this.context = SupportedContext.fromId(in.readByte());
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.script.writeTo(out);
            out.writeByte(this.context.id);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
            builder.startObject(CONTEXT_FIELD.getPreferredName());
            builder.startObject(this.context.name());
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.script, request.script) && this.context == request.context;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.script, this.context});
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse((XContentParser)p), SCRIPT_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                XContentParser.Token token = p.nextToken();
                assert (token == XContentParser.Token.FIELD_NAME);
                String contextType = p.currentName();
                token = p.nextToken();
                assert (token == XContentParser.Token.START_OBJECT);
                token = p.nextToken();
                assert (token == XContentParser.Token.END_OBJECT);
                token = p.nextToken();
                assert (token == XContentParser.Token.END_OBJECT);
                return SupportedContext.valueOf(contextType.toUpperCase(Locale.ROOT));
            }, CONTEXT_FIELD);
        }

        public static enum SupportedContext {
            PAINLESS_TEST(0);

            private final byte id;

            private SupportedContext(byte id) {
                this.id = id;
            }

            public static SupportedContext fromId(byte id) {
                switch (id) {
                    case 0: {
                        return PAINLESS_TEST;
                    }
                }
                throw new IllegalArgumentException("unknown context [" + id + "]");
            }
        }
    }
}

