/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.job.retention.ExpiredForecastsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredModelSnapshotsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredResultsRemover;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.job.retention.UnusedStateRemover;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class TransportDeleteExpiredDataAction
extends HandledTransportAction<DeleteExpiredDataAction.Request, DeleteExpiredDataAction.Response> {
    private final Client client;
    private final ClusterService clusterService;

    @Inject
    public TransportDeleteExpiredDataAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, ClusterService clusterService) {
        super(settings, "cluster:admin/xpack/ml/delete_expired_data", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteExpiredDataAction.Request::new);
        this.client = ClientHelper.clientWithOrigin((Client)client, (String)"ml");
        this.clusterService = clusterService;
    }

    protected void doExecute(DeleteExpiredDataAction.Request request, ActionListener<DeleteExpiredDataAction.Response> listener) {
        this.logger.info("Deleting expired data");
        this.threadPool.executor("ml_utility").execute(() -> this.deleteExpiredData(listener));
    }

    private void deleteExpiredData(ActionListener<DeleteExpiredDataAction.Response> listener) {
        Auditor auditor = new Auditor(this.client, this.clusterService.nodeName());
        List<MlDataRemover> dataRemovers = Arrays.asList(new ExpiredResultsRemover(this.client, this.clusterService, auditor), new ExpiredForecastsRemover(this.client), new ExpiredModelSnapshotsRemover(this.client, this.clusterService), new UnusedStateRemover(this.client, this.clusterService));
        VolatileCursorIterator<MlDataRemover> dataRemoversIterator = new VolatileCursorIterator<MlDataRemover>(dataRemovers);
        this.deleteExpiredData(dataRemoversIterator, listener);
    }

    private void deleteExpiredData(Iterator<MlDataRemover> mlDataRemoversIterator, ActionListener<DeleteExpiredDataAction.Response> listener) {
        if (mlDataRemoversIterator.hasNext()) {
            MlDataRemover remover = mlDataRemoversIterator.next();
            remover.remove((ActionListener<Boolean>)ActionListener.wrap(booleanResponse -> this.deleteExpiredData(mlDataRemoversIterator, listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.logger.info("Completed deletion of expired data");
            listener.onResponse((Object)new DeleteExpiredDataAction.Response(true));
        }
    }
}

