/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Library;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.ffi.Platform;
import jnr.ffi.provider.jffi.SymbolNotFoundError;

public class NativeLibrary {
    private final List<String> libraryNames;
    private final List<String> searchPaths;
    private volatile List<Library> nativeLibraries = Collections.emptyList();
    private static final Pattern BAD_ELF = Pattern.compile("(.*): (invalid ELF header|file too short|invalid file format)");
    private static final Pattern ELF_GROUP = Pattern.compile("GROUP\\s*\\(\\s*(\\S*).*\\)");

    NativeLibrary(Collection<String> libraryNames, Collection<String> searchPaths) {
        this.libraryNames = Collections.unmodifiableList(new ArrayList<String>(libraryNames));
        this.searchPaths = Collections.unmodifiableList(new ArrayList<String>(searchPaths));
    }

    private String locateLibrary(String libraryName) {
        if (new File(libraryName).isAbsolute()) {
            return libraryName;
        }
        return Platform.getNativePlatform().locateLibrary(libraryName, this.searchPaths);
    }

    long getSymbolAddress(String name) {
        for (Library l : this.getNativeLibraries()) {
            long address = l.getSymbolAddress(name);
            if (address == 0L) continue;
            return address;
        }
        return 0L;
    }

    long findSymbolAddress(String name) {
        long address = this.getSymbolAddress(name);
        if (address == 0L) {
            throw new SymbolNotFoundError(Library.getLastError());
        }
        return address;
    }

    private synchronized List<Library> getNativeLibraries() {
        if (!this.nativeLibraries.isEmpty()) {
            return this.nativeLibraries;
        }
        this.nativeLibraries = this.loadNativeLibraries();
        return this.nativeLibraries;
    }

    private synchronized List<Library> loadNativeLibraries() {
        ArrayList<Library> libs = new ArrayList<Library>();
        for (String libraryName : this.libraryNames) {
            String path;
            Library lib = NativeLibrary.openLibrary(libraryName);
            if (lib == null && libraryName != null && (path = this.locateLibrary(libraryName)) != null && !libraryName.equals(path)) {
                lib = NativeLibrary.openLibrary(path);
            }
            if (lib == null) {
                throw new UnsatisfiedLinkError(Library.getLastError());
            }
            libs.add(lib);
        }
        return Collections.unmodifiableList(libs);
    }

    private static Library openLibrary(String path) {
        Matcher sharedObject;
        File f;
        Library lib = Library.getCachedInstance(path, 9);
        if (lib != null) {
            return lib;
        }
        Matcher badElf = BAD_ELF.matcher(Library.getLastError());
        if (badElf.lookingAt() && (f = new File(badElf.group(1))).isFile() && f.length() < 4096L && (sharedObject = ELF_GROUP.matcher(NativeLibrary.readAll(f))).find()) {
            return Library.getCachedInstance(sharedObject.group(1), 9);
        }
        return null;
    }

    private static String readAll(File f) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

