/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.strscan;

import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMatchData;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@JRubyClass(name={"StringScanner"})
public class RubyStringScanner
extends RubyObject {
    private RubyString str;
    private int pos = 0;
    private int lastPos = -1;
    private Region regs;
    private Regex pattern;
    private int beg = -1;
    private int end = -1;
    private int scannerFlags;
    private static final int MATCHED_STR_SCN_F = 2048;
    private static ObjectAllocator STRINGSCANNER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyStringScanner(runtime2, klass);
        }
    };
    ThreadLocal<Matcher> currentMatcher = new ThreadLocal();
    RubyThread.Task<RubyStringScanner, Integer> task = new RubyThread.Task<RubyStringScanner, Integer>(){

        @Override
        public Integer run(ThreadContext context, RubyStringScanner rubyStringScanner) throws InterruptedException {
            ByteList value2 = RubyStringScanner.this.str.getByteList();
            return RubyStringScanner.this.currentMatcher.get().matchInterruptible(value2.begin() + RubyStringScanner.this.pos, value2.begin() + value2.realSize(), 0);
        }

        @Override
        public void wakeup(RubyThread thread2, RubyStringScanner rubyStringScanner) {
            thread2.getNativeThread().interrupt();
        }
    };
    private static final int INSPECT_LENGTH = 5;
    private static final byte[] DOT_BYTES = "...".getBytes();

    public static RubyClass createScannerClass(Ruby runtime2) {
        RubyClass scannerClass = runtime2.defineClass("StringScanner", runtime2.getObject(), STRINGSCANNER_ALLOCATOR);
        scannerClass.defineAnnotatedMethods(RubyStringScanner.class);
        ThreadContext context = runtime2.getCurrentContext();
        scannerClass.setConstant("Version", runtime2.newString("0.7.0").freeze(context));
        scannerClass.setConstant("Id", runtime2.newString("$Id: strscan.c 13506 2007-09-24 08:56:24Z nobu $").freeze(context));
        RubyClass standardError = runtime2.getStandardError();
        RubyClass error2 = scannerClass.defineClassUnder("Error", standardError, standardError.getAllocator());
        RubyClass objClass = runtime2.getObject();
        if (!objClass.isConstantDefined("ScanError")) {
            objClass.defineConstant("ScanError", error2);
        }
        return scannerClass;
    }

    private void clearMatched() {
        this.scannerFlags &= 0xFFFFF7FF;
    }

    private void setMatched() {
        this.scannerFlags |= 0x800;
    }

    private boolean isMatched() {
        return (this.scannerFlags & 0x800) != 0;
    }

    private void check() {
        if (this.str == null) {
            throw this.getRuntime().newArgumentError("uninitialized StringScanner object");
        }
    }

    protected RubyStringScanner(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        this.str = args2[0].convertToString();
        return this;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        if (this == other) {
            return this;
        }
        if (!(other instanceof RubyStringScanner)) {
            throw this.getRuntime().newTypeError("wrong argument type " + other.getMetaClass() + " (expected StringScanner)");
        }
        RubyStringScanner otherScanner = (RubyStringScanner)other;
        this.str = otherScanner.str;
        this.pos = otherScanner.pos;
        this.lastPos = otherScanner.lastPos;
        this.scannerFlags = otherScanner.scannerFlags;
        this.regs = otherScanner.regs != null ? otherScanner.regs.clone() : null;
        this.pattern = otherScanner.pattern;
        this.beg = otherScanner.beg;
        this.end = otherScanner.end;
        return this;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset() {
        this.check();
        this.pos = 0;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate() {
        this.check();
        this.pos = this.str.getByteList().getRealSize();
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#clear is obsolete; use #terminate instead");
        }
        return this.terminate();
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return this.str;
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(ThreadContext context, IRubyObject str) {
        this.str = RubyString.stringValue(str);
        this.pos = 0;
        this.clearMatched();
        return str;
    }

    @JRubyMethod(name={"concat", "<<"}, required=1)
    public IRubyObject concat(IRubyObject obj) {
        this.check();
        this.str.append(obj.convertToString());
        return this;
    }

    @JRubyMethod(name={"pos", "pointer"})
    public RubyFixnum pos() {
        this.check();
        return RubyFixnum.newFixnum(this.getRuntime(), this.pos);
    }

    @JRubyMethod(name={"pos=", "pointer="})
    public IRubyObject set_pos(IRubyObject pos2) {
        this.check();
        int i2 = RubyNumeric.num2int(pos2);
        int size2 = this.str.getByteList().getRealSize();
        if (i2 < 0) {
            i2 += size2;
        }
        if (i2 < 0 || i2 > size2) {
            throw this.getRuntime().newRangeError("index out of range.");
        }
        this.pos = i2;
        return RubyFixnum.newFixnum(this.getRuntime(), i2);
    }

    @JRubyMethod(name={"charpos"})
    public IRubyObject charpos(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyString sub3 = (RubyString)Helpers.invoke(context, (IRubyObject)this.str, "byteslice", (IRubyObject)runtime2.newFixnum(0), (IRubyObject)runtime2.newFixnum(this.pos));
        return runtime2.newFixnum(sub3.strLength());
    }

    private IRubyObject extractRange(Ruby runtime2, int beg, int end2) {
        int size2 = this.str.getByteList().getRealSize();
        if (beg > size2) {
            return runtime2.getNil();
        }
        if (end2 > size2) {
            end2 = size2;
        }
        return this.str.makeSharedString(runtime2, beg, end2 - beg);
    }

    private IRubyObject extractBegLen(Ruby runtime2, int beg, int len) {
        assert (len >= 0);
        int size2 = this.str.getByteList().getRealSize();
        if (beg > size2) {
            return runtime2.getNil();
        }
        if (beg + len > size2) {
            len = size2 - beg;
        }
        return this.str.makeSharedString(runtime2, beg, len);
    }

    private IRubyObject scan(ThreadContext context, IRubyObject regex, boolean succptr, boolean getstr, boolean headonly) {
        int ret;
        Ruby runtime2 = this.getRuntime();
        if (!(regex instanceof RubyRegexp)) {
            throw runtime2.newTypeError("wrong argument type " + regex.getMetaClass() + " (expected Regexp)");
        }
        this.check();
        this.pattern = ((RubyRegexp)regex).preparePattern(this.str);
        this.clearMatched();
        int rest2 = this.str.getByteList().getRealSize() - this.pos;
        if (rest2 < 0) {
            return runtime2.getNil();
        }
        ByteList value2 = this.str.getByteList();
        Matcher matcher = this.pattern.matcher(value2.getUnsafeBytes(), value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize());
        this.currentMatcher.set(matcher);
        if (headonly) {
            try {
                ret = runtime2.getCurrentContext().getThread().executeTask(context, this, this.task);
            }
            catch (InterruptedException ie) {
                throw runtime2.newInterruptedRegexpError("Regexp Interrupted");
            }
        } else {
            ret = RubyRegexp.matcherSearch(context, matcher, value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize(), 0);
        }
        this.regs = matcher.getRegion();
        if (this.regs == null) {
            this.beg = matcher.getBegin();
            this.end = matcher.getEnd();
        } else {
            this.beg = this.regs.beg[0];
            this.end = this.regs.end[0];
        }
        if (ret < 0) {
            return context.nil;
        }
        this.setMatched();
        this.lastPos = this.pos;
        if (succptr) {
            this.pos += this.end;
        }
        return getstr ? this.extractBegLen(runtime2, this.lastPos, this.end) : RubyFixnum.newFixnum(runtime2, this.end);
    }

    @JRubyMethod(name={"scan"}, required=1)
    public IRubyObject scan(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, true, true);
    }

    @JRubyMethod(name={"match?"}, required=1)
    public IRubyObject match_p(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, false, true);
    }

    @JRubyMethod(name={"skip"}, required=1)
    public IRubyObject skip(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, false, true);
    }

    @JRubyMethod(name={"check"}, required=1)
    public IRubyObject check(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, true, true);
    }

    @JRubyMethod(name={"scan_full"}, required=3)
    public IRubyObject scan_full(ThreadContext context, IRubyObject regex, IRubyObject s2, IRubyObject f) {
        return this.scan(context, regex, s2.isTrue(), f.isTrue(), true);
    }

    @JRubyMethod(name={"scan_until"}, required=1)
    public IRubyObject scan_until(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, true, false);
    }

    @JRubyMethod(name={"exist?"}, required=1)
    public IRubyObject exist_p(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, false, false);
    }

    @JRubyMethod(name={"skip_until"}, required=1)
    public IRubyObject skip_until(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, false, false);
    }

    @JRubyMethod(name={"check_until"}, required=1)
    public IRubyObject check_until(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, true, false);
    }

    @JRubyMethod(name={"search_full"}, required=3)
    public IRubyObject search_full(ThreadContext context, IRubyObject regex, IRubyObject s2, IRubyObject f) {
        return this.scan(context, regex, s2.isTrue(), f.isTrue(), false);
    }

    private void adjustRegisters() {
        this.beg = 0;
        this.end = this.pos - this.lastPos;
        this.regs = null;
    }

    public IRubyObject getch(ThreadContext context) {
        return this.getch19(context);
    }

    @JRubyMethod(name={"getch"})
    public IRubyObject getch19(ThreadContext context) {
        return this.getchCommon(context, true);
    }

    public IRubyObject getchCommon(ThreadContext context, boolean is1_9) {
        int len;
        this.check();
        this.clearMatched();
        Ruby runtime2 = context.runtime;
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return context.nil;
        }
        if (is1_9) {
            Encoding enc = this.str.getEncoding();
            len = enc.isSingleByte() ? 1 : StringSupport.length(enc, value2.getUnsafeBytes(), value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize());
        } else {
            Encoding enc = runtime2.getKCode().getEncoding();
            int n = len = enc.isSingleByte() ? 1 : enc.length(value2.getUnsafeBytes(), value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize());
        }
        if (this.pos + len > value2.getRealSize()) {
            len = value2.getRealSize() - this.pos;
        }
        this.lastPos = this.pos;
        this.pos += len;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(runtime2, this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"get_byte"})
    public IRubyObject get_byte(ThreadContext context) {
        this.check();
        this.clearMatched();
        if (this.pos >= this.str.getByteList().getRealSize()) {
            return context.nil;
        }
        this.lastPos = this.pos++;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(context.runtime, this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#getbyte is obsolete; use #get_byte instead");
        }
        return this.get_byte(context);
    }

    @JRubyMethod(name={"peek"}, required=1)
    public IRubyObject peek(ThreadContext context, IRubyObject length2) {
        this.check();
        int len = RubyNumeric.num2int(length2);
        if (len < 0) {
            throw context.runtime.newArgumentError("negative string size (or size too big)");
        }
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return RubyString.newEmptyString(context.runtime).infectBy((IRubyObject)this.str);
        }
        if (this.pos + len > value2.getRealSize()) {
            len = value2.getRealSize() - this.pos;
        }
        return this.extractBegLen(context.runtime, this.pos, len);
    }

    @JRubyMethod(name={"peep"}, required=1)
    public IRubyObject peep(ThreadContext context, IRubyObject length2) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#peep is obsolete; use #peek instead");
        }
        return this.peek(context, length2);
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan() {
        this.check();
        Ruby runtime2 = this.getRuntime();
        if (!this.isMatched()) {
            RubyClass errorClass = runtime2.getClass("StringScanner").getClass("Error");
            throw RaiseException.from(runtime2, errorClass, "unscan failed: previous match had failed");
        }
        this.pos = this.lastPos;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"beginning_of_line?"}, alias={"bol?"})
    public IRubyObject bol_p() {
        this.check();
        Ruby runtime2 = this.getRuntime();
        ByteList value2 = this.str.getByteList();
        if (this.pos > value2.getRealSize()) {
            return runtime2.getNil();
        }
        if (this.pos == 0) {
            return runtime2.getTrue();
        }
        return value2.getUnsafeBytes()[value2.getBegin() + this.pos - 1] == 10 ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"eos?"})
    public RubyBoolean eos_p(ThreadContext context) {
        this.check();
        return this.pos >= this.str.getByteList().getRealSize() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#empty? is obsolete; use #eos? instead");
        }
        return this.eos_p(context);
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p(ThreadContext context) {
        this.check();
        return this.pos >= this.str.getByteList().getRealSize() ? context.fals : context.tru;
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p(ThreadContext context) {
        this.check();
        return this.isMatched() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched(ThreadContext context) {
        this.check();
        if (!this.isMatched()) {
            return context.nil;
        }
        return this.extractRange(context.runtime, this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.end - this.beg);
    }

    @JRubyMethod(name={"matchedsize"})
    public IRubyObject matchedsize(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#matchedsize is obsolete; use #matched_size instead");
        }
        return this.matched_size();
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx) {
        int numRegs;
        Ruby runtime2 = context.runtime;
        this.check();
        if (!this.isMatched()) {
            return context.nil;
        }
        if ((idx instanceof RubySymbol || idx instanceof RubyString) && this.pattern == null) {
            return context.nil;
        }
        int i2 = RubyMatchData.backrefNumber(runtime2, this.pattern, this.regs, idx);
        int n = numRegs = this.regs == null ? 1 : this.regs.numRegs;
        if (i2 < 0) {
            i2 += numRegs;
        }
        if (i2 < 0 || i2 >= numRegs) {
            return context.nil;
        }
        if (this.regs == null) {
            assert (i2 == 0);
            if (this.beg == -1) {
                return context.nil;
            }
            return this.extractRange(runtime2, this.lastPos + this.beg, this.lastPos + this.end);
        }
        if (this.regs.beg[i2] == -1) {
            return context.nil;
        }
        return this.extractRange(context.runtime, this.lastPos + this.regs.beg[i2], this.lastPos + this.regs.end[i2]);
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext context) {
        this.check();
        if (!this.isMatched()) {
            return context.nil;
        }
        return this.extractRange(context.runtime, 0, this.lastPos + this.beg);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext context) {
        this.check();
        if (!this.isMatched()) {
            return context.nil;
        }
        return this.extractRange(context.runtime, this.lastPos + this.end, this.str.getByteList().getRealSize());
    }

    @JRubyMethod(name={"rest"})
    public IRubyObject rest(ThreadContext context) {
        this.check();
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return RubyString.newEmptyString(context.runtime).infectBy((IRubyObject)this.str);
        }
        return this.extractRange(context.runtime, this.pos, value2.getRealSize());
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size() {
        this.check();
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), value2.getRealSize() - this.pos);
    }

    @JRubyMethod(name={"restsize"})
    public RubyFixnum restsize(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#restsize is obsolete; use #rest_size instead");
        }
        return this.rest_size();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.str == null) {
            return this.inspect("(uninitialized)");
        }
        if (this.pos >= this.str.getByteList().getRealSize()) {
            return this.inspect("fin");
        }
        if (this.pos == 0) {
            return this.inspect(this.pos + "/" + this.str.getByteList().getRealSize() + " @ " + this.inspect2());
        }
        return this.inspect(this.pos + "/" + this.str.getByteList().getRealSize() + " " + this.inspect1() + " @ " + this.inspect2());
    }

    private IRubyObject inspect(String msg) {
        RubyString result2 = this.getRuntime().newString("#<" + this.getMetaClass() + " " + msg + ">");
        if (this.str != null) {
            result2.infectBy((IRubyObject)this.str);
        }
        return result2;
    }

    private IRubyObject inspect1() {
        Ruby runtime2 = this.getRuntime();
        if (this.pos == 0) {
            return RubyString.newEmptyString(runtime2);
        }
        if (this.pos > 5) {
            return RubyString.newStringNoCopy(runtime2, DOT_BYTES).append(this.str.substr(runtime2, this.pos - 5, 5)).inspect();
        }
        return this.str.substr(runtime2, 0, this.pos).inspect();
    }

    private IRubyObject inspect2() {
        Ruby runtime2 = this.getRuntime();
        if (this.pos >= this.str.getByteList().getRealSize()) {
            return RubyString.newEmptyString(runtime2);
        }
        int len = this.str.getByteList().getRealSize() - this.pos;
        if (len > 5) {
            return ((RubyString)this.str.substr(runtime2, this.pos, 5)).cat(DOT_BYTES).inspect();
        }
        return this.str.substr(runtime2, this.pos, len).inspect();
    }

    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject recv2) {
        return recv2;
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        if (!this.isMatched()) {
            return context.nil;
        }
        return context.runtime.newFixnum(this.regs.numRegs);
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures(ThreadContext context) {
        if (!this.isMatched()) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        int numRegs = this.regs.numRegs;
        RubyArray newAry = RubyArray.newArray(runtime2, numRegs);
        for (int i2 = 1; i2 < numRegs; ++i2) {
            IRubyObject str = this.extractRange(runtime2, this.lastPos + this.regs.beg[i2], this.lastPos + this.regs.end[i2]);
            newAry.push(str);
        }
        return newAry;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(ThreadContext context, IRubyObject[] args2) {
        if (!this.isMatched()) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        RubyArray newAry = RubyArray.newArray(runtime2, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newAry.push(this.op_aref(context, args2[i2]));
        }
        return newAry;
    }
}

