/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.framework.ResolveContextImpl;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.ResolveContext;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.ShadowList;
import org.apache.felix.framework.resolver.SimpleHostedCapability;
import org.apache.felix.framework.resolver.WrappedCapability;
import org.apache.felix.framework.resolver.WrappedRequirement;
import org.apache.felix.framework.resolver.WrappedRevision;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Candidates {
    public static final int MANDATORY = 0;
    public static final int OPTIONAL = 1;
    public static final int ON_DEMAND = 2;
    private final Set<BundleRevision> m_mandatoryRevisions;
    private final Map<BundleCapability, Set<BundleRequirement>> m_dependentMap;
    private final Map<BundleRequirement, List<BundleCapability>> m_candidateMap;
    private final Map<BundleRevision, WrappedRevision> m_allWrappedHosts;
    private final Map<BundleRevision, Object> m_populateResultCache;
    private boolean m_fragmentsPresent = false;

    private Candidates(Set<BundleRevision> mandatoryRevisions, Map<BundleCapability, Set<BundleRequirement>> dependentMap, Map<BundleRequirement, List<BundleCapability>> candidateMap, Map<BundleRevision, WrappedRevision> wrappedHosts, Map<BundleRevision, Object> populateResultCache, boolean fragmentsPresent) {
        this.m_mandatoryRevisions = mandatoryRevisions;
        this.m_dependentMap = dependentMap;
        this.m_candidateMap = candidateMap;
        this.m_allWrappedHosts = wrappedHosts;
        this.m_populateResultCache = populateResultCache;
        this.m_fragmentsPresent = fragmentsPresent;
    }

    public Candidates() {
        this.m_mandatoryRevisions = new HashSet<BundleRevision>();
        this.m_dependentMap = new HashMap<BundleCapability, Set<BundleRequirement>>();
        this.m_candidateMap = new HashMap<BundleRequirement, List<BundleCapability>>();
        this.m_allWrappedHosts = new HashMap<BundleRevision, WrappedRevision>();
        this.m_populateResultCache = new HashMap<BundleRevision, Object>();
    }

    public final void populate(ResolveContext rc, BundleRevision revision, int resolution) {
        block7: {
            Object cacheValue = this.m_populateResultCache.get(revision);
            if (cacheValue instanceof ResolveException) {
                return;
            }
            if (cacheValue instanceof Boolean) {
                return;
            }
            boolean isFragment = Util.isFragment(revision);
            if (!isFragment && revision.getWiring() != null) {
                return;
            }
            if (resolution != 2 || isFragment && this.populateFragmentOndemand(rc, revision)) {
                if (resolution == 0) {
                    this.m_mandatoryRevisions.add(revision);
                }
                try {
                    this.populateRevision(rc, revision);
                }
                catch (ResolveException ex) {
                    if (resolution != 0) break block7;
                    throw ex;
                }
            }
        }
    }

    private void populateRevision(ResolveContext rc, BundleRevision revision) {
        Integer cycleCount = null;
        Map<BundleRequirement, List<BundleCapability>> localCandidateMap = null;
        List<BundleRequirement> remainingReqs = null;
        Object[] cacheValue = this.m_populateResultCache.get(revision);
        if (cacheValue instanceof ResolveException) {
            throw (ResolveException)cacheValue;
        }
        if (cacheValue instanceof Boolean) {
            return;
        }
        if (cacheValue != null) {
            Integer n = new Integer((Integer)((Object[])cacheValue)[0] + 1);
            ((Object[])cacheValue)[0] = n;
            cycleCount = n;
            localCandidateMap = (Map)((Object[])cacheValue)[1];
            remainingReqs = (List)((Object[])cacheValue)[2];
        }
        if (remainingReqs == null && localCandidateMap == null) {
            ((ResolveContextImpl)rc).checkNativeLibraries(revision);
            cycleCount = new Integer(0);
            localCandidateMap = new HashMap<BundleRequirement, List<BundleCapability>>();
            remainingReqs = new ArrayList<BundleRequirement>(revision.getDeclaredRequirements(null));
            cacheValue = new Object[]{cycleCount, localCandidateMap, remainingReqs};
            this.m_populateResultCache.put(revision, cacheValue);
        }
        while (!remainingReqs.isEmpty()) {
            BundleRequirement req = (BundleRequirement)remainingReqs.remove(0);
            String resolution = req.getDirectives().get("resolution");
            if (!rc.isEffective(req) || resolution != null && resolution.equals("dynamic")) continue;
            List<BundleCapability> candidates = rc.findProviders(req, true);
            ResolveException rethrow = this.processCandidates(rc, revision, candidates);
            Object result = this.m_populateResultCache.get(revision);
            if (result instanceof ResolveException) {
                throw (ResolveException)result;
            }
            if (candidates.isEmpty() && !((BundleRequirementImpl)req).isOptional()) {
                String msg = "Unable to resolve " + revision + ": missing requirement " + req;
                if (rethrow != null) {
                    msg = msg + " [caused by: " + rethrow.getMessage() + "]";
                }
                rethrow = new ResolveException(msg, revision, req);
                this.m_populateResultCache.put(revision, rethrow);
                throw rethrow;
            }
            if (candidates.size() <= 0) continue;
            localCandidateMap.put(req, candidates);
        }
        if (cycleCount > 0) {
            ((Object[])cacheValue)[0] = new Integer(cycleCount - 1);
        } else if (cycleCount == 0) {
            this.m_populateResultCache.put(revision, Boolean.TRUE);
            if (localCandidateMap.size() > 0) {
                this.add(localCandidateMap);
            }
        }
    }

    private boolean populateFragmentOndemand(ResolveContext rc, BundleRevision revision) throws ResolveException {
        ArrayList<BundleRequirement> remainingReqs = new ArrayList<BundleRequirement>(revision.getDeclaredRequirements(null));
        BundleRequirement hostReq = null;
        Iterator it = remainingReqs.iterator();
        while (it.hasNext()) {
            BundleRequirement r = (BundleRequirement)it.next();
            if (!r.getNamespace().equals("osgi.wiring.host")) continue;
            hostReq = r;
            it.remove();
            break;
        }
        List<BundleCapability> hosts = rc.findProviders(hostReq, false);
        Iterator<BundleCapability> it2 = hosts.iterator();
        while (it2.hasNext()) {
            BundleCapability host = it2.next();
            if (this.isPopulated(host.getRevision())) continue;
            it2.remove();
        }
        if (hosts.isEmpty()) {
            return false;
        }
        ((ResolveContextImpl)rc).checkNativeLibraries(revision);
        Integer cycleCount = new Integer(-1);
        HashMap<BundleRequirement, List<BundleCapability>> localCandidateMap = new HashMap<BundleRequirement, List<BundleCapability>>();
        localCandidateMap.put(hostReq, hosts);
        this.m_populateResultCache.put(revision, new Object[]{cycleCount, localCandidateMap, remainingReqs});
        return true;
    }

    public void populateDynamic(ResolveContext rc, BundleRevision revision, BundleRequirement req, List<BundleCapability> candidates) {
        this.m_mandatoryRevisions.add(revision);
        this.add(req, candidates);
        ResolveException rethrow = this.processCandidates(rc, revision, candidates);
        if (candidates.isEmpty()) {
            if (rethrow == null) {
                rethrow = new ResolveException("Dynamic import failed.", revision, req);
            }
            throw rethrow;
        }
        this.m_populateResultCache.put(revision, Boolean.TRUE);
    }

    private ResolveException processCandidates(ResolveContext rc, BundleRevision revision, List<BundleCapability> candidates) {
        ResolveException rethrow = null;
        HashSet<BundleCapability> fragmentCands = null;
        Iterator<BundleCapability> itCandCap = candidates.iterator();
        while (itCandCap.hasNext()) {
            BundleCapability candCap = itCandCap.next();
            boolean isFragment = Util.isFragment(candCap.getRevision());
            if (isFragment) {
                if (fragmentCands == null) {
                    fragmentCands = new HashSet<BundleCapability>();
                }
                fragmentCands.add(candCap);
            }
            if (!isFragment && candCap.getRevision().getWiring() != null || candCap.getRevision().equals(revision)) continue;
            try {
                this.populateRevision(rc, candCap.getRevision());
            }
            catch (ResolveException ex) {
                if (rethrow == null) {
                    rethrow = ex;
                }
                itCandCap.remove();
            }
        }
        if (fragmentCands != null) {
            for (BundleCapability fragCand : fragmentCands) {
                BundleWiring wiring = fragCand.getRevision().getWiring();
                if (wiring == null) continue;
                for (BundleWire wire : wiring.getRequiredWires(null)) {
                    if (fragCand.getNamespace().equals("osgi.wiring.package") && !wire.getProviderWiring().getCapabilities(null).contains(fragCand)) continue;
                    rc.insertHostedCapability(candidates, new WrappedCapability(wire.getCapability().getRevision(), (BundleCapabilityImpl)fragCand));
                }
            }
        }
        return rethrow;
    }

    public boolean isPopulated(BundleRevision revision) {
        Object value = this.m_populateResultCache.get(revision);
        return value != null && value instanceof Boolean;
    }

    public ResolveException getResolveException(BundleRevision revision) {
        Object value = this.m_populateResultCache.get(revision);
        return value != null && value instanceof ResolveException ? (ResolveException)value : null;
    }

    private void add(BundleRequirement req, List<BundleCapability> candidates) {
        if (req.getNamespace().equals("osgi.wiring.host")) {
            this.m_fragmentsPresent = true;
        }
        this.m_candidateMap.put(req, candidates);
    }

    private void add(Map<BundleRequirement, List<BundleCapability>> candidates) {
        for (Map.Entry<BundleRequirement, List<BundleCapability>> entry : candidates.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public BundleRevision getWrappedHost(BundleRevision m) {
        BundleRevision wrapped = this.m_allWrappedHosts.get(m);
        return wrapped == null ? m : wrapped;
    }

    public List<BundleCapability> getCandidates(BundleRequirement req) {
        return this.m_candidateMap.get(req);
    }

    public void prepare(ResolveContext rc) {
        Map<BundleCapability, Map<String, Map<Version, List<BundleRequirement>>>> hostFragments = Collections.EMPTY_MAP;
        if (this.m_fragmentsPresent) {
            hostFragments = this.populateDependents();
        }
        ArrayList<WrappedRevision> hostRevisions = new ArrayList<WrappedRevision>();
        ArrayList<BundleRevision> unselectedFragments = new ArrayList<BundleRevision>();
        for (Map.Entry<BundleCapability, Map<String, Map<Version, List<BundleRequirement>>>> hostEntry : hostFragments.entrySet()) {
            BundleCapability hostCap = hostEntry.getKey();
            Map<String, Map<Version, List<BundleRequirement>>> fragments = hostEntry.getValue();
            ArrayList<BundleRevision> selectedFragments = new ArrayList<BundleRevision>();
            for (Map.Entry<String, Map<Version, List<BundleRequirement>>> fragEntry : fragments.entrySet()) {
                boolean isFirst = true;
                for (Map.Entry<Version, List<BundleRequirement>> versionEntry : fragEntry.getValue().entrySet()) {
                    for (BundleRequirement hostReq : versionEntry.getValue()) {
                        if (isFirst) {
                            selectedFragments.add(hostReq.getRevision());
                            isFirst = false;
                            continue;
                        }
                        this.m_dependentMap.get(hostCap).remove(hostReq);
                        List<BundleCapability> hosts = this.m_candidateMap.get(hostReq);
                        hosts.remove(hostCap);
                        if (!hosts.isEmpty()) continue;
                        unselectedFragments.add(hostReq.getRevision());
                    }
                }
            }
            WrappedRevision wrappedHost = new WrappedRevision(hostCap.getRevision(), selectedFragments);
            hostRevisions.add(wrappedHost);
            this.m_allWrappedHosts.put(hostCap.getRevision(), wrappedHost);
        }
        for (BundleRevision br : unselectedFragments) {
            this.removeRevision(br, new ResolveException("Fragment was not selected for attachment.", br, null));
        }
        for (WrappedRevision hostRevision : hostRevisions) {
            for (BundleCapability c : hostRevision.getDeclaredCapabilities(null)) {
                BundleCapability origCap;
                Set<BundleRequirement> dependents;
                if (c.getNamespace().equals("osgi.wiring.host") || (dependents = this.m_dependentMap.get(origCap = ((HostedCapability)c).getDeclaredCapability())) == null) continue;
                dependents = new HashSet<BundleRequirement>(dependents);
                this.m_dependentMap.put(c, dependents);
                for (BundleRequirement r : dependents) {
                    List<BundleCapability> cands = this.m_candidateMap.get(r);
                    if (!(cands instanceof ShadowList)) {
                        ShadowList<BundleCapability> shadow = new ShadowList<BundleCapability>(cands);
                        this.m_candidateMap.put(r, shadow);
                        cands = shadow;
                    }
                    if (!origCap.getRevision().equals(hostRevision.getHost())) {
                        List<BundleCapability> original = ((ShadowList)cands).getOriginal();
                        int removeIdx = original.indexOf(origCap);
                        original.remove(removeIdx);
                        int insertIdx = rc.insertHostedCapability(original, new SimpleHostedCapability(hostRevision.getHost(), origCap));
                        cands.remove(removeIdx);
                        cands.add(insertIdx, c);
                        continue;
                    }
                    int idx = cands.indexOf(origCap);
                    cands.set(idx, c);
                }
            }
            for (BundleRequirement r : hostRevision.getDeclaredRequirements(null)) {
                BundleRequirementImpl origReq = ((WrappedRequirement)r).getOriginalRequirement();
                List<BundleCapability> cands = this.m_candidateMap.get(origReq);
                if (cands == null) continue;
                this.m_candidateMap.put(r, new ArrayList<BundleCapability>(cands));
                for (BundleCapability cand : cands) {
                    Set<BundleRequirement> dependents = this.m_dependentMap.get(cand);
                    dependents.remove(origReq);
                    dependents.add(r);
                }
            }
        }
        for (BundleRevision br : this.m_mandatoryRevisions) {
            if (this.isPopulated(br)) continue;
            throw this.getResolveException(br);
        }
    }

    private Map<BundleCapability, Map<String, Map<Version, List<BundleRequirement>>>> populateDependents() {
        HashMap<BundleCapability, Map<String, Map<Version, List<BundleRequirement>>>> hostFragments = new HashMap<BundleCapability, Map<String, Map<Version, List<BundleRequirement>>>>();
        for (Map.Entry<BundleRequirement, List<BundleCapability>> entry : this.m_candidateMap.entrySet()) {
            BundleRequirement req = entry.getKey();
            List<BundleCapability> caps = entry.getValue();
            for (BundleCapability cap : caps) {
                ArrayList<BundleRequirement> actual;
                TreeMap fragmentVersions;
                Set<BundleRequirement> dependents = this.m_dependentMap.get(cap);
                if (dependents == null) {
                    dependents = new HashSet<BundleRequirement>();
                    this.m_dependentMap.put(cap, dependents);
                }
                dependents.add(req);
                if (!req.getNamespace().equals("osgi.wiring.host")) continue;
                HashMap fragments = (HashMap)hostFragments.get(cap);
                if (fragments == null) {
                    fragments = new HashMap();
                    hostFragments.put(cap, fragments);
                }
                if ((fragmentVersions = (TreeMap)fragments.get(req.getRevision().getSymbolicName())) == null) {
                    fragmentVersions = new TreeMap(Collections.reverseOrder());
                    fragments.put(req.getRevision().getSymbolicName(), fragmentVersions);
                }
                if ((actual = (ArrayList<BundleRequirement>)fragmentVersions.get(req.getRevision().getVersion())) == null) {
                    actual = new ArrayList<BundleRequirement>();
                    fragmentVersions.put(req.getRevision().getVersion(), actual);
                }
                actual.add(req);
            }
        }
        return hostFragments;
    }

    private void removeRevision(BundleRevision revision, ResolveException ex) {
        this.m_populateResultCache.put(revision, ex);
        HashSet<BundleRevision> unresolvedRevisions = new HashSet<BundleRevision>();
        this.remove(revision, unresolvedRevisions);
        while (!unresolvedRevisions.isEmpty()) {
            Iterator it = unresolvedRevisions.iterator();
            revision = (BundleRevision)it.next();
            it.remove();
            this.remove(revision, unresolvedRevisions);
        }
    }

    private void remove(BundleRevision br, Set<BundleRevision> unresolvedRevisions) throws ResolveException {
        for (BundleRequirement r : br.getDeclaredRequirements(null)) {
            this.remove(r);
        }
        for (BundleCapability c : br.getDeclaredCapabilities(null)) {
            this.remove(c, unresolvedRevisions);
        }
    }

    private void remove(BundleRequirement req) {
        boolean isFragment = req.getNamespace().equals("osgi.wiring.host");
        List<BundleCapability> candidates = this.m_candidateMap.remove(req);
        if (candidates != null) {
            for (BundleCapability cap : candidates) {
                Set<BundleRequirement> dependents = this.m_dependentMap.get(cap);
                if (dependents == null) continue;
                dependents.remove(req);
            }
        }
    }

    private void remove(BundleCapability c, Set<BundleRevision> unresolvedRevisions) throws ResolveException {
        Set<BundleRequirement> dependents = this.m_dependentMap.remove(c);
        if (dependents != null) {
            for (BundleRequirement r : dependents) {
                List<BundleCapability> candidates = this.m_candidateMap.get(r);
                candidates.remove(c);
                if (!candidates.isEmpty()) continue;
                this.m_candidateMap.remove(r);
                if (((BundleRequirementImpl)r).isOptional()) continue;
                String msg = "Unable to resolve " + r.getRevision() + ": missing requirement " + r;
                this.m_populateResultCache.put(r.getRevision(), new ResolveException(msg, r.getRevision(), r));
                unresolvedRevisions.add(r.getRevision());
            }
        }
    }

    public Candidates copy() {
        HashMap<BundleCapability, Set<BundleRequirement>> dependentMap = new HashMap<BundleCapability, Set<BundleRequirement>>();
        for (Map.Entry<BundleCapability, Set<BundleRequirement>> entry : this.m_dependentMap.entrySet()) {
            HashSet dependents = new HashSet(entry.getValue());
            dependentMap.put(entry.getKey(), dependents);
        }
        HashMap<BundleRequirement, List<BundleCapability>> candidateMap = new HashMap<BundleRequirement, List<BundleCapability>>();
        for (Map.Entry<BundleRequirement, List<BundleCapability>> entry : this.m_candidateMap.entrySet()) {
            ArrayList candidates = new ArrayList(entry.getValue());
            candidateMap.put(entry.getKey(), candidates);
        }
        return new Candidates(this.m_mandatoryRevisions, dependentMap, candidateMap, this.m_allWrappedHosts, this.m_populateResultCache, this.m_fragmentsPresent);
    }

    public void dump() {
        HashSet<BundleRevision> revisions = new HashSet<BundleRevision>();
        for (Map.Entry<BundleRequirement, List<BundleCapability>> entry : this.m_candidateMap.entrySet()) {
            revisions.add(entry.getKey().getRevision());
        }
        System.out.println("=== BEGIN CANDIDATE MAP ===");
        for (BundleRevision br : revisions) {
            List<BundleCapability> candidates;
            System.out.println("  " + br + " (" + (br.getWiring() != null ? "RESOLVED)" : "UNRESOLVED)"));
            List<BundleRequirement> reqs = br.getWiring() != null ? br.getWiring().getRequirements(null) : br.getDeclaredRequirements(null);
            for (BundleRequirement req : reqs) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println("    " + req + ": " + candidates);
            }
            reqs = br.getWiring() != null ? Util.getDynamicRequirements(br.getWiring().getRequirements(null)) : Util.getDynamicRequirements(br.getDeclaredRequirements(null));
            for (BundleRequirement req : reqs) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println("    " + req + ": " + candidates);
            }
        }
        System.out.println("=== END CANDIDATE MAP ===");
    }
}

