/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;

public class RegexpOptions
implements Cloneable {
    private static ByteList WINDOWS31J = new ByteList(new byte[]{87, 105, 110, 100, 111, 119, 115, 45, 51, 49, 74});
    public static final RegexpOptions NULL_OPTIONS = new RegexpOptions(KCode.NONE, true);
    private KCode kcode;
    private boolean fixed;
    private boolean once;
    private boolean extended;
    private boolean multiline;
    private boolean ignorecase;
    private boolean java;
    private boolean encodingNone;
    private boolean kcodeDefault;
    private boolean literal;

    public RegexpOptions() {
        this(KCode.NONE, true);
    }

    public RegexpOptions(KCode kcode, boolean isKCodeDefault) {
        this.kcode = kcode;
        this.kcodeDefault = isKCodeDefault;
        assert (kcode != null) : "kcode must always be set to something";
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended2) {
        this.extended = extended2;
    }

    public boolean isIgnorecase() {
        return this.ignorecase;
    }

    public void setIgnorecase(boolean ignorecase) {
        this.ignorecase = ignorecase;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public String getKCodeName() {
        return this.isKcodeDefault() ? null : this.getKCode().name().toLowerCase();
    }

    public void setExplicitKCode(KCode kcode) {
        this.kcode = kcode;
        this.kcodeDefault = false;
    }

    private KCode getExplicitKCode() {
        if (this.kcodeDefault) {
            return null;
        }
        return this.kcode;
    }

    public boolean isKcodeDefault() {
        return this.kcodeDefault;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isOnce() {
        return this.once;
    }

    public void setOnce(boolean once) {
        this.once = once;
    }

    public boolean isJava() {
        return this.java;
    }

    public void setJava(boolean java2) {
        this.java = java2;
    }

    public boolean isEncodingNone() {
        return this.encodingNone;
    }

    public void setEncodingNone(boolean encodingNone) {
        this.encodingNone = encodingNone;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setLiteral(boolean literal) {
        this.literal = literal;
    }

    public boolean isEmbeddable() {
        return this.multiline && this.ignorecase && this.extended;
    }

    public Encoding setup(Ruby runtime2) {
        KCode explicitKCode = this.getExplicitKCode();
        if (explicitKCode == KCode.NONE) {
            this.setEncodingNone(true);
            return ASCIIEncoding.INSTANCE;
        }
        if (explicitKCode == KCode.EUC) {
            this.setFixed(true);
            return EUCJPEncoding.INSTANCE;
        }
        if (explicitKCode == KCode.SJIS) {
            this.setFixed(true);
            return runtime2.getEncodingService().loadEncoding(WINDOWS31J);
        }
        if (explicitKCode == KCode.UTF8) {
            this.setFixed(true);
            return UTF8Encoding.INSTANCE;
        }
        return null;
    }

    public int toEmbeddedOptions() {
        int options2 = this.toJoniOptions();
        if (this.once) {
            options2 |= 0x80;
        }
        if (this.literal) {
            options2 |= 0x100;
        }
        if (this.kcodeDefault) {
            options2 |= 0x200;
        }
        if (this.fixed) {
            options2 |= 0x10;
        }
        if (this.encodingNone) {
            options2 |= 0x20;
        }
        return options2;
    }

    public int toJoniOptions() {
        int options2 = 0;
        if (this.multiline) {
            options2 |= 4;
        }
        if (this.ignorecase) {
            options2 |= 1;
        }
        if (this.extended) {
            options2 |= 2;
        }
        return options2;
    }

    public int toOptions() {
        int options2 = 0;
        if (this.multiline) {
            options2 |= 4;
        }
        if (this.ignorecase) {
            options2 |= 1;
        }
        if (this.extended) {
            options2 |= 2;
        }
        if (this.fixed) {
            options2 |= 0x10;
        }
        if (this.encodingNone) {
            options2 |= 0x20;
        }
        return options2;
    }

    public static RegexpOptions fromEmbeddedOptions(int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromJoniOptions(embeddedOptions);
        options2.kcodeDefault = (embeddedOptions & 0x200) != 0;
        options2.setOnce((embeddedOptions & 0x80) != 0);
        options2.setLiteral((embeddedOptions & 0x100) != 0);
        options2.setFixed((embeddedOptions & 0x10) != 0);
        options2.setEncodingNone((embeddedOptions & 0x20) != 0);
        return options2;
    }

    public static RegexpOptions fromJoniOptions(int joniOptions) {
        RegexpOptions options2 = new RegexpOptions();
        options2.setMultiline((joniOptions & 4) != 0);
        options2.setIgnorecase((joniOptions & 1) != 0);
        options2.setExtended((joniOptions & 2) != 0);
        options2.setFixed((joniOptions & 0x10) != 0);
        options2.setOnce((joniOptions & 0x80) != 0);
        return options2;
    }

    public RegexpOptions withoutOnce() {
        RegexpOptions options2 = (RegexpOptions)this.clone();
        options2.setOnce(false);
        return options2;
    }

    public int hashCode() {
        int hash2 = 7;
        hash2 = 11 * hash2 + (this.kcode != null ? this.kcode.hashCode() : 0);
        hash2 = 11 * hash2 + (this.fixed ? 1 : 0);
        hash2 = 11 * hash2 + (this.once ? 1 : 0);
        hash2 = 11 * hash2 + (this.extended ? 1 : 0);
        hash2 = 11 * hash2 + (this.multiline ? 1 : 0);
        hash2 = 11 * hash2 + (this.ignorecase ? 1 : 0);
        hash2 = 11 * hash2 + (this.java ? 1 : 0);
        hash2 = 11 * hash2 + (this.encodingNone ? 1 : 0);
        hash2 = 11 * hash2 + (this.kcodeDefault ? 1 : 0);
        hash2 = 11 * hash2 + (this.literal ? 1 : 0);
        return hash2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public boolean equals(Object other) {
        boolean equality;
        if (!(other instanceof RegexpOptions)) {
            return false;
        }
        RegexpOptions o = (RegexpOptions)other;
        boolean bl = equality = o.extended == this.extended && o.fixed == this.fixed && o.ignorecase == this.ignorecase && o.java == this.java && o.multiline == this.multiline;
        if (this.encodingNone || o.encodingNone) {
            return equality && o.kcode == this.kcode;
        }
        return equality && o.encodingNone == this.encodingNone && o.kcode == this.kcode && o.kcodeDefault == this.kcodeDefault;
    }

    public String toString() {
        return "RegexpOptions(kcode: " + (Object)((Object)this.kcode) + (this.encodingNone ? ", encodingNone" : "") + (this.extended ? ", extended" : "") + (this.fixed ? ", fixed" : "") + (this.ignorecase ? ", ignorecase" : "") + (this.java ? ", java" : "") + (this.kcodeDefault ? ", kcodeDefault" : "") + (this.literal ? ", literal" : "") + (this.multiline ? ", multiline" : "") + (this.once ? ", once" : "") + ")";
    }
}

