/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class MetricConfig
implements Writeable,
ToXContentFragment {
    private static final String NAME = "metric_config";
    private String field;
    private List<String> metrics;
    private static final ParseField FIELD = new ParseField("field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    private static final ParseField MIN = new ParseField("min", new String[0]);
    private static final ParseField MAX = new ParseField("max", new String[0]);
    private static final ParseField SUM = new ParseField("sum", new String[0]);
    private static final ParseField AVG = new ParseField("avg", new String[0]);
    private static final ParseField VALUE_COUNT = new ParseField("value_count", new String[0]);
    private static final List<String> MAPPER_TYPES;
    public static final ConstructingObjectParser<MetricConfig, Void> PARSER;

    MetricConfig(String name, List<String> metrics) {
        this.field = name;
        this.metrics = metrics;
    }

    MetricConfig(StreamInput in) throws IOException {
        this.field = in.readString();
        this.metrics = in.readList(StreamInput::readString);
    }

    public String getField() {
        return this.field;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    public List<ValuesSourceAggregationBuilder.LeafOnly> toBuilders() {
        if (this.metrics.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValuesSourceAggregationBuilder.LeafOnly> aggs = new ArrayList<ValuesSourceAggregationBuilder.LeafOnly>(this.metrics.size());
        for (String metric : this.metrics) {
            MinAggregationBuilder newBuilder;
            if (metric.equals(MIN.getPreferredName())) {
                newBuilder = new MinAggregationBuilder(RollupField.formatFieldName(this.field, "min", "value"));
            } else if (metric.equals(MAX.getPreferredName())) {
                newBuilder = new MaxAggregationBuilder(RollupField.formatFieldName(this.field, "max", "value"));
            } else if (metric.equals(AVG.getPreferredName())) {
                newBuilder = new SumAggregationBuilder(RollupField.formatFieldName(this.field, "avg", "value"));
                ValueCountAggregationBuilder countBuilder = new ValueCountAggregationBuilder(RollupField.formatFieldName(this.field, "avg", "_count"), ValueType.NUMERIC);
                countBuilder.field(this.field);
                aggs.add((ValuesSourceAggregationBuilder.LeafOnly)countBuilder);
            } else if (metric.equals(SUM.getPreferredName())) {
                newBuilder = new SumAggregationBuilder(RollupField.formatFieldName(this.field, "sum", "value"));
            } else if (metric.equals(VALUE_COUNT.getPreferredName())) {
                newBuilder = new ValueCountAggregationBuilder(RollupField.formatFieldName(this.field, "value_count", "value"), ValueType.NUMERIC);
            } else {
                throw new IllegalArgumentException("Unsupported metric type [" + metric + "]");
            }
            newBuilder.field(this.field);
            aggs.add((ValuesSourceAggregationBuilder.LeafOnly)newBuilder);
        }
        return aggs;
    }

    public List<Map<String, Object>> toAggCap() {
        return this.metrics.stream().map(metric -> Collections.singletonMap("agg", metric)).collect(Collectors.toList());
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Map<String, FieldCapabilities> fieldCaps = fieldCapsResponse.get(this.field);
        if (fieldCaps != null && !fieldCaps.isEmpty()) {
            fieldCaps.forEach((key, value) -> {
                if (MAPPER_TYPES.contains(key)) {
                    if (!value.isAggregatable()) {
                        validationException.addValidationError("The field [" + this.field + "] must be aggregatable across all indices, but is not.");
                    }
                } else {
                    validationException.addValidationError("The field referenced by a metric group must be a [numeric] type, but found " + fieldCaps.keySet().toString() + " for field [" + this.field + "]");
                }
            });
        } else {
            validationException.addValidationError("Could not find a [numeric] field with name [" + this.field + "] in any of the indices matching the index pattern.");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(METRICS.getPreferredName(), this.metrics);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeStringList(this.metrics);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetricConfig that = (MetricConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.metrics);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        List types = Stream.of(NumberFieldMapper.NumberType.values()).map(NumberFieldMapper.NumberType::typeName).collect(Collectors.toList());
        types.add("scaled_float");
        MAPPER_TYPES = types;
        PARSER = new ConstructingObjectParser(NAME, a -> new MetricConfig((String)a[0], (List)a[1]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), METRICS);
    }

    public static class Builder {
        private String field;
        private List<String> metrics;

        public Builder() {
        }

        public Builder(MetricConfig config) {
            this.field = config.getField();
            this.metrics = config.getMetrics();
        }

        public String getField() {
            return this.field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public List<String> getMetrics() {
            return this.metrics;
        }

        public Builder setMetrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public MetricConfig build() {
            if (Strings.isNullOrEmpty((String)this.field)) {
                throw new IllegalArgumentException("Parameter [" + FIELD.getPreferredName() + "] must be a non-null, non-empty string.");
            }
            if (this.metrics == null || this.metrics.isEmpty()) {
                throw new IllegalArgumentException("Parameter [" + METRICS.getPreferredName() + "] must be a non-null, non-empty array of strings.");
            }
            this.metrics.forEach(m -> {
                if (!RollupField.SUPPORTED_METRICS.contains(m)) {
                    throw new IllegalArgumentException("Unsupported metric [" + m + "].  Supported metrics include: " + RollupField.SUPPORTED_METRICS);
                }
            });
            return new MetricConfig(this.field, this.metrics);
        }
    }
}

