// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Descriptor_h__
#define __IceGrid_Descriptor_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class CommunicatorDescriptor;
class ServerDescriptor;
class ServiceDescriptor;
class IceBoxDescriptor;
class LoadBalancingPolicy;
class RandomLoadBalancingPolicy;
class OrderedLoadBalancingPolicy;
class RoundRobinLoadBalancingPolicy;
class AdaptiveLoadBalancingPolicy;
class BoxedString;
class BoxedDistributionDescriptor;

}

namespace IceGrid
{

using StringStringDict = ::std::map<::std::string, ::std::string>;

struct PropertyDescriptor
{
    ::std::string name;
    ::std::string value;

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, value);
    }
};

using PropertyDescriptorSeq = ::std::vector<::IceGrid::PropertyDescriptor>;

struct PropertySetDescriptor
{
    ::Ice::StringSeq references;
    ::IceGrid::PropertyDescriptorSeq properties;

    std::tuple<const ::Ice::StringSeq&, const ::IceGrid::PropertyDescriptorSeq&> ice_tuple() const
    {
        return std::tie(references, properties);
    }
};

using PropertySetDescriptorDict = ::std::map<::std::string, ::IceGrid::PropertySetDescriptor>;

struct ObjectDescriptor
{
    ::Ice::Identity id;
    ::std::string type;
    ::std::string proxyOptions;

    std::tuple<const ::Ice::Identity&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, type, proxyOptions);
    }
};

using ObjectDescriptorSeq = ::std::vector<::IceGrid::ObjectDescriptor>;

struct AdapterDescriptor
{
    ::std::string name;
    ::std::string description;
    ::std::string id;
    ::std::string replicaGroupId;
    ::std::string priority;
    bool registerProcess;
    bool serverLifetime;
    ::IceGrid::ObjectDescriptorSeq objects;
    ::IceGrid::ObjectDescriptorSeq allocatables;

    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const bool&, const ::IceGrid::ObjectDescriptorSeq&, const ::IceGrid::ObjectDescriptorSeq&> ice_tuple() const
    {
        return std::tie(name, description, id, replicaGroupId, priority, registerProcess, serverLifetime, objects, allocatables);
    }
};

using AdapterDescriptorSeq = ::std::vector<::IceGrid::AdapterDescriptor>;

struct DbEnvDescriptor
{
    ::std::string name;
    ::std::string description;
    ::std::string dbHome;
    ::IceGrid::PropertyDescriptorSeq properties;

    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const ::IceGrid::PropertyDescriptorSeq&> ice_tuple() const
    {
        return std::tie(name, description, dbHome, properties);
    }
};

using DbEnvDescriptorSeq = ::std::vector<::IceGrid::DbEnvDescriptor>;

struct DistributionDescriptor
{
    ::std::string icepatch;
    ::Ice::StringSeq directories;

    std::tuple<const ::std::string&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(icepatch, directories);
    }
};

using ServerDescriptorSeq = ::std::vector<::std::shared_ptr<::IceGrid::ServerDescriptor>>;

using ServiceDescriptorSeq = ::std::vector<::std::shared_ptr<::IceGrid::ServiceDescriptor>>;

struct ServerInstanceDescriptor
{
    ::std::string _cpp_template;
    ::IceGrid::StringStringDict parameterValues;
    ::IceGrid::PropertySetDescriptor propertySet;
    ::IceGrid::PropertySetDescriptorDict servicePropertySets;

    std::tuple<const ::std::string&, const ::IceGrid::StringStringDict&, const ::IceGrid::PropertySetDescriptor&, const ::IceGrid::PropertySetDescriptorDict&> ice_tuple() const
    {
        return std::tie(_cpp_template, parameterValues, propertySet, servicePropertySets);
    }
};

using ServerInstanceDescriptorSeq = ::std::vector<::IceGrid::ServerInstanceDescriptor>;

struct TemplateDescriptor
{
    ::std::shared_ptr<::IceGrid::CommunicatorDescriptor> descriptor;
    ::Ice::StringSeq parameters;
    ::IceGrid::StringStringDict parameterDefaults;

    std::tuple<const ::std::shared_ptr<::IceGrid::CommunicatorDescriptor>&, const ::Ice::StringSeq&, const ::IceGrid::StringStringDict&> ice_tuple() const
    {
        return std::tie(descriptor, parameters, parameterDefaults);
    }
};

using TemplateDescriptorDict = ::std::map<::std::string, ::IceGrid::TemplateDescriptor>;

struct ServiceInstanceDescriptor
{
    ::std::string _cpp_template;
    ::IceGrid::StringStringDict parameterValues;
    ::std::shared_ptr<::IceGrid::ServiceDescriptor> descriptor;
    ::IceGrid::PropertySetDescriptor propertySet;

    std::tuple<const ::std::string&, const ::IceGrid::StringStringDict&, const ::std::shared_ptr<::IceGrid::ServiceDescriptor>&, const ::IceGrid::PropertySetDescriptor&> ice_tuple() const
    {
        return std::tie(_cpp_template, parameterValues, descriptor, propertySet);
    }
};

using ServiceInstanceDescriptorSeq = ::std::vector<::IceGrid::ServiceInstanceDescriptor>;

struct NodeDescriptor
{
    ::IceGrid::StringStringDict variables;
    ::IceGrid::ServerInstanceDescriptorSeq serverInstances;
    ::IceGrid::ServerDescriptorSeq servers;
    ::std::string loadFactor;
    ::std::string description;
    ::IceGrid::PropertySetDescriptorDict propertySets;

    std::tuple<const ::IceGrid::StringStringDict&, const ::IceGrid::ServerInstanceDescriptorSeq&, const ::IceGrid::ServerDescriptorSeq&, const ::std::string&, const ::std::string&, const ::IceGrid::PropertySetDescriptorDict&> ice_tuple() const
    {
        return std::tie(variables, serverInstances, servers, loadFactor, description, propertySets);
    }
};

using NodeDescriptorDict = ::std::map<::std::string, ::IceGrid::NodeDescriptor>;

struct ReplicaGroupDescriptor
{
    ::std::string id;
    ::std::shared_ptr<::IceGrid::LoadBalancingPolicy> loadBalancing;
    ::std::string proxyOptions;
    ::IceGrid::ObjectDescriptorSeq objects;
    ::std::string description;
    ::std::string filter;

    std::tuple<const ::std::string&, const ::std::shared_ptr<::IceGrid::LoadBalancingPolicy>&, const ::std::string&, const ::IceGrid::ObjectDescriptorSeq&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, loadBalancing, proxyOptions, objects, description, filter);
    }
};

using ReplicaGroupDescriptorSeq = ::std::vector<::IceGrid::ReplicaGroupDescriptor>;

struct ApplicationDescriptor
{
    ::std::string name;
    ::IceGrid::StringStringDict variables;
    ::IceGrid::ReplicaGroupDescriptorSeq replicaGroups;
    ::IceGrid::TemplateDescriptorDict serverTemplates;
    ::IceGrid::TemplateDescriptorDict serviceTemplates;
    ::IceGrid::NodeDescriptorDict nodes;
    ::IceGrid::DistributionDescriptor distrib;
    ::std::string description;
    ::IceGrid::PropertySetDescriptorDict propertySets;

    std::tuple<const ::std::string&, const ::IceGrid::StringStringDict&, const ::IceGrid::ReplicaGroupDescriptorSeq&, const ::IceGrid::TemplateDescriptorDict&, const ::IceGrid::TemplateDescriptorDict&, const ::IceGrid::NodeDescriptorDict&, const ::IceGrid::DistributionDescriptor&, const ::std::string&, const ::IceGrid::PropertySetDescriptorDict&> ice_tuple() const
    {
        return std::tie(name, variables, replicaGroups, serverTemplates, serviceTemplates, nodes, distrib, description, propertySets);
    }
};

using ApplicationDescriptorSeq = ::std::vector<::IceGrid::ApplicationDescriptor>;

struct NodeUpdateDescriptor
{
    ::std::string name;
    ::std::shared_ptr<::IceGrid::BoxedString> description;
    ::IceGrid::StringStringDict variables;
    ::Ice::StringSeq removeVariables;
    ::IceGrid::PropertySetDescriptorDict propertySets;
    ::Ice::StringSeq removePropertySets;
    ::IceGrid::ServerInstanceDescriptorSeq serverInstances;
    ::IceGrid::ServerDescriptorSeq servers;
    ::Ice::StringSeq removeServers;
    ::std::shared_ptr<::IceGrid::BoxedString> loadFactor;

    std::tuple<const ::std::string&, const ::std::shared_ptr<::IceGrid::BoxedString>&, const ::IceGrid::StringStringDict&, const ::Ice::StringSeq&, const ::IceGrid::PropertySetDescriptorDict&, const ::Ice::StringSeq&, const ::IceGrid::ServerInstanceDescriptorSeq&, const ::IceGrid::ServerDescriptorSeq&, const ::Ice::StringSeq&, const ::std::shared_ptr<::IceGrid::BoxedString>&> ice_tuple() const
    {
        return std::tie(name, description, variables, removeVariables, propertySets, removePropertySets, serverInstances, servers, removeServers, loadFactor);
    }
};

using NodeUpdateDescriptorSeq = ::std::vector<::IceGrid::NodeUpdateDescriptor>;

struct ApplicationUpdateDescriptor
{
    ::std::string name;
    ::std::shared_ptr<::IceGrid::BoxedString> description;
    ::std::shared_ptr<::IceGrid::BoxedDistributionDescriptor> distrib;
    ::IceGrid::StringStringDict variables;
    ::Ice::StringSeq removeVariables;
    ::IceGrid::PropertySetDescriptorDict propertySets;
    ::Ice::StringSeq removePropertySets;
    ::IceGrid::ReplicaGroupDescriptorSeq replicaGroups;
    ::Ice::StringSeq removeReplicaGroups;
    ::IceGrid::TemplateDescriptorDict serverTemplates;
    ::Ice::StringSeq removeServerTemplates;
    ::IceGrid::TemplateDescriptorDict serviceTemplates;
    ::Ice::StringSeq removeServiceTemplates;
    ::IceGrid::NodeUpdateDescriptorSeq nodes;
    ::Ice::StringSeq removeNodes;

    std::tuple<const ::std::string&, const ::std::shared_ptr<::IceGrid::BoxedString>&, const ::std::shared_ptr<::IceGrid::BoxedDistributionDescriptor>&, const ::IceGrid::StringStringDict&, const ::Ice::StringSeq&, const ::IceGrid::PropertySetDescriptorDict&, const ::Ice::StringSeq&, const ::IceGrid::ReplicaGroupDescriptorSeq&, const ::Ice::StringSeq&, const ::IceGrid::TemplateDescriptorDict&, const ::Ice::StringSeq&, const ::IceGrid::TemplateDescriptorDict&, const ::Ice::StringSeq&, const ::IceGrid::NodeUpdateDescriptorSeq&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(name, description, distrib, variables, removeVariables, propertySets, removePropertySets, replicaGroups, removeReplicaGroups, serverTemplates, removeServerTemplates, serviceTemplates, removeServiceTemplates, nodes, removeNodes);
    }
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) CommunicatorDescriptor : public ::Ice::ValueHelper<CommunicatorDescriptor, Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~CommunicatorDescriptor();

    CommunicatorDescriptor() = default;

    CommunicatorDescriptor(const CommunicatorDescriptor&) = default;
    CommunicatorDescriptor(CommunicatorDescriptor&&) = default;
    CommunicatorDescriptor& operator=(const CommunicatorDescriptor&) = default;
    CommunicatorDescriptor& operator=(CommunicatorDescriptor&&) = default;

    CommunicatorDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description) :
        adapters(::std::move(iceP_adapters)),
        propertySet(::std::move(iceP_propertySet)),
        dbEnvs(::std::move(iceP_dbEnvs)),
        logs(::std::move(iceP_logs)),
        description(::std::move(iceP_description))
    {
    }

    std::tuple<const ::IceGrid::AdapterDescriptorSeq&, const ::IceGrid::PropertySetDescriptor&, const ::IceGrid::DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::IceGrid::AdapterDescriptorSeq adapters;
    ::IceGrid::PropertySetDescriptor propertySet;
    ::IceGrid::DbEnvDescriptorSeq dbEnvs;
    ::Ice::StringSeq logs;
    ::std::string description;
};

static CommunicatorDescriptor _iceS_CommunicatorDescriptor_init;

class ICE_CLASS(ICEGRID_API) ServerDescriptor : public ::Ice::ValueHelper<ServerDescriptor, ::IceGrid::CommunicatorDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerDescriptor();

    ServerDescriptor() = default;

    ServerDescriptor(const ServerDescriptor&) = default;
    ServerDescriptor(ServerDescriptor&&) = default;
    ServerDescriptor& operator=(const ServerDescriptor&) = default;
    ServerDescriptor& operator=(ServerDescriptor&&) = default;

    ServerDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description, const ::std::string& iceP_id, const ::std::string& iceP_exe, const ::std::string& iceP_iceVersion, const ::std::string& iceP_pwd, const ::Ice::StringSeq& iceP_options, const ::Ice::StringSeq& iceP_envs, const ::std::string& iceP_activation, const ::std::string& iceP_activationTimeout, const ::std::string& iceP_deactivationTimeout, bool iceP_applicationDistrib, const ::IceGrid::DistributionDescriptor& iceP_distrib, bool iceP_allocatable, const ::std::string& iceP_user) :
        Ice::ValueHelper<::IceGrid::ServerDescriptor, ::IceGrid::CommunicatorDescriptor>(::std::move(iceP_adapters), ::std::move(iceP_propertySet), ::std::move(iceP_dbEnvs), ::std::move(iceP_logs), ::std::move(iceP_description)),
        id(::std::move(iceP_id)),
        exe(::std::move(iceP_exe)),
        iceVersion(::std::move(iceP_iceVersion)),
        pwd(::std::move(iceP_pwd)),
        options(::std::move(iceP_options)),
        envs(::std::move(iceP_envs)),
        activation(::std::move(iceP_activation)),
        activationTimeout(::std::move(iceP_activationTimeout)),
        deactivationTimeout(::std::move(iceP_deactivationTimeout)),
        applicationDistrib(iceP_applicationDistrib),
        distrib(::std::move(iceP_distrib)),
        allocatable(iceP_allocatable),
        user(::std::move(iceP_user))
    {
    }

    std::tuple<const ::IceGrid::AdapterDescriptorSeq&, const ::IceGrid::PropertySetDescriptor&, const ::IceGrid::DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::StringSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const ::IceGrid::DistributionDescriptor&, const bool&, const ::std::string&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description, id, exe, iceVersion, pwd, options, envs, activation, activationTimeout, deactivationTimeout, applicationDistrib, distrib, allocatable, user);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string id;
    ::std::string exe;
    ::std::string iceVersion;
    ::std::string pwd;
    ::Ice::StringSeq options;
    ::Ice::StringSeq envs;
    ::std::string activation;
    ::std::string activationTimeout;
    ::std::string deactivationTimeout;
    bool applicationDistrib;
    ::IceGrid::DistributionDescriptor distrib;
    bool allocatable;
    ::std::string user;
};

class ICE_CLASS(ICEGRID_API) ServiceDescriptor : public ::Ice::ValueHelper<ServiceDescriptor, ::IceGrid::CommunicatorDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServiceDescriptor();

    ServiceDescriptor() = default;

    ServiceDescriptor(const ServiceDescriptor&) = default;
    ServiceDescriptor(ServiceDescriptor&&) = default;
    ServiceDescriptor& operator=(const ServiceDescriptor&) = default;
    ServiceDescriptor& operator=(ServiceDescriptor&&) = default;

    ServiceDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description, const ::std::string& iceP_name, const ::std::string& iceP_entry) :
        Ice::ValueHelper<::IceGrid::ServiceDescriptor, ::IceGrid::CommunicatorDescriptor>(::std::move(iceP_adapters), ::std::move(iceP_propertySet), ::std::move(iceP_dbEnvs), ::std::move(iceP_logs), ::std::move(iceP_description)),
        name(::std::move(iceP_name)),
        entry(::std::move(iceP_entry))
    {
    }

    std::tuple<const ::IceGrid::AdapterDescriptorSeq&, const ::IceGrid::PropertySetDescriptor&, const ::IceGrid::DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description, name, entry);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
    ::std::string entry;
};

class ICE_CLASS(ICEGRID_API) IceBoxDescriptor : public ::Ice::ValueHelper<IceBoxDescriptor, ::IceGrid::ServerDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~IceBoxDescriptor();

    IceBoxDescriptor() = default;

    IceBoxDescriptor(const IceBoxDescriptor&) = default;
    IceBoxDescriptor(IceBoxDescriptor&&) = default;
    IceBoxDescriptor& operator=(const IceBoxDescriptor&) = default;
    IceBoxDescriptor& operator=(IceBoxDescriptor&&) = default;

    IceBoxDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description, const ::std::string& iceP_id, const ::std::string& iceP_exe, const ::std::string& iceP_iceVersion, const ::std::string& iceP_pwd, const ::Ice::StringSeq& iceP_options, const ::Ice::StringSeq& iceP_envs, const ::std::string& iceP_activation, const ::std::string& iceP_activationTimeout, const ::std::string& iceP_deactivationTimeout, bool iceP_applicationDistrib, const ::IceGrid::DistributionDescriptor& iceP_distrib, bool iceP_allocatable, const ::std::string& iceP_user, const ::IceGrid::ServiceInstanceDescriptorSeq& iceP_services) :
        Ice::ValueHelper<::IceGrid::IceBoxDescriptor, ::IceGrid::ServerDescriptor>(::std::move(iceP_adapters), ::std::move(iceP_propertySet), ::std::move(iceP_dbEnvs), ::std::move(iceP_logs), ::std::move(iceP_description), ::std::move(iceP_id), ::std::move(iceP_exe), ::std::move(iceP_iceVersion), ::std::move(iceP_pwd), ::std::move(iceP_options), ::std::move(iceP_envs), ::std::move(iceP_activation), ::std::move(iceP_activationTimeout), ::std::move(iceP_deactivationTimeout), iceP_applicationDistrib, ::std::move(iceP_distrib), iceP_allocatable, ::std::move(iceP_user)),
        services(::std::move(iceP_services))
    {
    }

    std::tuple<const ::IceGrid::AdapterDescriptorSeq&, const ::IceGrid::PropertySetDescriptor&, const ::IceGrid::DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::StringSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const ::IceGrid::DistributionDescriptor&, const bool&, const ::std::string&, const ::IceGrid::ServiceInstanceDescriptorSeq&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description, id, exe, iceVersion, pwd, options, envs, activation, activationTimeout, deactivationTimeout, applicationDistrib, distrib, allocatable, user, services);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::IceGrid::ServiceInstanceDescriptorSeq services;
};

class ICE_CLASS(ICEGRID_API) LoadBalancingPolicy : public ::Ice::ValueHelper<LoadBalancingPolicy, Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~LoadBalancingPolicy();

    LoadBalancingPolicy() = default;

    LoadBalancingPolicy(const LoadBalancingPolicy&) = default;
    LoadBalancingPolicy(LoadBalancingPolicy&&) = default;
    LoadBalancingPolicy& operator=(const LoadBalancingPolicy&) = default;
    LoadBalancingPolicy& operator=(LoadBalancingPolicy&&) = default;

    explicit LoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        nReplicas(::std::move(iceP_nReplicas))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string nReplicas;
};

class ICE_CLASS(ICEGRID_API) RandomLoadBalancingPolicy : public ::Ice::ValueHelper<RandomLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RandomLoadBalancingPolicy();

    RandomLoadBalancingPolicy() = default;

    RandomLoadBalancingPolicy(const RandomLoadBalancingPolicy&) = default;
    RandomLoadBalancingPolicy(RandomLoadBalancingPolicy&&) = default;
    RandomLoadBalancingPolicy& operator=(const RandomLoadBalancingPolicy&) = default;
    RandomLoadBalancingPolicy& operator=(RandomLoadBalancingPolicy&&) = default;

    explicit RandomLoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        Ice::ValueHelper<::IceGrid::RandomLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>(::std::move(iceP_nReplicas))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICEGRID_API) OrderedLoadBalancingPolicy : public ::Ice::ValueHelper<OrderedLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~OrderedLoadBalancingPolicy();

    OrderedLoadBalancingPolicy() = default;

    OrderedLoadBalancingPolicy(const OrderedLoadBalancingPolicy&) = default;
    OrderedLoadBalancingPolicy(OrderedLoadBalancingPolicy&&) = default;
    OrderedLoadBalancingPolicy& operator=(const OrderedLoadBalancingPolicy&) = default;
    OrderedLoadBalancingPolicy& operator=(OrderedLoadBalancingPolicy&&) = default;

    explicit OrderedLoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        Ice::ValueHelper<::IceGrid::OrderedLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>(::std::move(iceP_nReplicas))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICEGRID_API) RoundRobinLoadBalancingPolicy : public ::Ice::ValueHelper<RoundRobinLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RoundRobinLoadBalancingPolicy();

    RoundRobinLoadBalancingPolicy() = default;

    RoundRobinLoadBalancingPolicy(const RoundRobinLoadBalancingPolicy&) = default;
    RoundRobinLoadBalancingPolicy(RoundRobinLoadBalancingPolicy&&) = default;
    RoundRobinLoadBalancingPolicy& operator=(const RoundRobinLoadBalancingPolicy&) = default;
    RoundRobinLoadBalancingPolicy& operator=(RoundRobinLoadBalancingPolicy&&) = default;

    explicit RoundRobinLoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        Ice::ValueHelper<::IceGrid::RoundRobinLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>(::std::move(iceP_nReplicas))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICEGRID_API) AdaptiveLoadBalancingPolicy : public ::Ice::ValueHelper<AdaptiveLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AdaptiveLoadBalancingPolicy();

    AdaptiveLoadBalancingPolicy() = default;

    AdaptiveLoadBalancingPolicy(const AdaptiveLoadBalancingPolicy&) = default;
    AdaptiveLoadBalancingPolicy(AdaptiveLoadBalancingPolicy&&) = default;
    AdaptiveLoadBalancingPolicy& operator=(const AdaptiveLoadBalancingPolicy&) = default;
    AdaptiveLoadBalancingPolicy& operator=(AdaptiveLoadBalancingPolicy&&) = default;

    AdaptiveLoadBalancingPolicy(const ::std::string& iceP_nReplicas, const ::std::string& iceP_loadSample) :
        Ice::ValueHelper<::IceGrid::AdaptiveLoadBalancingPolicy, ::IceGrid::LoadBalancingPolicy>(::std::move(iceP_nReplicas)),
        loadSample(::std::move(iceP_loadSample))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas, loadSample);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string loadSample;
};

class ICE_CLASS(ICEGRID_API) BoxedString : public ::Ice::ValueHelper<BoxedString, Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~BoxedString();

    BoxedString() = default;

    BoxedString(const BoxedString&) = default;
    BoxedString(BoxedString&&) = default;
    BoxedString& operator=(const BoxedString&) = default;
    BoxedString& operator=(BoxedString&&) = default;

    explicit BoxedString(const ::std::string& iceP_value) :
        value(::std::move(iceP_value))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(value);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string value;
};

class ICE_CLASS(ICEGRID_API) BoxedDistributionDescriptor : public ::Ice::ValueHelper<BoxedDistributionDescriptor, Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~BoxedDistributionDescriptor();

    BoxedDistributionDescriptor() = default;

    BoxedDistributionDescriptor(const BoxedDistributionDescriptor&) = default;
    BoxedDistributionDescriptor(BoxedDistributionDescriptor&&) = default;
    BoxedDistributionDescriptor& operator=(const BoxedDistributionDescriptor&) = default;
    BoxedDistributionDescriptor& operator=(BoxedDistributionDescriptor&&) = default;

    explicit BoxedDistributionDescriptor(const ::IceGrid::DistributionDescriptor& iceP_value) :
        value(::std::move(iceP_value))
    {
    }

    std::tuple<const ::IceGrid::DistributionDescriptor&> ice_tuple() const
    {
        return std::tie(value);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::IceGrid::DistributionDescriptor value;
};

}

namespace IceGrid
{

}

namespace Ice
{

template<>
struct StreamableTraits<::IceGrid::PropertyDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::PropertyDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertyDescriptor& v)
    {
        istr->readAll(v.name, v.value);
    }
};

template<>
struct StreamableTraits<::IceGrid::PropertySetDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::PropertySetDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertySetDescriptor& v)
    {
        istr->readAll(v.references, v.properties);
    }
};

template<>
struct StreamableTraits<::IceGrid::ObjectDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ObjectDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ObjectDescriptor& v)
    {
        istr->readAll(v.id, v.type, v.proxyOptions);
    }
};

template<>
struct StreamableTraits<::IceGrid::AdapterDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::AdapterDescriptor, S>
{
    static void read(S* istr, ::IceGrid::AdapterDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.id, v.replicaGroupId, v.priority, v.registerProcess, v.serverLifetime, v.objects, v.allocatables);
    }
};

template<>
struct StreamableTraits<::IceGrid::DbEnvDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::DbEnvDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DbEnvDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.dbHome, v.properties);
    }
};

template<typename S>
struct StreamReader<::IceGrid::CommunicatorDescriptor, S>
{
    static void read(S* istr, ::IceGrid::CommunicatorDescriptor& v)
    {
        istr->readAll(v.adapters, v.propertySet, v.dbEnvs, v.logs, v.description);
    }
};

template<>
struct StreamableTraits<::IceGrid::DistributionDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::DistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DistributionDescriptor& v)
    {
        istr->readAll(v.icepatch, v.directories);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::ServerDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServerDescriptor& v)
    {
        ostr->writeAll(v.id, v.exe, v.iceVersion, v.pwd, v.options, v.envs, v.activation, v.activationTimeout, v.deactivationTimeout, v.applicationDistrib, v.distrib, v.allocatable, v.user);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerDescriptor& v)
    {
        istr->readAll(v.id, v.exe, v.iceVersion, v.pwd, v.options, v.envs, v.activation, v.activationTimeout, v.deactivationTimeout, v.applicationDistrib, v.distrib, v.allocatable, v.user);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::ServiceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServiceDescriptor& v)
    {
        ostr->writeAll(v.name, v.entry);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServiceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceDescriptor& v)
    {
        istr->readAll(v.name, v.entry);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServerInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServerInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerInstanceDescriptor& v)
    {
        istr->readAll(v._cpp_template, v.parameterValues, v.propertySet, v.servicePropertySets);
    }
};

template<>
struct StreamableTraits<::IceGrid::TemplateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::TemplateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::TemplateDescriptor& v)
    {
        istr->readAll(v.descriptor, v.parameters, v.parameterDefaults);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServiceInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServiceInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceInstanceDescriptor& v)
    {
        istr->readAll(v._cpp_template, v.parameterValues, v.descriptor, v.propertySet);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::IceBoxDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::IceBoxDescriptor& v)
    {
        ostr->writeAll(v.services);
    }
};

template<typename S>
struct StreamReader<::IceGrid::IceBoxDescriptor, S>
{
    static void read(S* istr, ::IceGrid::IceBoxDescriptor& v)
    {
        istr->readAll(v.services);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeDescriptor& v)
    {
        istr->readAll(v.variables, v.serverInstances, v.servers, v.loadFactor, v.description, v.propertySets);
    }
};

template<typename S>
struct StreamReader<::IceGrid::LoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::LoadBalancingPolicy& v)
    {
        istr->readAll(v.nReplicas);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::RandomLoadBalancingPolicy, S>
{
    static void write(S*, const ::IceGrid::RandomLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::RandomLoadBalancingPolicy, S>
{
    static void read(S*, ::IceGrid::RandomLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceGrid::OrderedLoadBalancingPolicy, S>
{
    static void write(S*, const ::IceGrid::OrderedLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::OrderedLoadBalancingPolicy, S>
{
    static void read(S*, ::IceGrid::OrderedLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceGrid::RoundRobinLoadBalancingPolicy, S>
{
    static void write(S*, const ::IceGrid::RoundRobinLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::RoundRobinLoadBalancingPolicy, S>
{
    static void read(S*, ::IceGrid::RoundRobinLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void write(S* ostr, const ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        ostr->writeAll(v.loadSample);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        istr->readAll(v.loadSample);
    }
};

template<>
struct StreamableTraits<::IceGrid::ReplicaGroupDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ReplicaGroupDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ReplicaGroupDescriptor& v)
    {
        istr->readAll(v.id, v.loadBalancing, v.proxyOptions, v.objects, v.description, v.filter);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationDescriptor& v)
    {
        istr->readAll(v.name, v.variables, v.replicaGroups, v.serverTemplates, v.serviceTemplates, v.nodes, v.distrib, v.description, v.propertySets);
    }
};

template<typename S>
struct StreamReader<::IceGrid::BoxedString, S>
{
    static void read(S* istr, ::IceGrid::BoxedString& v)
    {
        istr->readAll(v.value);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeUpdateDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.variables, v.removeVariables, v.propertySets, v.removePropertySets, v.serverInstances, v.servers, v.removeServers, v.loadFactor);
    }
};

template<typename S>
struct StreamReader<::IceGrid::BoxedDistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::BoxedDistributionDescriptor& v)
    {
        istr->readAll(v.value);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 15;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.distrib, v.variables, v.removeVariables, v.propertySets, v.removePropertySets, v.replicaGroups, v.removeReplicaGroups, v.serverTemplates, v.removeServerTemplates, v.serviceTemplates, v.removeServiceTemplates, v.nodes, v.removeNodes);
    }
};

}

namespace IceGrid
{

using CommunicatorDescriptorPtr = ::std::shared_ptr<CommunicatorDescriptor>;

using ServerDescriptorPtr = ::std::shared_ptr<ServerDescriptor>;

using ServiceDescriptorPtr = ::std::shared_ptr<ServiceDescriptor>;

using IceBoxDescriptorPtr = ::std::shared_ptr<IceBoxDescriptor>;

using LoadBalancingPolicyPtr = ::std::shared_ptr<LoadBalancingPolicy>;

using RandomLoadBalancingPolicyPtr = ::std::shared_ptr<RandomLoadBalancingPolicy>;

using OrderedLoadBalancingPolicyPtr = ::std::shared_ptr<OrderedLoadBalancingPolicy>;

using RoundRobinLoadBalancingPolicyPtr = ::std::shared_ptr<RoundRobinLoadBalancingPolicy>;

using AdaptiveLoadBalancingPolicyPtr = ::std::shared_ptr<AdaptiveLoadBalancingPolicy>;

using BoxedStringPtr = ::std::shared_ptr<BoxedString>;

using BoxedDistributionDescriptorPtr = ::std::shared_ptr<BoxedDistributionDescriptor>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class CommunicatorDescriptor;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::CommunicatorDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::CommunicatorDescriptor*);

class ServerDescriptor;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServerDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::ServerDescriptor*);

class ServiceDescriptor;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServiceDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::ServiceDescriptor*);

class IceBoxDescriptor;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::IceBoxDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::IceBoxDescriptor*);

class LoadBalancingPolicy;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::LoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::LoadBalancingPolicy*);

class RandomLoadBalancingPolicy;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RandomLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::RandomLoadBalancingPolicy*);

class OrderedLoadBalancingPolicy;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::OrderedLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::OrderedLoadBalancingPolicy*);

class RoundRobinLoadBalancingPolicy;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RoundRobinLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::RoundRobinLoadBalancingPolicy*);

class AdaptiveLoadBalancingPolicy;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdaptiveLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::AdaptiveLoadBalancingPolicy*);

class BoxedString;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedString>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::BoxedString*);

class BoxedDistributionDescriptor;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedDistributionDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::BoxedDistributionDescriptor*);

}

}

namespace IceGrid
{

class CommunicatorDescriptor;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::CommunicatorDescriptor*);
typedef ::IceInternal::Handle< ::IceGrid::CommunicatorDescriptor> CommunicatorDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::CommunicatorDescriptor> CommunicatorDescriptorPrx;
typedef CommunicatorDescriptorPrx CommunicatorDescriptorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(CommunicatorDescriptorPtr&, const ::Ice::ObjectPtr&);

class ServerDescriptor;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::ServerDescriptor*);
typedef ::IceInternal::Handle< ::IceGrid::ServerDescriptor> ServerDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServerDescriptor> ServerDescriptorPrx;
typedef ServerDescriptorPrx ServerDescriptorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(ServerDescriptorPtr&, const ::Ice::ObjectPtr&);

class ServiceDescriptor;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::ServiceDescriptor*);
typedef ::IceInternal::Handle< ::IceGrid::ServiceDescriptor> ServiceDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServiceDescriptor> ServiceDescriptorPrx;
typedef ServiceDescriptorPrx ServiceDescriptorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(ServiceDescriptorPtr&, const ::Ice::ObjectPtr&);

class IceBoxDescriptor;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::IceBoxDescriptor*);
typedef ::IceInternal::Handle< ::IceGrid::IceBoxDescriptor> IceBoxDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::IceBoxDescriptor> IceBoxDescriptorPrx;
typedef IceBoxDescriptorPrx IceBoxDescriptorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(IceBoxDescriptorPtr&, const ::Ice::ObjectPtr&);

class LoadBalancingPolicy;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::LoadBalancingPolicy*);
typedef ::IceInternal::Handle< ::IceGrid::LoadBalancingPolicy> LoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::LoadBalancingPolicy> LoadBalancingPolicyPrx;
typedef LoadBalancingPolicyPrx LoadBalancingPolicyPrxPtr;
ICEGRID_API void _icePatchObjectPtr(LoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);

class RandomLoadBalancingPolicy;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::RandomLoadBalancingPolicy*);
typedef ::IceInternal::Handle< ::IceGrid::RandomLoadBalancingPolicy> RandomLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RandomLoadBalancingPolicy> RandomLoadBalancingPolicyPrx;
typedef RandomLoadBalancingPolicyPrx RandomLoadBalancingPolicyPrxPtr;
ICEGRID_API void _icePatchObjectPtr(RandomLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);

class OrderedLoadBalancingPolicy;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::OrderedLoadBalancingPolicy*);
typedef ::IceInternal::Handle< ::IceGrid::OrderedLoadBalancingPolicy> OrderedLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::OrderedLoadBalancingPolicy> OrderedLoadBalancingPolicyPrx;
typedef OrderedLoadBalancingPolicyPrx OrderedLoadBalancingPolicyPrxPtr;
ICEGRID_API void _icePatchObjectPtr(OrderedLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);

class RoundRobinLoadBalancingPolicy;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::RoundRobinLoadBalancingPolicy*);
typedef ::IceInternal::Handle< ::IceGrid::RoundRobinLoadBalancingPolicy> RoundRobinLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RoundRobinLoadBalancingPolicy> RoundRobinLoadBalancingPolicyPrx;
typedef RoundRobinLoadBalancingPolicyPrx RoundRobinLoadBalancingPolicyPrxPtr;
ICEGRID_API void _icePatchObjectPtr(RoundRobinLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);

class AdaptiveLoadBalancingPolicy;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::AdaptiveLoadBalancingPolicy*);
typedef ::IceInternal::Handle< ::IceGrid::AdaptiveLoadBalancingPolicy> AdaptiveLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdaptiveLoadBalancingPolicy> AdaptiveLoadBalancingPolicyPrx;
typedef AdaptiveLoadBalancingPolicyPrx AdaptiveLoadBalancingPolicyPrxPtr;
ICEGRID_API void _icePatchObjectPtr(AdaptiveLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);

class BoxedString;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::BoxedString*);
typedef ::IceInternal::Handle< ::IceGrid::BoxedString> BoxedStringPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedString> BoxedStringPrx;
typedef BoxedStringPrx BoxedStringPrxPtr;
ICEGRID_API void _icePatchObjectPtr(BoxedStringPtr&, const ::Ice::ObjectPtr&);

class BoxedDistributionDescriptor;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::BoxedDistributionDescriptor*);
typedef ::IceInternal::Handle< ::IceGrid::BoxedDistributionDescriptor> BoxedDistributionDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedDistributionDescriptor> BoxedDistributionDescriptorPrx;
typedef BoxedDistributionDescriptorPrx BoxedDistributionDescriptorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(BoxedDistributionDescriptorPtr&, const ::Ice::ObjectPtr&);

}

namespace IceGrid
{

typedef ::std::map< ::std::string, ::std::string> StringStringDict;

struct PropertyDescriptor
{
    ::std::string name;
    ::std::string value;

    bool operator==(const PropertyDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(value != rhs_.value)
        {
            return false;
        }
        return true;
    }

    bool operator<(const PropertyDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(value < rhs_.value)
        {
            return true;
        }
        else if(rhs_.value < value)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const PropertyDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const PropertyDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const PropertyDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const PropertyDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::PropertyDescriptor> PropertyDescriptorSeq;

struct PropertySetDescriptor
{
    ::Ice::StringSeq references;
    ::IceGrid::PropertyDescriptorSeq properties;

    bool operator==(const PropertySetDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(references != rhs_.references)
        {
            return false;
        }
        if(properties != rhs_.properties)
        {
            return false;
        }
        return true;
    }

    bool operator<(const PropertySetDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(references < rhs_.references)
        {
            return true;
        }
        else if(rhs_.references < references)
        {
            return false;
        }
        if(properties < rhs_.properties)
        {
            return true;
        }
        else if(rhs_.properties < properties)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const PropertySetDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const PropertySetDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const PropertySetDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const PropertySetDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::map< ::std::string, ::IceGrid::PropertySetDescriptor> PropertySetDescriptorDict;

struct ObjectDescriptor
{
    ::Ice::Identity id;
    ::std::string type;
    ::std::string proxyOptions;

    bool operator==(const ObjectDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(type != rhs_.type)
        {
            return false;
        }
        if(proxyOptions != rhs_.proxyOptions)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ObjectDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(type < rhs_.type)
        {
            return true;
        }
        else if(rhs_.type < type)
        {
            return false;
        }
        if(proxyOptions < rhs_.proxyOptions)
        {
            return true;
        }
        else if(rhs_.proxyOptions < proxyOptions)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ObjectDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ObjectDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ObjectDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ObjectDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::ObjectDescriptor> ObjectDescriptorSeq;

struct AdapterDescriptor
{
    ::std::string name;
    ::std::string description;
    ::std::string id;
    ::std::string replicaGroupId;
    ::std::string priority;
    bool registerProcess;
    bool serverLifetime;
    ::IceGrid::ObjectDescriptorSeq objects;
    ::IceGrid::ObjectDescriptorSeq allocatables;

    bool operator==(const AdapterDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(description != rhs_.description)
        {
            return false;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(replicaGroupId != rhs_.replicaGroupId)
        {
            return false;
        }
        if(priority != rhs_.priority)
        {
            return false;
        }
        if(registerProcess != rhs_.registerProcess)
        {
            return false;
        }
        if(serverLifetime != rhs_.serverLifetime)
        {
            return false;
        }
        if(objects != rhs_.objects)
        {
            return false;
        }
        if(allocatables != rhs_.allocatables)
        {
            return false;
        }
        return true;
    }

    bool operator<(const AdapterDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(description < rhs_.description)
        {
            return true;
        }
        else if(rhs_.description < description)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(replicaGroupId < rhs_.replicaGroupId)
        {
            return true;
        }
        else if(rhs_.replicaGroupId < replicaGroupId)
        {
            return false;
        }
        if(priority < rhs_.priority)
        {
            return true;
        }
        else if(rhs_.priority < priority)
        {
            return false;
        }
        if(registerProcess < rhs_.registerProcess)
        {
            return true;
        }
        else if(rhs_.registerProcess < registerProcess)
        {
            return false;
        }
        if(serverLifetime < rhs_.serverLifetime)
        {
            return true;
        }
        else if(rhs_.serverLifetime < serverLifetime)
        {
            return false;
        }
        if(objects < rhs_.objects)
        {
            return true;
        }
        else if(rhs_.objects < objects)
        {
            return false;
        }
        if(allocatables < rhs_.allocatables)
        {
            return true;
        }
        else if(rhs_.allocatables < allocatables)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const AdapterDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const AdapterDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const AdapterDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const AdapterDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::AdapterDescriptor> AdapterDescriptorSeq;

struct DbEnvDescriptor
{
    ::std::string name;
    ::std::string description;
    ::std::string dbHome;
    ::IceGrid::PropertyDescriptorSeq properties;

    bool operator==(const DbEnvDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(description != rhs_.description)
        {
            return false;
        }
        if(dbHome != rhs_.dbHome)
        {
            return false;
        }
        if(properties != rhs_.properties)
        {
            return false;
        }
        return true;
    }

    bool operator<(const DbEnvDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(description < rhs_.description)
        {
            return true;
        }
        else if(rhs_.description < description)
        {
            return false;
        }
        if(dbHome < rhs_.dbHome)
        {
            return true;
        }
        else if(rhs_.dbHome < dbHome)
        {
            return false;
        }
        if(properties < rhs_.properties)
        {
            return true;
        }
        else if(rhs_.properties < properties)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const DbEnvDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const DbEnvDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const DbEnvDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const DbEnvDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::DbEnvDescriptor> DbEnvDescriptorSeq;

struct DistributionDescriptor
{
    ::std::string icepatch;
    ::Ice::StringSeq directories;

    bool operator==(const DistributionDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(icepatch != rhs_.icepatch)
        {
            return false;
        }
        if(directories != rhs_.directories)
        {
            return false;
        }
        return true;
    }

    bool operator<(const DistributionDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(icepatch < rhs_.icepatch)
        {
            return true;
        }
        else if(rhs_.icepatch < icepatch)
        {
            return false;
        }
        if(directories < rhs_.directories)
        {
            return true;
        }
        else if(rhs_.directories < directories)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const DistributionDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const DistributionDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const DistributionDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const DistributionDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::ServerDescriptorPtr> ServerDescriptorSeq;

typedef ::std::vector< ::IceGrid::ServiceDescriptorPtr> ServiceDescriptorSeq;

struct ServerInstanceDescriptor
{
    ::std::string _cpp_template;
    ::IceGrid::StringStringDict parameterValues;
    ::IceGrid::PropertySetDescriptor propertySet;
    ::IceGrid::PropertySetDescriptorDict servicePropertySets;

    bool operator==(const ServerInstanceDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(_cpp_template != rhs_._cpp_template)
        {
            return false;
        }
        if(parameterValues != rhs_.parameterValues)
        {
            return false;
        }
        if(propertySet != rhs_.propertySet)
        {
            return false;
        }
        if(servicePropertySets != rhs_.servicePropertySets)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ServerInstanceDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(_cpp_template < rhs_._cpp_template)
        {
            return true;
        }
        else if(rhs_._cpp_template < _cpp_template)
        {
            return false;
        }
        if(parameterValues < rhs_.parameterValues)
        {
            return true;
        }
        else if(rhs_.parameterValues < parameterValues)
        {
            return false;
        }
        if(propertySet < rhs_.propertySet)
        {
            return true;
        }
        else if(rhs_.propertySet < propertySet)
        {
            return false;
        }
        if(servicePropertySets < rhs_.servicePropertySets)
        {
            return true;
        }
        else if(rhs_.servicePropertySets < servicePropertySets)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ServerInstanceDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ServerInstanceDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ServerInstanceDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ServerInstanceDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::ServerInstanceDescriptor> ServerInstanceDescriptorSeq;

struct TemplateDescriptor
{
    ::IceGrid::CommunicatorDescriptorPtr descriptor;
    ::Ice::StringSeq parameters;
    ::IceGrid::StringStringDict parameterDefaults;
};

typedef ::std::map< ::std::string, ::IceGrid::TemplateDescriptor> TemplateDescriptorDict;

struct ServiceInstanceDescriptor
{
    ::std::string _cpp_template;
    ::IceGrid::StringStringDict parameterValues;
    ::IceGrid::ServiceDescriptorPtr descriptor;
    ::IceGrid::PropertySetDescriptor propertySet;
};

typedef ::std::vector< ::IceGrid::ServiceInstanceDescriptor> ServiceInstanceDescriptorSeq;

struct NodeDescriptor
{
    ::IceGrid::StringStringDict variables;
    ::IceGrid::ServerInstanceDescriptorSeq serverInstances;
    ::IceGrid::ServerDescriptorSeq servers;
    ::std::string loadFactor;
    ::std::string description;
    ::IceGrid::PropertySetDescriptorDict propertySets;
};

typedef ::std::map< ::std::string, ::IceGrid::NodeDescriptor> NodeDescriptorDict;

struct ReplicaGroupDescriptor
{
    ::std::string id;
    ::IceGrid::LoadBalancingPolicyPtr loadBalancing;
    ::std::string proxyOptions;
    ::IceGrid::ObjectDescriptorSeq objects;
    ::std::string description;
    ::std::string filter;
};

typedef ::std::vector< ::IceGrid::ReplicaGroupDescriptor> ReplicaGroupDescriptorSeq;

struct ApplicationDescriptor
{
    ::std::string name;
    ::IceGrid::StringStringDict variables;
    ::IceGrid::ReplicaGroupDescriptorSeq replicaGroups;
    ::IceGrid::TemplateDescriptorDict serverTemplates;
    ::IceGrid::TemplateDescriptorDict serviceTemplates;
    ::IceGrid::NodeDescriptorDict nodes;
    ::IceGrid::DistributionDescriptor distrib;
    ::std::string description;
    ::IceGrid::PropertySetDescriptorDict propertySets;
};

typedef ::std::vector< ::IceGrid::ApplicationDescriptor> ApplicationDescriptorSeq;

struct NodeUpdateDescriptor
{
    ::std::string name;
    ::IceGrid::BoxedStringPtr description;
    ::IceGrid::StringStringDict variables;
    ::Ice::StringSeq removeVariables;
    ::IceGrid::PropertySetDescriptorDict propertySets;
    ::Ice::StringSeq removePropertySets;
    ::IceGrid::ServerInstanceDescriptorSeq serverInstances;
    ::IceGrid::ServerDescriptorSeq servers;
    ::Ice::StringSeq removeServers;
    ::IceGrid::BoxedStringPtr loadFactor;
};

typedef ::std::vector< ::IceGrid::NodeUpdateDescriptor> NodeUpdateDescriptorSeq;

struct ApplicationUpdateDescriptor
{
    ::std::string name;
    ::IceGrid::BoxedStringPtr description;
    ::IceGrid::BoxedDistributionDescriptorPtr distrib;
    ::IceGrid::StringStringDict variables;
    ::Ice::StringSeq removeVariables;
    ::IceGrid::PropertySetDescriptorDict propertySets;
    ::Ice::StringSeq removePropertySets;
    ::IceGrid::ReplicaGroupDescriptorSeq replicaGroups;
    ::Ice::StringSeq removeReplicaGroups;
    ::IceGrid::TemplateDescriptorDict serverTemplates;
    ::Ice::StringSeq removeServerTemplates;
    ::IceGrid::TemplateDescriptorDict serviceTemplates;
    ::Ice::StringSeq removeServiceTemplates;
    ::IceGrid::NodeUpdateDescriptorSeq nodes;
    ::Ice::StringSeq removeNodes;
};

}

namespace IceGrid
{

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) CommunicatorDescriptor : public virtual ::Ice::Proxy<CommunicatorDescriptor, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) ServerDescriptor : public virtual ::Ice::Proxy<ServerDescriptor, ::IceProxy::IceGrid::CommunicatorDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) ServiceDescriptor : public virtual ::Ice::Proxy<ServiceDescriptor, ::IceProxy::IceGrid::CommunicatorDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) IceBoxDescriptor : public virtual ::Ice::Proxy<IceBoxDescriptor, ::IceProxy::IceGrid::ServerDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) LoadBalancingPolicy : public virtual ::Ice::Proxy<LoadBalancingPolicy, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) RandomLoadBalancingPolicy : public virtual ::Ice::Proxy<RandomLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) OrderedLoadBalancingPolicy : public virtual ::Ice::Proxy<OrderedLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) RoundRobinLoadBalancingPolicy : public virtual ::Ice::Proxy<RoundRobinLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) AdaptiveLoadBalancingPolicy : public virtual ::Ice::Proxy<AdaptiveLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) BoxedString : public virtual ::Ice::Proxy<BoxedString, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) BoxedDistributionDescriptor : public virtual ::Ice::Proxy<BoxedDistributionDescriptor, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceGrid
{

class ICEGRID_API CommunicatorDescriptor : public virtual ::Ice::Object
{
public:

    typedef CommunicatorDescriptorPrx ProxyType;
    typedef CommunicatorDescriptorPtr PointerType;

    virtual ~CommunicatorDescriptor();

    CommunicatorDescriptor()
    {
    }

    CommunicatorDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description) :
        adapters(iceP_adapters),
        propertySet(iceP_propertySet),
        dbEnvs(iceP_dbEnvs),
        logs(iceP_logs),
        description(iceP_description)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::IceGrid::AdapterDescriptorSeq adapters;
    ::IceGrid::PropertySetDescriptor propertySet;
    ::IceGrid::DbEnvDescriptorSeq dbEnvs;
    ::Ice::StringSeq logs;
    ::std::string description;
};
static ::Ice::ValueFactoryPtr _iceS_CommunicatorDescriptor_init = ::IceGrid::CommunicatorDescriptor::ice_factory();

inline bool operator==(const CommunicatorDescriptor& lhs, const CommunicatorDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const CommunicatorDescriptor& lhs, const CommunicatorDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API ServerDescriptor : public ::IceGrid::CommunicatorDescriptor
{
public:

    typedef ServerDescriptorPrx ProxyType;
    typedef ServerDescriptorPtr PointerType;

    virtual ~ServerDescriptor();

    ServerDescriptor()
    {
    }

    ServerDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description, const ::std::string& iceP_id, const ::std::string& iceP_exe, const ::std::string& iceP_iceVersion, const ::std::string& iceP_pwd, const ::Ice::StringSeq& iceP_options, const ::Ice::StringSeq& iceP_envs, const ::std::string& iceP_activation, const ::std::string& iceP_activationTimeout, const ::std::string& iceP_deactivationTimeout, bool iceP_applicationDistrib, const ::IceGrid::DistributionDescriptor& iceP_distrib, bool iceP_allocatable, const ::std::string& iceP_user) :
        ::IceGrid::CommunicatorDescriptor(iceP_adapters, iceP_propertySet, iceP_dbEnvs, iceP_logs, iceP_description),
        id(iceP_id),
        exe(iceP_exe),
        iceVersion(iceP_iceVersion),
        pwd(iceP_pwd),
        options(iceP_options),
        envs(iceP_envs),
        activation(iceP_activation),
        activationTimeout(iceP_activationTimeout),
        deactivationTimeout(iceP_deactivationTimeout),
        applicationDistrib(iceP_applicationDistrib),
        distrib(iceP_distrib),
        allocatable(iceP_allocatable),
        user(iceP_user)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::std::string id;
    ::std::string exe;
    ::std::string iceVersion;
    ::std::string pwd;
    ::Ice::StringSeq options;
    ::Ice::StringSeq envs;
    ::std::string activation;
    ::std::string activationTimeout;
    ::std::string deactivationTimeout;
    bool applicationDistrib;
    ::IceGrid::DistributionDescriptor distrib;
    bool allocatable;
    ::std::string user;
};
static ::Ice::ValueFactoryPtr _iceS_ServerDescriptor_init = ::IceGrid::ServerDescriptor::ice_factory();

inline bool operator==(const ServerDescriptor& lhs, const ServerDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServerDescriptor& lhs, const ServerDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API ServiceDescriptor : public ::IceGrid::CommunicatorDescriptor
{
public:

    typedef ServiceDescriptorPrx ProxyType;
    typedef ServiceDescriptorPtr PointerType;

    virtual ~ServiceDescriptor();

    ServiceDescriptor()
    {
    }

    ServiceDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description, const ::std::string& iceP_name, const ::std::string& iceP_entry) :
        ::IceGrid::CommunicatorDescriptor(iceP_adapters, iceP_propertySet, iceP_dbEnvs, iceP_logs, iceP_description),
        name(iceP_name),
        entry(iceP_entry)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::std::string name;
    ::std::string entry;
};
static ::Ice::ValueFactoryPtr _iceS_ServiceDescriptor_init = ::IceGrid::ServiceDescriptor::ice_factory();

inline bool operator==(const ServiceDescriptor& lhs, const ServiceDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServiceDescriptor& lhs, const ServiceDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API IceBoxDescriptor : public ::IceGrid::ServerDescriptor, public ::IceInternal::GCObject
{
public:

    typedef IceBoxDescriptorPrx ProxyType;
    typedef IceBoxDescriptorPtr PointerType;

    virtual ~IceBoxDescriptor();

    IceBoxDescriptor()
    {
    }

    IceBoxDescriptor(const ::IceGrid::AdapterDescriptorSeq& iceP_adapters, const ::IceGrid::PropertySetDescriptor& iceP_propertySet, const ::IceGrid::DbEnvDescriptorSeq& iceP_dbEnvs, const ::Ice::StringSeq& iceP_logs, const ::std::string& iceP_description, const ::std::string& iceP_id, const ::std::string& iceP_exe, const ::std::string& iceP_iceVersion, const ::std::string& iceP_pwd, const ::Ice::StringSeq& iceP_options, const ::Ice::StringSeq& iceP_envs, const ::std::string& iceP_activation, const ::std::string& iceP_activationTimeout, const ::std::string& iceP_deactivationTimeout, bool iceP_applicationDistrib, const ::IceGrid::DistributionDescriptor& iceP_distrib, bool iceP_allocatable, const ::std::string& iceP_user, const ::IceGrid::ServiceInstanceDescriptorSeq& iceP_services) :
        ::IceGrid::ServerDescriptor(iceP_adapters, iceP_propertySet, iceP_dbEnvs, iceP_logs, iceP_description, iceP_id, iceP_exe, iceP_iceVersion, iceP_pwd, iceP_options, iceP_envs, iceP_activation, iceP_activationTimeout, iceP_deactivationTimeout, iceP_applicationDistrib, iceP_distrib, iceP_allocatable, iceP_user),
        services(iceP_services)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();
    virtual void _iceGcVisitMembers(::IceInternal::GCVisitor&);

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::IceGrid::ServiceInstanceDescriptorSeq services;
};
static ::Ice::ValueFactoryPtr _iceS_IceBoxDescriptor_init = ::IceGrid::IceBoxDescriptor::ice_factory();

inline bool operator==(const IceBoxDescriptor& lhs, const IceBoxDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const IceBoxDescriptor& lhs, const IceBoxDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API LoadBalancingPolicy : public virtual ::Ice::Object
{
public:

    typedef LoadBalancingPolicyPrx ProxyType;
    typedef LoadBalancingPolicyPtr PointerType;

    virtual ~LoadBalancingPolicy();

    LoadBalancingPolicy()
    {
    }

    explicit LoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        nReplicas(iceP_nReplicas)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::std::string nReplicas;
};
static ::Ice::ValueFactoryPtr _iceS_LoadBalancingPolicy_init = ::IceGrid::LoadBalancingPolicy::ice_factory();

inline bool operator==(const LoadBalancingPolicy& lhs, const LoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LoadBalancingPolicy& lhs, const LoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API RandomLoadBalancingPolicy : public ::IceGrid::LoadBalancingPolicy
{
public:

    typedef RandomLoadBalancingPolicyPrx ProxyType;
    typedef RandomLoadBalancingPolicyPtr PointerType;

    virtual ~RandomLoadBalancingPolicy();

    RandomLoadBalancingPolicy()
    {
    }

    explicit RandomLoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        ::IceGrid::LoadBalancingPolicy(iceP_nReplicas)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};
static ::Ice::ValueFactoryPtr _iceS_RandomLoadBalancingPolicy_init = ::IceGrid::RandomLoadBalancingPolicy::ice_factory();

inline bool operator==(const RandomLoadBalancingPolicy& lhs, const RandomLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RandomLoadBalancingPolicy& lhs, const RandomLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API OrderedLoadBalancingPolicy : public ::IceGrid::LoadBalancingPolicy
{
public:

    typedef OrderedLoadBalancingPolicyPrx ProxyType;
    typedef OrderedLoadBalancingPolicyPtr PointerType;

    virtual ~OrderedLoadBalancingPolicy();

    OrderedLoadBalancingPolicy()
    {
    }

    explicit OrderedLoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        ::IceGrid::LoadBalancingPolicy(iceP_nReplicas)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};
static ::Ice::ValueFactoryPtr _iceS_OrderedLoadBalancingPolicy_init = ::IceGrid::OrderedLoadBalancingPolicy::ice_factory();

inline bool operator==(const OrderedLoadBalancingPolicy& lhs, const OrderedLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const OrderedLoadBalancingPolicy& lhs, const OrderedLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API RoundRobinLoadBalancingPolicy : public ::IceGrid::LoadBalancingPolicy
{
public:

    typedef RoundRobinLoadBalancingPolicyPrx ProxyType;
    typedef RoundRobinLoadBalancingPolicyPtr PointerType;

    virtual ~RoundRobinLoadBalancingPolicy();

    RoundRobinLoadBalancingPolicy()
    {
    }

    explicit RoundRobinLoadBalancingPolicy(const ::std::string& iceP_nReplicas) :
        ::IceGrid::LoadBalancingPolicy(iceP_nReplicas)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};
static ::Ice::ValueFactoryPtr _iceS_RoundRobinLoadBalancingPolicy_init = ::IceGrid::RoundRobinLoadBalancingPolicy::ice_factory();

inline bool operator==(const RoundRobinLoadBalancingPolicy& lhs, const RoundRobinLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RoundRobinLoadBalancingPolicy& lhs, const RoundRobinLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API AdaptiveLoadBalancingPolicy : public ::IceGrid::LoadBalancingPolicy
{
public:

    typedef AdaptiveLoadBalancingPolicyPrx ProxyType;
    typedef AdaptiveLoadBalancingPolicyPtr PointerType;

    virtual ~AdaptiveLoadBalancingPolicy();

    AdaptiveLoadBalancingPolicy()
    {
    }

    AdaptiveLoadBalancingPolicy(const ::std::string& iceP_nReplicas, const ::std::string& iceP_loadSample) :
        ::IceGrid::LoadBalancingPolicy(iceP_nReplicas),
        loadSample(iceP_loadSample)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::std::string loadSample;
};
static ::Ice::ValueFactoryPtr _iceS_AdaptiveLoadBalancingPolicy_init = ::IceGrid::AdaptiveLoadBalancingPolicy::ice_factory();

inline bool operator==(const AdaptiveLoadBalancingPolicy& lhs, const AdaptiveLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const AdaptiveLoadBalancingPolicy& lhs, const AdaptiveLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API BoxedString : public virtual ::Ice::Object
{
public:

    typedef BoxedStringPrx ProxyType;
    typedef BoxedStringPtr PointerType;

    virtual ~BoxedString();

    BoxedString()
    {
    }

    explicit BoxedString(const ::std::string& iceP_value) :
        value(iceP_value)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::std::string value;
};
static ::Ice::ValueFactoryPtr _iceS_BoxedString_init = ::IceGrid::BoxedString::ice_factory();

inline bool operator==(const BoxedString& lhs, const BoxedString& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const BoxedString& lhs, const BoxedString& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API BoxedDistributionDescriptor : public virtual ::Ice::Object
{
public:

    typedef BoxedDistributionDescriptorPrx ProxyType;
    typedef BoxedDistributionDescriptorPtr PointerType;

    virtual ~BoxedDistributionDescriptor();

    BoxedDistributionDescriptor()
    {
    }

    explicit BoxedDistributionDescriptor(const ::IceGrid::DistributionDescriptor& iceP_value) :
        value(iceP_value)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::IceGrid::DistributionDescriptor value;
};
static ::Ice::ValueFactoryPtr _iceS_BoxedDistributionDescriptor_init = ::IceGrid::BoxedDistributionDescriptor::ice_factory();

inline bool operator==(const BoxedDistributionDescriptor& lhs, const BoxedDistributionDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const BoxedDistributionDescriptor& lhs, const BoxedDistributionDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::PropertyDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::PropertyDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::PropertyDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.value);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PropertyDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertyDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.value);
    }
};

template<>
struct StreamableTraits< ::IceGrid::PropertySetDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::PropertySetDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::PropertySetDescriptor& v)
    {
        ostr->write(v.references);
        ostr->write(v.properties);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PropertySetDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertySetDescriptor& v)
    {
        istr->read(v.references);
        istr->read(v.properties);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObjectDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.type);
        ostr->write(v.proxyOptions);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ObjectDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.type);
        istr->read(v.proxyOptions);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.id);
        ostr->write(v.replicaGroupId);
        ostr->write(v.priority);
        ostr->write(v.registerProcess);
        ostr->write(v.serverLifetime);
        ostr->write(v.objects);
        ostr->write(v.allocatables);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterDescriptor, S>
{
    static void read(S* istr, ::IceGrid::AdapterDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.id);
        istr->read(v.replicaGroupId);
        istr->read(v.priority);
        istr->read(v.registerProcess);
        istr->read(v.serverLifetime);
        istr->read(v.objects);
        istr->read(v.allocatables);
    }
};

template<>
struct StreamableTraits< ::IceGrid::DbEnvDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::DbEnvDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::DbEnvDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.dbHome);
        ostr->write(v.properties);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::DbEnvDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DbEnvDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.dbHome);
        istr->read(v.properties);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::CommunicatorDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::CommunicatorDescriptor& v)
    {
        ostr->write(v.adapters);
        ostr->write(v.propertySet);
        ostr->write(v.dbEnvs);
        ostr->write(v.logs);
        ostr->write(v.description);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::CommunicatorDescriptor, S>
{
    static void read(S* istr, ::IceGrid::CommunicatorDescriptor& v)
    {
        istr->read(v.adapters);
        istr->read(v.propertySet);
        istr->read(v.dbEnvs);
        istr->read(v.logs);
        istr->read(v.description);
    }
};

template<>
struct StreamableTraits< ::IceGrid::DistributionDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::DistributionDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::DistributionDescriptor& v)
    {
        ostr->write(v.icepatch);
        ostr->write(v.directories);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::DistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DistributionDescriptor& v)
    {
        istr->read(v.icepatch);
        istr->read(v.directories);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServerDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.exe);
        ostr->write(v.iceVersion);
        ostr->write(v.pwd);
        ostr->write(v.options);
        ostr->write(v.envs);
        ostr->write(v.activation);
        ostr->write(v.activationTimeout);
        ostr->write(v.deactivationTimeout);
        ostr->write(v.applicationDistrib);
        ostr->write(v.distrib);
        ostr->write(v.allocatable);
        ostr->write(v.user);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.exe);
        istr->read(v.iceVersion);
        istr->read(v.pwd);
        istr->read(v.options);
        istr->read(v.envs);
        istr->read(v.activation);
        istr->read(v.activationTimeout);
        istr->read(v.deactivationTimeout);
        istr->read(v.applicationDistrib);
        istr->read(v.distrib);
        istr->read(v.allocatable);
        istr->read(v.user);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::ServiceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServiceDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.entry);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServiceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.entry);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerInstanceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServerInstanceDescriptor& v)
    {
        ostr->write(v._cpp_template);
        ostr->write(v.parameterValues);
        ostr->write(v.propertySet);
        ostr->write(v.servicePropertySets);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerInstanceDescriptor& v)
    {
        istr->read(v._cpp_template);
        istr->read(v.parameterValues);
        istr->read(v.propertySet);
        istr->read(v.servicePropertySets);
    }
};

template<>
struct StreamableTraits< ::IceGrid::TemplateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::TemplateDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::TemplateDescriptor& v)
    {
        ostr->write(v.descriptor);
        ostr->write(v.parameters);
        ostr->write(v.parameterDefaults);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::TemplateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::TemplateDescriptor& v)
    {
        istr->read(v.descriptor);
        istr->read(v.parameters);
        istr->read(v.parameterDefaults);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServiceInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServiceInstanceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServiceInstanceDescriptor& v)
    {
        ostr->write(v._cpp_template);
        ostr->write(v.parameterValues);
        ostr->write(v.descriptor);
        ostr->write(v.propertySet);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServiceInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceInstanceDescriptor& v)
    {
        istr->read(v._cpp_template);
        istr->read(v.parameterValues);
        istr->read(v.descriptor);
        istr->read(v.propertySet);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::IceBoxDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::IceBoxDescriptor& v)
    {
        ostr->write(v.services);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::IceBoxDescriptor, S>
{
    static void read(S* istr, ::IceGrid::IceBoxDescriptor& v)
    {
        istr->read(v.services);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::NodeDescriptor& v)
    {
        ostr->write(v.variables);
        ostr->write(v.serverInstances);
        ostr->write(v.servers);
        ostr->write(v.loadFactor);
        ostr->write(v.description);
        ostr->write(v.propertySets);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeDescriptor& v)
    {
        istr->read(v.variables);
        istr->read(v.serverInstances);
        istr->read(v.servers);
        istr->read(v.loadFactor);
        istr->read(v.description);
        istr->read(v.propertySets);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::LoadBalancingPolicy, S>
{
    static void write(S* ostr, const ::IceGrid::LoadBalancingPolicy& v)
    {
        ostr->write(v.nReplicas);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::LoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::LoadBalancingPolicy& v)
    {
        istr->read(v.nReplicas);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void write(S* ostr, const ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        ostr->write(v.loadSample);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        istr->read(v.loadSample);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ReplicaGroupDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ReplicaGroupDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ReplicaGroupDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.loadBalancing);
        ostr->write(v.proxyOptions);
        ostr->write(v.objects);
        ostr->write(v.description);
        ostr->write(v.filter);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ReplicaGroupDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ReplicaGroupDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.loadBalancing);
        istr->read(v.proxyOptions);
        istr->read(v.objects);
        istr->read(v.description);
        istr->read(v.filter);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.variables);
        ostr->write(v.replicaGroups);
        ostr->write(v.serverTemplates);
        ostr->write(v.serviceTemplates);
        ostr->write(v.nodes);
        ostr->write(v.distrib);
        ostr->write(v.description);
        ostr->write(v.propertySets);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.variables);
        istr->read(v.replicaGroups);
        istr->read(v.serverTemplates);
        istr->read(v.serviceTemplates);
        istr->read(v.nodes);
        istr->read(v.distrib);
        istr->read(v.description);
        istr->read(v.propertySets);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::BoxedString, S>
{
    static void write(S* ostr, const ::IceGrid::BoxedString& v)
    {
        ostr->write(v.value);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::BoxedString, S>
{
    static void read(S* istr, ::IceGrid::BoxedString& v)
    {
        istr->read(v.value);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeUpdateDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::NodeUpdateDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.variables);
        ostr->write(v.removeVariables);
        ostr->write(v.propertySets);
        ostr->write(v.removePropertySets);
        ostr->write(v.serverInstances);
        ostr->write(v.servers);
        ostr->write(v.removeServers);
        ostr->write(v.loadFactor);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeUpdateDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.variables);
        istr->read(v.removeVariables);
        istr->read(v.propertySets);
        istr->read(v.removePropertySets);
        istr->read(v.serverInstances);
        istr->read(v.servers);
        istr->read(v.removeServers);
        istr->read(v.loadFactor);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::BoxedDistributionDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::BoxedDistributionDescriptor& v)
    {
        ostr->write(v.value);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::BoxedDistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::BoxedDistributionDescriptor& v)
    {
        istr->read(v.value);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 15;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationUpdateDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationUpdateDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.distrib);
        ostr->write(v.variables);
        ostr->write(v.removeVariables);
        ostr->write(v.propertySets);
        ostr->write(v.removePropertySets);
        ostr->write(v.replicaGroups);
        ostr->write(v.removeReplicaGroups);
        ostr->write(v.serverTemplates);
        ostr->write(v.removeServerTemplates);
        ostr->write(v.serviceTemplates);
        ostr->write(v.removeServiceTemplates);
        ostr->write(v.nodes);
        ostr->write(v.removeNodes);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.distrib);
        istr->read(v.variables);
        istr->read(v.removeVariables);
        istr->read(v.propertySets);
        istr->read(v.removePropertySets);
        istr->read(v.replicaGroups);
        istr->read(v.removeReplicaGroups);
        istr->read(v.serverTemplates);
        istr->read(v.removeServerTemplates);
        istr->read(v.serviceTemplates);
        istr->read(v.removeServiceTemplates);
        istr->read(v.nodes);
        istr->read(v.removeNodes);
    }
};

}

namespace IceGrid
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
