/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.NullLoggerFactory;

class TrackingFileManager {
    private Logger logger = NullLoggerFactory.LOGGER;

    TrackingFileManager() {
    }

    public TrackingFileManager setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLoggerFactory.LOGGER;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Properties read(File file2) {
        Object object = this.getLock(file2);
        synchronized (object) {
            Properties properties;
            FileInputStream stream;
            FileLock lock;
            block8: {
                lock = null;
                stream = null;
                if (file2.exists()) break block8;
                Properties properties2 = null;
                this.release(lock, file2);
                this.close(stream, file2);
                return properties2;
            }
            try {
                stream = new FileInputStream(file2);
                lock = this.lock(stream.getChannel(), Math.max(1L, file2.length()), true);
                Properties props = new Properties();
                props.load(stream);
                properties = props;
                this.release(lock, file2);
                this.close(stream, file2);
            }
            catch (IOException e2) {
                try {
                    this.logger.warn("Failed to read tracking file " + file2, e2);
                    this.release(lock, file2);
                    this.close(stream, file2);
                }
                catch (Throwable throwable) {
                    this.release(lock, file2);
                    this.close(stream, file2);
                    throw throwable;
                }
            }
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(File file2, Map<String, String> updates) {
        Properties props = new Properties();
        Object object = this.getLock(file2);
        synchronized (object) {
            File directory = file2.getParentFile();
            if (!directory.mkdirs() && !directory.exists()) {
                this.logger.warn("Failed to create parent directories for tracking file " + file2);
                return props;
            }
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(file2, "rw");
                lock = this.lock(raf.getChannel(), Math.max(1L, raf.length()), false);
                if (file2.canRead()) {
                    byte[] buffer = new byte[(int)raf.length()];
                    raf.readFully(buffer);
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    props.load(stream);
                }
                for (Map.Entry<String, String> update2 : updates.entrySet()) {
                    if (update2.getValue() == null) {
                        props.remove(update2.getKey());
                        continue;
                    }
                    props.setProperty(update2.getKey(), update2.getValue());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                this.logger.debug("Writing tracking file " + file2);
                props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                raf.seek(0L);
                raf.write(stream.toByteArray());
                raf.setLength(raf.getFilePointer());
                this.release(lock, file2);
                this.close(raf, file2);
            }
            catch (IOException e2) {
                try {
                    this.logger.warn("Failed to write tracking file " + file2, e2);
                    this.release(lock, file2);
                    this.close(raf, file2);
                }
                catch (Throwable throwable) {
                    this.release(lock, file2);
                    this.close(raf, file2);
                    throw throwable;
                }
            }
        }
        return props;
    }

    private void release(FileLock lock, File file2) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e2) {
                this.logger.warn("Error releasing lock for tracking file " + file2, e2);
            }
        }
    }

    private void close(Closeable closeable, File file2) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e2) {
                this.logger.warn("Error closing tracking file " + file2, e2);
            }
        }
    }

    private Object getLock(File file2) {
        try {
            return file2.getCanonicalPath().intern();
        }
        catch (IOException e2) {
            this.logger.warn("Failed to canonicalize path " + file2 + ": " + e2.getMessage());
            return file2.getAbsolutePath().intern();
        }
    }

    private FileLock lock(FileChannel channel, long size, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, size, shared);
                break;
            }
            catch (OverlappingFileLockException e2) {
                if (attempts <= 0) {
                    throw (IOException)new IOException().initCause(e2);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

