/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;

public final class SDeclaration
extends AStatement {
    private final String type;
    private final String name;
    private AExpression expression;
    private Locals.Variable variable = null;

    public SDeclaration(Location location, String type, String name, AExpression expression) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.expression = expression;
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
        if (this.expression != null) {
            this.expression.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Class<?> clazz;
        try {
            clazz = Definition.TypeToClass(locals.getDefinition().getType(this.type));
        }
        catch (IllegalArgumentException exception) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        if (this.expression != null) {
            this.expression.expected = clazz;
            this.expression.analyze(locals);
            this.expression = this.expression.cast(locals);
        }
        this.variable = locals.addVariable(this.location, clazz, this.name, false);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        if (this.expression == null) {
            Class<?> sort = this.variable.clazz;
            if (sort == Void.TYPE || sort == Boolean.TYPE || sort == Byte.TYPE || sort == Short.TYPE || sort == Character.TYPE || sort == Integer.TYPE) {
                writer.push(0);
            } else if (sort == Long.TYPE) {
                writer.push(0L);
            } else if (sort == Float.TYPE) {
                writer.push(0.0f);
            } else if (sort == Double.TYPE) {
                writer.push(0.0);
            } else {
                writer.visitInsn(1);
            }
        } else {
            this.expression.write(writer, globals);
        }
        writer.visitVarInsn(MethodWriter.getType(this.variable.clazz).getOpcode(54), this.variable.getSlot());
    }

    @Override
    public String toString() {
        if (this.expression == null) {
            return this.singleLineToString(this.type, this.name);
        }
        return this.singleLineToString(this.type, this.name, this.expression);
    }
}

