/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Assertions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.BaseTranslogReader;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.ChannelFactory;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogHeader;
import org.elasticsearch.index.translog.TranslogReader;
import org.elasticsearch.index.translog.TranslogSnapshot;

public class TranslogWriter
extends BaseTranslogReader
implements Closeable {
    private final ShardId shardId;
    private final ChannelFactory channelFactory;
    private volatile Checkpoint lastSyncedCheckpoint;
    private volatile int operationCounter;
    private volatile Exception tragedy;
    private final OutputStream outputStream;
    private volatile long totalOffset;
    private volatile long minSeqNo;
    private volatile long maxSeqNo;
    private final LongSupplier globalCheckpointSupplier;
    private final LongSupplier minTranslogGenerationSupplier;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object syncLock = new Object();
    private final Map<Long, Tuple<BytesReference, Exception>> seenSequenceNumbers;

    private TranslogWriter(ChannelFactory channelFactory, ShardId shardId, Checkpoint initialCheckpoint, FileChannel channel, Path path, ByteSizeValue bufferSize, LongSupplier globalCheckpointSupplier, LongSupplier minTranslogGenerationSupplier, TranslogHeader header) throws IOException {
        super(initialCheckpoint.generation, channel, path, header);
        assert (initialCheckpoint.offset == channel.position()) : "initial checkpoint offset [" + initialCheckpoint.offset + "] is different than current channel position [" + channel.position() + "]";
        this.shardId = shardId;
        this.channelFactory = channelFactory;
        this.minTranslogGenerationSupplier = minTranslogGenerationSupplier;
        this.outputStream = new BufferedChannelOutputStream(Channels.newOutputStream(channel), bufferSize.bytesAsInt());
        this.lastSyncedCheckpoint = initialCheckpoint;
        this.totalOffset = initialCheckpoint.offset;
        assert (initialCheckpoint.minSeqNo == -1L) : initialCheckpoint.minSeqNo;
        this.minSeqNo = initialCheckpoint.minSeqNo;
        assert (initialCheckpoint.maxSeqNo == -1L) : initialCheckpoint.maxSeqNo;
        this.maxSeqNo = initialCheckpoint.maxSeqNo;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.seenSequenceNumbers = Assertions.ENABLED ? new HashMap() : null;
    }

    public static TranslogWriter create(ShardId shardId, String translogUUID, long fileGeneration, Path file, ChannelFactory channelFactory, ByteSizeValue bufferSize, long initialMinTranslogGen, long initialGlobalCheckpoint, LongSupplier globalCheckpointSupplier, LongSupplier minTranslogGenerationSupplier, long primaryTerm) throws IOException {
        FileChannel channel = channelFactory.open(file);
        try {
            TranslogHeader header = new TranslogHeader(translogUUID, primaryTerm);
            header.write(channel);
            Checkpoint checkpoint = Checkpoint.emptyTranslogCheckpoint(header.sizeInBytes(), fileGeneration, initialGlobalCheckpoint, initialMinTranslogGen);
            TranslogWriter.writeCheckpoint(channelFactory, file.getParent(), checkpoint);
            LongSupplier writerGlobalCheckpointSupplier = Assertions.ENABLED ? () -> {
                long gcp = globalCheckpointSupplier.getAsLong();
                assert (gcp >= initialGlobalCheckpoint) : "global checkpoint [" + gcp + "] lower than initial gcp [" + initialGlobalCheckpoint + "]";
                return gcp;
            } : globalCheckpointSupplier;
            return new TranslogWriter(channelFactory, shardId, checkpoint, channel, file, bufferSize, writerGlobalCheckpointSupplier, minTranslogGenerationSupplier, header);
        }
        catch (Exception exception) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{channel});
            throw exception;
        }
    }

    public Exception getTragicException() {
        return this.tragedy;
    }

    private synchronized void closeWithTragicEvent(Exception ex) {
        assert (ex != null);
        if (this.tragedy == null) {
            this.tragedy = ex;
        } else if (this.tragedy != ex) {
            this.tragedy.addSuppressed(ex);
        }
        try {
            this.close();
        }
        catch (IOException | RuntimeException e) {
            ex.addSuppressed(e);
        }
    }

    public synchronized Translog.Location add(BytesReference data, long seqNo) throws IOException {
        this.ensureOpen();
        long offset = this.totalOffset;
        try {
            data.writeTo(this.outputStream);
        }
        catch (Exception ex) {
            this.closeWithTragicEvent(ex);
            throw ex;
        }
        this.totalOffset += (long)data.length();
        if (this.minSeqNo == -1L) assert (this.operationCounter == 0);
        if (this.maxSeqNo == -1L) assert (this.operationCounter == 0);
        this.minSeqNo = SequenceNumbers.min(this.minSeqNo, seqNo);
        this.maxSeqNo = SequenceNumbers.max(this.maxSeqNo, seqNo);
        ++this.operationCounter;
        assert (this.assertNoSeqNumberConflict(seqNo, data));
        return new Translog.Location(this.generation, offset, data.length());
    }

    private synchronized boolean assertNoSeqNumberConflict(long seqNo, BytesReference data) throws IOException {
        if (seqNo != -2L) {
            if (this.seenSequenceNumbers.containsKey(seqNo)) {
                Tuple<BytesReference, Exception> previous = this.seenSequenceNumbers.get(seqNo);
                if (!((BytesReference)previous.v1()).equals(data)) {
                    Translog.Operation newOp = Translog.readOperation(new BufferedChecksumStreamInput(data.streamInput()));
                    Translog.Operation prvOp = Translog.readOperation(new BufferedChecksumStreamInput(((BytesReference)previous.v1()).streamInput()));
                    throw new AssertionError("seqNo [" + seqNo + "] was processed twice in generation [" + this.generation + "], with different data. prvOp [" + prvOp + "], newOp [" + newOp + "]", (Throwable)previous.v2());
                }
            } else {
                this.seenSequenceNumbers.put(seqNo, (Tuple<BytesReference, Exception>)new Tuple((Object)new BytesArray(data.toBytesRef(), true), (Object)new RuntimeException("stack capture previous op")));
            }
        }
        return true;
    }

    public void sync() throws IOException {
        this.syncUpTo(Long.MAX_VALUE);
    }

    public boolean syncNeeded() {
        return this.totalOffset != this.lastSyncedCheckpoint.offset || this.globalCheckpointSupplier.getAsLong() != this.lastSyncedCheckpoint.globalCheckpoint || this.minTranslogGenerationSupplier.getAsLong() != this.lastSyncedCheckpoint.minTranslogGeneration;
    }

    @Override
    public int totalOperations() {
        return this.operationCounter;
    }

    @Override
    synchronized Checkpoint getCheckpoint() {
        return new Checkpoint(this.totalOffset, this.operationCounter, this.generation, this.minSeqNo, this.maxSeqNo, this.globalCheckpointSupplier.getAsLong(), this.minTranslogGenerationSupplier.getAsLong());
    }

    @Override
    public long sizeInBytes() {
        return this.totalOffset;
    }

    public TranslogReader closeIntoReader() throws IOException {
        Object object = this.syncLock;
        synchronized (object) {
            TranslogWriter translogWriter = this;
            synchronized (translogWriter) {
                try {
                    this.sync();
                }
                catch (Exception ex) {
                    this.closeWithTragicEvent(ex);
                    throw ex;
                }
                if (this.closed.compareAndSet(false, true)) {
                    return new TranslogReader(this.getLastSyncedCheckpoint(), this.channel, this.path, this.header);
                }
                throw new AlreadyClosedException("translog [" + this.getGeneration() + "] is already closed (path [" + this.path + "]", (Throwable)this.tragedy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TranslogSnapshot newSnapshot() {
        Object object = this.syncLock;
        synchronized (object) {
            TranslogWriter translogWriter = this;
            synchronized (translogWriter) {
                this.ensureOpen();
                try {
                    this.sync();
                }
                catch (IOException e) {
                    throw new TranslogException(this.shardId, "exception while syncing before creating a snapshot", e);
                }
                return super.newSnapshot();
            }
        }
    }

    private long getWrittenOffset() throws IOException {
        return this.channel.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncUpTo(long offset) throws IOException {
        if (this.lastSyncedCheckpoint.offset < offset && this.syncNeeded()) {
            Object object = this.syncLock;
            synchronized (object) {
                if (this.lastSyncedCheckpoint.offset < offset && this.syncNeeded()) {
                    Checkpoint checkpointToSync;
                    TranslogWriter translogWriter = this;
                    synchronized (translogWriter) {
                        this.ensureOpen();
                        try {
                            this.outputStream.flush();
                            checkpointToSync = this.getCheckpoint();
                        }
                        catch (Exception ex) {
                            this.closeWithTragicEvent(ex);
                            throw ex;
                        }
                    }
                    try {
                        this.channel.force(false);
                        TranslogWriter.writeCheckpoint(this.channelFactory, this.path.getParent(), checkpointToSync);
                    }
                    catch (Exception ex) {
                        this.closeWithTragicEvent(ex);
                        throw ex;
                    }
                    assert (this.lastSyncedCheckpoint.offset <= checkpointToSync.offset) : "illegal state: " + this.lastSyncedCheckpoint.offset + " <= " + checkpointToSync.offset;
                    this.lastSyncedCheckpoint = checkpointToSync;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBytes(ByteBuffer targetBuffer, long position) throws IOException {
        block6: {
            try {
                if (position + (long)targetBuffer.remaining() <= this.getWrittenOffset()) break block6;
                TranslogWriter translogWriter = this;
                synchronized (translogWriter) {
                    if (position + (long)targetBuffer.remaining() > this.getWrittenOffset()) {
                        this.outputStream.flush();
                    }
                }
            }
            catch (Exception ex) {
                this.closeWithTragicEvent(ex);
                throw ex;
            }
        }
        org.elasticsearch.common.io.Channels.readFromFileChannelWithEofException(this.channel, position, targetBuffer);
    }

    private static void writeCheckpoint(ChannelFactory channelFactory, Path translogFile, Checkpoint checkpoint) throws IOException {
        Checkpoint.write(channelFactory, translogFile.resolve("translog.ckp"), checkpoint, StandardOpenOption.WRITE);
    }

    Checkpoint getLastSyncedCheckpoint() {
        return this.lastSyncedCheckpoint;
    }

    protected final void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("translog [" + this.getGeneration() + "] is already closed", (Throwable)this.tragedy);
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.close();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    private final class BufferedChannelOutputStream
    extends BufferedOutputStream {
        BufferedChannelOutputStream(OutputStream out, int size) throws IOException {
            super(out, size);
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.count > 0) {
                try {
                    TranslogWriter.this.ensureOpen();
                    super.flush();
                }
                catch (Exception ex) {
                    TranslogWriter.this.closeWithTragicEvent(ex);
                    throw ex;
                }
            }
        }

        @Override
        public void close() throws IOException {
            throw new IllegalStateException("never close this stream");
        }
    }
}

