/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.Strings;

public final class Automatons {
    public static final Automaton EMPTY = Automata.makeEmpty();
    public static final Automaton MATCH_ALL = Automata.makeAnyString();
    static final char WILDCARD_STRING = '*';
    static final char WILDCARD_CHAR = '?';
    static final char WILDCARD_ESCAPE = '\\';

    private Automatons() {
    }

    public static Automaton patterns(String ... patterns) {
        return Automatons.patterns(Arrays.asList(patterns));
    }

    public static Automaton patterns(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            return EMPTY;
        }
        Automaton automaton = null;
        for (String pattern : patterns) {
            Automaton patternAutomaton = MinimizationOperations.minimize((Automaton)Automatons.pattern(pattern), (int)10000);
            automaton = automaton == null ? patternAutomaton : Automatons.unionAndMinimize(Arrays.asList(automaton, patternAutomaton));
        }
        return automaton;
    }

    static Automaton pattern(String pattern) {
        if (pattern.startsWith("/")) {
            if (pattern.length() == 1 || !pattern.endsWith("/")) {
                throw new IllegalArgumentException("invalid pattern [" + pattern + "]. patterns starting with '/' indicate regular expression pattern and therefore must also end with '/'. other patterns (those that do not start with '/') will be treated as simple wildcard patterns");
            }
            String regex = pattern.substring(1, pattern.length() - 1);
            return new RegExp(regex).toAutomaton();
        }
        if (pattern.equals("*")) {
            return MATCH_ALL;
        }
        return Automatons.wildcard(pattern);
    }

    static Automaton wildcard(String text) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        block5: for (int i = 0; i < text.length(); i += length) {
            char c = text.charAt(i);
            length = 1;
            switch (c) {
                case '*': {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case '?': {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case '\\': {
                    if (i + length < text.length()) {
                        char nextChar = text.charAt(i + length);
                        ++length;
                        automata.add(Automata.makeChar((int)nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(Automata.makeChar((int)c));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    public static Automaton unionAndMinimize(Collection<Automaton> automata) {
        Automaton res = Operations.union(automata);
        return MinimizationOperations.minimize((Automaton)res, (int)10000);
    }

    public static Automaton minusAndMinimize(Automaton a1, Automaton a2) {
        Automaton res = Operations.minus((Automaton)a1, (Automaton)a2, (int)10000);
        return MinimizationOperations.minimize((Automaton)res, (int)10000);
    }

    public static Predicate<String> predicate(String ... patterns) {
        return Automatons.predicate(Arrays.asList(patterns));
    }

    public static Predicate<String> predicate(Collection<String> patterns) {
        return Automatons.predicate(Automatons.patterns(patterns), Strings.collectionToDelimitedString(patterns, (String)"|"));
    }

    public static Predicate<String> predicate(Automaton automaton) {
        return Automatons.predicate(automaton, "Predicate for " + automaton);
    }

    private static Predicate<String> predicate(Automaton automaton, final String toString) {
        final CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton, 10000);
        return new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return runAutomaton.run(s);
            }

            public String toString() {
                return toString;
            }
        };
    }
}

