/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.ScrollCursor;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.session.AbstractRowSet;
import org.elasticsearch.xpack.sql.session.Cursor;

class SearchHitRowSet
extends AbstractRowSet {
    private final SearchHit[] hits;
    private final Cursor cursor;
    private final String scrollId;
    private final List<HitExtractor> extractors;
    private final Set<String> innerHits = new LinkedHashSet<String>();
    private final String innerHit;
    private final int size;
    private final int[] indexPerLevel;
    private int row = 0;

    SearchHitRowSet(List<HitExtractor> exts, SearchHit[] hits, int limit, String scrollId) {
        this.hits = hits;
        this.scrollId = scrollId;
        this.extractors = exts;
        String innerHit = null;
        for (HitExtractor ex : exts) {
            innerHit = ex.hitName();
            if (innerHit == null) continue;
            this.innerHits.add(innerHit);
        }
        int sz = hits.length;
        int maxDepth = 0;
        if (!this.innerHits.isEmpty()) {
            if (this.innerHits.size() > 1) {
                throw new SqlIllegalArgumentException("Multi-nested docs not yet supported {}", this.innerHits);
            }
            maxDepth = 1;
            sz = 0;
            for (SearchHit hit : hits) {
                for (String ih : this.innerHits) {
                    SearchHits sh = (SearchHits)hit.getInnerHits().get(ih);
                    if (sh == null) continue;
                    sz += sh.getHits().length;
                }
            }
        }
        this.size = limit < 0 ? sz : Math.min(sz, limit);
        this.indexPerLevel = new int[maxDepth + 1];
        this.innerHit = innerHit;
        if (scrollId == null) {
            this.cursor = Cursor.EMPTY;
        } else {
            int remainingLimit = limit < 0 ? limit : limit - this.size;
            this.cursor = this.size == 0 || remainingLimit == 0 ? Cursor.EMPTY : new ScrollCursor(scrollId, this.extractors, remainingLimit);
        }
    }

    @Override
    public int columnCount() {
        return this.extractors.size();
    }

    @Override
    protected Object getColumn(int column) {
        HitExtractor e = this.extractors.get(column);
        int extractorLevel = e.hitName() == null ? 0 : 1;
        SearchHit hit = null;
        SearchHit[] sh = this.hits;
        for (int lvl = 0; lvl <= extractorLevel; ++lvl) {
            if (hit != null) {
                SearchHits innerHits = (SearchHits)hit.getInnerHits().get(this.innerHit);
                sh = innerHits == null ? SearchHits.EMPTY : innerHits.getHits();
            }
            hit = sh[this.indexPerLevel[lvl]];
        }
        return e.extract(hit);
    }

    @Override
    protected boolean doHasCurrent() {
        return this.row < this.size;
    }

    @Override
    protected boolean doNext() {
        if (this.row < this.size - 1) {
            ++this.row;
            int n = this.indexPerLevel.length - 1;
            this.indexPerLevel[n] = this.indexPerLevel[n] + 1;
            SearchHit[] sh = this.hits;
            for (int lvl = 0; lvl < this.indexPerLevel.length; ++lvl) {
                String path;
                if (this.indexPerLevel[lvl] == sh.length) {
                    this.indexPerLevel[lvl] = 0;
                    int n2 = lvl - 1;
                    this.indexPerLevel[n2] = this.indexPerLevel[n2] + 1;
                    lvl = 0;
                    sh = this.hits;
                    continue;
                }
                SearchHit h = sh[this.indexPerLevel[lvl]];
                String string = path = lvl == 0 ? this.innerHit : null;
                if (path == null) continue;
                SearchHits innerHits = (SearchHits)h.getInnerHits().get(path);
                sh = innerHits == null ? SearchHits.EMPTY : innerHits.getHits();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doReset() {
        this.row = 0;
        Arrays.fill(this.indexPerLevel, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String scrollId() {
        return this.scrollId;
    }

    @Override
    public Cursor nextPageCursor() {
        return this.cursor;
    }
}

