/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.parser.LogicalPlanBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.plan.logical.command.Debug;
import org.elasticsearch.xpack.sql.plan.logical.command.Explain;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowColumns;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowFunctions;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowSchemas;
import org.elasticsearch.xpack.sql.plan.logical.command.ShowTables;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysCatalogs;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysColumns;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysTableTypes;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysTables;
import org.elasticsearch.xpack.sql.plan.logical.command.sys.SysTypes;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.tree.Location;

abstract class CommandBuilder
extends LogicalPlanBuilder {
    protected CommandBuilder(Map<Token, SqlTypedParamValue> params) {
        super(params);
    }

    @Override
    public Command visitDebug(SqlBaseParser.DebugContext ctx) {
        Location loc = CommandBuilder.source(ctx);
        if (ctx.FORMAT().size() > 1) {
            throw new ParsingException(loc, "Debug FORMAT should be specified at most once", new Object[0]);
        }
        if (ctx.PLAN().size() > 1) {
            throw new ParsingException(loc, "Debug PLAN should be specified at most once", new Object[0]);
        }
        Debug.Type type = null;
        if (ctx.type != null) {
            type = ctx.type.getType() == 7 ? Debug.Type.ANALYZED : Debug.Type.OPTIMIZED;
        }
        boolean graphViz = ctx.format != null && ctx.format.getType() == 32;
        Debug.Format format = graphViz ? Debug.Format.GRAPHVIZ : Debug.Format.TEXT;
        return new Debug(loc, this.plan((ParseTree)ctx.statement()), type, format);
    }

    @Override
    public Command visitExplain(SqlBaseParser.ExplainContext ctx) {
        Location loc = CommandBuilder.source(ctx);
        if (ctx.PLAN().size() > 1) {
            throw new ParsingException(loc, "Explain TYPE should be specified at most once", new Object[0]);
        }
        if (ctx.FORMAT().size() > 1) {
            throw new ParsingException(loc, "Explain FORMAT should be specified at most once", new Object[0]);
        }
        if (ctx.VERIFY().size() > 1) {
            throw new ParsingException(loc, "Explain VERIFY should be specified at most once", new Object[0]);
        }
        Explain.Type type = null;
        if (ctx.type != null) {
            switch (ctx.type.getType()) {
                case 52: {
                    type = Explain.Type.PARSED;
                    break;
                }
                case 7: {
                    type = Explain.Type.ANALYZED;
                    break;
                }
                case 48: {
                    type = Explain.Type.OPTIMIZED;
                    break;
                }
                case 42: {
                    type = Explain.Type.MAPPED;
                    break;
                }
                case 23: {
                    type = Explain.Type.EXECUTABLE;
                    break;
                }
                default: {
                    type = Explain.Type.ALL;
                }
            }
        }
        boolean graphViz = ctx.format != null && ctx.format.getType() == 32;
        Explain.Format format = graphViz ? Explain.Format.GRAPHVIZ : Explain.Format.TEXT;
        boolean verify = ctx.verify != null ? Booleans.parseBoolean((String)ctx.verify.getText().toLowerCase(Locale.ROOT), (boolean)true) : true;
        return new Explain(loc, this.plan((ParseTree)ctx.statement()), type, format, verify);
    }

    @Override
    public Object visitShowFunctions(SqlBaseParser.ShowFunctionsContext ctx) {
        return new ShowFunctions(CommandBuilder.source(ctx), this.visitPattern(ctx.pattern()));
    }

    @Override
    public Object visitShowTables(SqlBaseParser.ShowTablesContext ctx) {
        return new ShowTables(CommandBuilder.source(ctx), this.visitPattern(ctx.pattern()));
    }

    @Override
    public Object visitShowSchemas(SqlBaseParser.ShowSchemasContext ctx) {
        return new ShowSchemas(CommandBuilder.source(ctx));
    }

    @Override
    public Object visitShowColumns(SqlBaseParser.ShowColumnsContext ctx) {
        TableIdentifier identifier = this.visitTableIdentifier(ctx.tableIdentifier());
        return new ShowColumns(CommandBuilder.source(ctx), identifier.index());
    }

    @Override
    public Object visitSysCatalogs(SqlBaseParser.SysCatalogsContext ctx) {
        return new SysCatalogs(CommandBuilder.source(ctx));
    }

    @Override
    public SysTables visitSysTables(SqlBaseParser.SysTablesContext ctx) {
        ArrayList<IndexResolver.IndexType> types = new ArrayList<IndexResolver.IndexType>();
        for (SqlBaseParser.StringContext string : ctx.string()) {
            String value = this.string(string);
            if (value == null || value.equals("%") && ctx.string().size() == 1) continue;
            IndexResolver.IndexType type = IndexResolver.IndexType.from(value);
            types.add(type);
        }
        EnumSet<IndexResolver.IndexType> set = types.isEmpty() ? null : EnumSet.copyOf(types);
        return new SysTables(CommandBuilder.source(ctx), this.visitPattern(ctx.clusterPattern), this.visitPattern(ctx.tablePattern), set);
    }

    @Override
    public Object visitSysColumns(SqlBaseParser.SysColumnsContext ctx) {
        Location loc = CommandBuilder.source(ctx);
        return new SysColumns(loc, this.string(ctx.cluster), this.visitPattern(ctx.indexPattern), this.visitPattern(ctx.columnPattern));
    }

    @Override
    public SysTypes visitSysTypes(SqlBaseParser.SysTypesContext ctx) {
        return new SysTypes(CommandBuilder.source(ctx));
    }

    @Override
    public Object visitSysTableTypes(SqlBaseParser.SysTableTypesContext ctx) {
        return new SysTableTypes(CommandBuilder.source(ctx));
    }
}

