/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.plan.physical.UnplannedExec;
import org.elasticsearch.xpack.sql.tree.Node;

abstract class Verifier {
    Verifier() {
    }

    private static Failure fail(Node<?> source, String message) {
        return new Failure(source, message);
    }

    static List<Failure> verifyMappingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof UnplannedExec) {
                failures.add(Verifier.fail(p, "Unplanned item"));
            }
            p.forEachExpressionsUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Verifier.fail(e, "Unresolved expression"));
                }
            });
            if (p instanceof AggregateExec) {
                Verifier.forbidMultiFieldGroupBy((AggregateExec)p, failures);
            }
        });
        return failures;
    }

    private static void forbidMultiFieldGroupBy(AggregateExec a, List<Failure> failures) {
        if (a.groupings().size() > 1) {
            failures.add(Verifier.fail(a.groupings().get(0), "Currently, only a single expression can be used with GROUP BY; please select one of " + Expressions.names(a.groupings())));
        }
    }

    static List<Failure> verifyExecutingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof Unexecutable) {
                failures.add(Verifier.fail(p, "Unexecutable item"));
            }
            p.forEachExpressionsUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Verifier.fail(e, "Unresolved expression"));
                }
            });
        });
        return failures;
    }

    static class Failure {
        private final Node<?> source;
        private final String message;

        Failure(Node<?> source, String message) {
            this.source = source;
            this.message = message;
        }

        Node<?> source() {
            return this.source;
        }

        String message() {
            return this.message;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Failure other = (Failure)obj;
            return Objects.equals(this.source, other.source);
        }
    }
}

