/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.watermarkpack;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceBrushedMetalWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;
    private Image brushedMetalTile = null;

    public SubstanceBrushedMetalWatermark() {
        try {
            ClassLoader cl = SubstanceCoreUtilities.getClassLoaderForResources();
            URL metalUrl = cl.getResource("org/jvnet/substance/watermarkpack/brushed.gif");
            this.brushedMetalTile = ImageIO.read(metalUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.7f);
        graphics.setComposite(comp);
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x - 60, y - 120, 60 + width, 120 + height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        if (this.brushedMetalTile == null) {
            return false;
        }
        for (int row = 0; row < height; row += this.brushedMetalTile.getWidth(null)) {
            for (int col = 0; col < width; col += this.brushedMetalTile.getHeight(null)) {
                graphics.drawImage(this.brushedMetalTile, x + col, y + row, null);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Brushed Metal";
    }

    public void dispose() {
        watermarkImage = null;
    }
}

