/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_NOTIFICATIONITEM_API_H
#define __FCITX_MODULE_FCITX_NOTIFICATIONITEM_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "notificationitem.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-notificationitem", NotificationItem)

DEFINE_GET_AND_INVOKE_FUNC(NotificationItem, Enable, 0)
static inline boolean
FcitxNotificationItemEnable(FcitxInstance *instance, FcitxNotificationItemAvailableCallback _arg0, void* _arg1)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, FcitxNotificationItemAvailableCallback, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, void*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    result = FcitxNotificationItemInvokeEnable(instance, args);
    FCITX_RETURN_FROM_PTR(boolean, result);
}

DEFINE_GET_AND_INVOKE_FUNC(NotificationItem, Disable, 1)
static inline void
FcitxNotificationItemDisable(FcitxInstance *instance)
{
    FCITX_DEF_MODULE_ARGS(args);
    FcitxNotificationItemInvokeDisable(instance, args);
}


#ifdef __cplusplus
}
#endif

#endif
