/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.render.intermediate.GraphicsPainter;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.traits.BorderProps;

public class BorderPainter {
    protected static final int TOP = 0;
    protected static final int RIGHT = 1;
    protected static final int BOTTOM = 2;
    protected static final int LEFT = 3;
    protected static final int TOP_LEFT = 0;
    protected static final int TOP_RIGHT = 1;
    protected static final int BOTTOM_RIGHT = 2;
    protected static final int BOTTOM_LEFT = 3;
    public static final float DASHED_BORDER_SPACE_RATIO = 0.5f;
    protected static final float DASHED_BORDER_LENGTH_FACTOR = 2.0f;
    private final GraphicsPainter graphicsPainter;

    public BorderPainter(GraphicsPainter graphicsPainter) {
        this.graphicsPainter = graphicsPainter;
    }

    public void drawBorders(Rectangle borderRect, BorderProps bpsTop, BorderProps bpsBottom, BorderProps bpsLeft, BorderProps bpsRight, Color innerBackgroundColor) throws IFException {
        try {
            this.drawRoundedBorders(borderRect, bpsTop, bpsBottom, bpsLeft, bpsRight);
        }
        catch (IOException ioe) {
            throw new IFException("IO error drawing borders", ioe);
        }
    }

    private BorderProps sanitizeBorderProps(BorderProps bps) {
        return bps == null ? bps : (bps.width == 0 ? (BorderProps)null : bps);
    }

    protected void drawRectangularBorders(Rectangle borderRect, BorderProps bpsTop, BorderProps bpsBottom, BorderProps bpsLeft, BorderProps bpsRight) throws IOException {
        int ey1a;
        int sy1a;
        int innerx;
        int clipx;
        int outerx;
        int ey2;
        int ey1;
        int sy2;
        int sy1;
        int ex1a;
        int sx1a;
        int innery;
        int clipy;
        int outery;
        int ex2;
        int ex1;
        int sx2;
        int sx1;
        bpsTop = this.sanitizeBorderProps(bpsTop);
        bpsBottom = this.sanitizeBorderProps(bpsBottom);
        bpsLeft = this.sanitizeBorderProps(bpsLeft);
        bpsRight = this.sanitizeBorderProps(bpsRight);
        int startx = borderRect.x;
        int starty = borderRect.y;
        int width = borderRect.width;
        int height = borderRect.height;
        boolean[] b = new boolean[]{bpsTop != null, bpsRight != null, bpsBottom != null, bpsLeft != null};
        if (!(b[0] || b[1] || b[2] || b[3])) {
            return;
        }
        int[] bw = new int[]{b[0] ? bpsTop.width : 0, b[1] ? bpsRight.width : 0, b[2] ? bpsBottom.width : 0, b[3] ? bpsLeft.width : 0};
        int[] clipw = new int[]{BorderProps.getClippedWidth(bpsTop), BorderProps.getClippedWidth(bpsRight), BorderProps.getClippedWidth(bpsBottom), BorderProps.getClippedWidth(bpsLeft)};
        starty += clipw[0];
        height -= clipw[0];
        height -= clipw[2];
        startx += clipw[3];
        width -= clipw[3];
        width -= clipw[1];
        boolean[] slant = new boolean[]{b[3] && b[0], b[0] && b[1], b[1] && b[2], b[2] && b[3]};
        if (bpsTop != null) {
            sx1 = startx;
            sx2 = slant[0] ? sx1 + bw[3] - clipw[3] : sx1;
            ex1 = startx + width;
            ex2 = slant[1] ? ex1 - bw[1] + clipw[1] : ex1;
            outery = starty - clipw[0];
            clipy = outery + clipw[0];
            innery = outery + bw[0];
            this.saveGraphicsState();
            this.moveTo(sx1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (this.isCollapseOuter(bpsTop)) {
                if (this.isCollapseOuter(bpsLeft)) {
                    sx1a -= clipw[3];
                }
                if (this.isCollapseOuter(bpsRight)) {
                    ex1a += clipw[1];
                }
                this.lineTo(sx1a, outery);
                this.lineTo(ex1a, outery);
            }
            this.lineTo(ex1, clipy);
            this.lineTo(ex2, innery);
            this.lineTo(sx2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, outery, ex1a, innery, true, true, bpsTop.style, bpsTop.color);
            this.restoreGraphicsState();
        }
        if (bpsRight != null) {
            sy1 = starty;
            sy2 = slant[1] ? sy1 + bw[0] - clipw[0] : sy1;
            ey1 = starty + height;
            ey2 = slant[2] ? ey1 - bw[2] + clipw[2] : ey1;
            outerx = startx + width + clipw[1];
            clipx = outerx - clipw[1];
            innerx = outerx - bw[1];
            this.saveGraphicsState();
            this.moveTo(clipx, sy1);
            sy1a = sy1;
            ey1a = ey1;
            if (this.isCollapseOuter(bpsRight)) {
                if (this.isCollapseOuter(bpsTop)) {
                    sy1a -= clipw[0];
                }
                if (this.isCollapseOuter(bpsBottom)) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, sy1a);
                this.lineTo(outerx, ey1a);
            }
            this.lineTo(clipx, ey1);
            this.lineTo(innerx, ey2);
            this.lineTo(innerx, sy2);
            this.closePath();
            this.clip();
            this.drawBorderLine(innerx, sy1a, outerx, ey1a, false, false, bpsRight.style, bpsRight.color);
            this.restoreGraphicsState();
        }
        if (bpsBottom != null) {
            sx1 = startx;
            sx2 = slant[3] ? sx1 + bw[3] - clipw[3] : sx1;
            ex1 = startx + width;
            ex2 = slant[2] ? ex1 - bw[1] + clipw[1] : ex1;
            outery = starty + height + clipw[2];
            clipy = outery - clipw[2];
            innery = outery - bw[2];
            this.saveGraphicsState();
            this.moveTo(ex1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (this.isCollapseOuter(bpsBottom)) {
                if (this.isCollapseOuter(bpsLeft)) {
                    sx1a -= clipw[3];
                }
                if (this.isCollapseOuter(bpsRight)) {
                    ex1a += clipw[1];
                }
                this.lineTo(ex1a, outery);
                this.lineTo(sx1a, outery);
            }
            this.lineTo(sx1, clipy);
            this.lineTo(sx2, innery);
            this.lineTo(ex2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, innery, ex1a, outery, true, false, bpsBottom.style, bpsBottom.color);
            this.restoreGraphicsState();
        }
        if (bpsLeft != null) {
            sy1 = starty;
            sy2 = slant[0] ? sy1 + bw[0] - clipw[0] : sy1;
            ey1 = sy1 + height;
            ey2 = slant[3] ? ey1 - bw[2] + clipw[2] : ey1;
            outerx = startx - clipw[3];
            clipx = outerx + clipw[3];
            innerx = outerx + bw[3];
            this.saveGraphicsState();
            this.moveTo(clipx, ey1);
            sy1a = sy1;
            ey1a = ey1;
            if (this.isCollapseOuter(bpsLeft)) {
                if (this.isCollapseOuter(bpsTop)) {
                    sy1a -= clipw[0];
                }
                if (this.isCollapseOuter(bpsBottom)) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, ey1a);
                this.lineTo(outerx, sy1a);
            }
            this.lineTo(clipx, sy1);
            this.lineTo(innerx, sy2);
            this.lineTo(innerx, ey2);
            this.closePath();
            this.clip();
            this.drawBorderLine(outerx, sy1a, innerx, ey1a, false, true, bpsLeft.style, bpsLeft.color);
            this.restoreGraphicsState();
        }
    }

    private boolean isCollapseOuter(BorderProps bp) {
        return bp != null && bp.isCollapseOuter();
    }

    public static float dashWidthCalculator(float borderLength, float borderWidth) {
        int period;
        float dashWidth = 2.0f * borderWidth;
        if (borderWidth < 3.0f) {
            dashWidth = 6.0f * borderWidth;
        }
        period = (period = (int)((borderLength - dashWidth) / dashWidth / 1.5f)) < 0 ? 0 : period;
        return borderLength / ((float)period * 1.5f + 1.0f);
    }

    protected void drawRoundedBorders(Rectangle borderRect, BorderProps beforeBorderProps, BorderProps afterBorderProps, BorderProps startBorderProps, BorderProps endBorderProps) throws IOException {
        BorderSegment before = BorderPainter.borderSegmentForBefore(beforeBorderProps);
        BorderSegment after = BorderPainter.borderSegmentForAfter(afterBorderProps);
        BorderSegment start = BorderPainter.borderSegmentForStart(startBorderProps);
        BorderSegment end = BorderPainter.borderSegmentForEnd(endBorderProps);
        if (before.getWidth() == 0 && after.getWidth() == 0 && start.getWidth() == 0 && end.getWidth() == 0) {
            return;
        }
        int startx = borderRect.x + start.getClippedWidth();
        int starty = borderRect.y + before.getClippedWidth();
        int width = borderRect.width - start.getClippedWidth() - end.getClippedWidth();
        int height = borderRect.height - before.getClippedWidth() - after.getClippedWidth();
        double cornerCorrectionFactor = BorderPainter.calculateCornerScaleCorrection(width, height, before, after, start, end);
        this.drawBorderSegment(start, before, end, 0, width, startx, starty, cornerCorrectionFactor);
        this.drawBorderSegment(before, end, after, 1, height, startx + width, starty, cornerCorrectionFactor);
        this.drawBorderSegment(end, after, start, 2, width, startx + width, starty + height, cornerCorrectionFactor);
        this.drawBorderSegment(after, start, before, 3, height, startx, starty + height, cornerCorrectionFactor);
    }

    private void drawBorderSegment(BorderSegment start, BorderSegment before, BorderSegment end, int orientation, int width, int x, int y, double cornerCorrectionFactor) throws IOException {
        if (before.getWidth() != 0) {
            int sx2 = start.getWidth() - start.getClippedWidth();
            int ex1 = width;
            int ex2 = ex1 - end.getWidth() + end.getClippedWidth();
            int outery = -before.getClippedWidth();
            int innery = outery + before.getWidth();
            int ellipseSBRadiusX = BorderPainter.correctRadius(cornerCorrectionFactor, start.getRadiusEnd());
            int ellipseSBRadiusY = BorderPainter.correctRadius(cornerCorrectionFactor, before.getRadiusStart());
            int ellipseBERadiusX = BorderPainter.correctRadius(cornerCorrectionFactor, end.getRadiusStart());
            int ellipseBERadiusY = BorderPainter.correctRadius(cornerCorrectionFactor, before.getRadiusEnd());
            this.saveGraphicsState();
            this.translateCoordinates(x, y);
            if (orientation != 0) {
                this.rotateCoordinates(Math.PI * (double)orientation / 2.0);
            }
            int ellipseSBX = ellipseSBRadiusX;
            int ellipseSBY = ellipseSBRadiusY;
            int ellipseBEX = ex1 - ellipseBERadiusX;
            int ellipseBEY = ellipseBERadiusY;
            int sx1a = 0;
            int ex1a = ex1;
            if (ellipseSBRadiusX != 0 && ellipseSBRadiusY != 0) {
                double[] joinMetrics = this.getCornerBorderJoinMetrics(ellipseSBRadiusX, ellipseSBRadiusY, sx2, innery);
                double outerJoinPointX = joinMetrics[0];
                double outerJoinPointY = joinMetrics[1];
                double sbJoinAngle = joinMetrics[2];
                this.moveTo((int)outerJoinPointX, (int)outerJoinPointY);
                this.arcTo(Math.PI + sbJoinAngle, 4.71238898038469, ellipseSBX, ellipseSBY, ellipseSBRadiusX, ellipseSBRadiusY);
            } else {
                this.moveTo(0, 0);
                if (before.isCollapseOuter()) {
                    if (start.isCollapseOuter()) {
                        sx1a -= start.getClippedWidth();
                    }
                    if (end.isCollapseOuter()) {
                        ex1a += end.getClippedWidth();
                    }
                    this.lineTo(sx1a, outery);
                    this.lineTo(ex1a, outery);
                }
            }
            if (ellipseBERadiusX != 0 && ellipseBERadiusY != 0) {
                double[] outerJoinMetrics = this.getCornerBorderJoinMetrics(ellipseBERadiusX, ellipseBERadiusY, ex1 - ex2, innery);
                double beJoinAngle = ex1 == ex2 ? 1.5707963267948966 : 1.5707963267948966 - outerJoinMetrics[2];
                this.lineTo(ellipseBEX, 0);
                this.arcTo(4.71238898038469, 4.71238898038469 + beJoinAngle, ellipseBEX, ellipseBEY, ellipseBERadiusX, ellipseBERadiusY);
                if (ellipseBEX < ex2 && ellipseBEY > innery) {
                    double[] innerJoinMetrics = this.getCornerBorderJoinMetrics((double)ex2 - (double)ellipseBEX, (double)ellipseBEY - (double)innery, ex1 - ex2, innery);
                    double innerJoinPointX = innerJoinMetrics[0];
                    double innerJoinPointY = innerJoinMetrics[1];
                    double beInnerJoinAngle = 1.5707963267948966 - innerJoinMetrics[2];
                    this.lineTo((int)((double)ex2 - innerJoinPointX), (int)(innerJoinPointY + (double)innery));
                    this.arcTo(beInnerJoinAngle + 4.71238898038469, 4.71238898038469, ellipseBEX, ellipseBEY, ex2 - ellipseBEX, ellipseBEY - innery);
                } else {
                    this.lineTo(ex2, innery);
                }
            } else {
                this.lineTo(ex1, 0);
                this.lineTo(ex2, innery);
            }
            if (ellipseSBRadiusX == 0) {
                this.lineTo(sx2, innery);
            } else if (ellipseSBX > sx2 && ellipseSBY > innery) {
                double[] innerJoinMetrics = this.getCornerBorderJoinMetrics(ellipseSBRadiusX - sx2, ellipseSBRadiusY - innery, sx2, innery);
                double sbInnerJoinAngle = innerJoinMetrics[2];
                this.lineTo(ellipseSBX, innery);
                this.arcTo(4.71238898038469, sbInnerJoinAngle + Math.PI, ellipseSBX, ellipseSBY, ellipseSBX - sx2, ellipseSBY - innery);
            } else {
                this.lineTo(sx2, innery);
            }
            this.closePath();
            this.clip();
            if (ellipseBERadiusY == 0 && ellipseSBRadiusY == 0) {
                this.drawBorderLine(sx1a, outery, ex1a, innery, true, true, before.getStyle(), before.getColor());
            } else {
                int innerFillY = Math.max(Math.max(ellipseBEY, ellipseSBY), innery);
                this.drawBorderLine(sx1a, outery, ex1a, innerFillY, true, true, before.getStyle(), before.getColor());
            }
            this.restoreGraphicsState();
        }
    }

    private static int correctRadius(double cornerCorrectionFactor, int radius) {
        return (int)Math.round(cornerCorrectionFactor * (double)radius);
    }

    private static BorderSegment borderSegmentForBefore(BorderProps before) {
        return AbstractBorderSegment.asBorderSegment(before);
    }

    private static BorderSegment borderSegmentForAfter(BorderProps after) {
        return AbstractBorderSegment.asFlippedBorderSegment(after);
    }

    private static BorderSegment borderSegmentForStart(BorderProps start) {
        return AbstractBorderSegment.asFlippedBorderSegment(start);
    }

    private static BorderSegment borderSegmentForEnd(BorderProps end) {
        return AbstractBorderSegment.asBorderSegment(end);
    }

    private double[] getCornerBorderJoinMetrics(double ellipseCenterX, double ellipseCenterY, double xWidth, double yWidth) {
        if (xWidth > 0.0) {
            return this.getCornerBorderJoinMetrics(ellipseCenterX, ellipseCenterY, yWidth / xWidth);
        }
        return new double[]{0.0, ellipseCenterY, 0.0};
    }

    private double[] getCornerBorderJoinMetrics(double ellipseCenterX, double ellipseCenterY, double borderWidthRatio) {
        double x = ellipseCenterY * ellipseCenterX * (ellipseCenterY + ellipseCenterX * borderWidthRatio - Math.sqrt(2.0 * ellipseCenterX * ellipseCenterY * borderWidthRatio)) / (ellipseCenterY * ellipseCenterY + ellipseCenterX * ellipseCenterX * borderWidthRatio * borderWidthRatio);
        double y = borderWidthRatio * x;
        return new double[]{x, y, Math.atan((ellipseCenterY - y) / (ellipseCenterX - x))};
    }

    public void clipBackground(Rectangle rect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) throws IOException {
        BorderSegment before = BorderPainter.borderSegmentForBefore(bpsBefore);
        BorderSegment after = BorderPainter.borderSegmentForAfter(bpsAfter);
        BorderSegment start = BorderPainter.borderSegmentForStart(bpsStart);
        BorderSegment end = BorderPainter.borderSegmentForEnd(bpsEnd);
        int startx = rect.x;
        int starty = rect.y;
        int width = rect.width;
        int height = rect.height;
        double correctionFactor = BorderPainter.calculateCornerCorrectionFactor(width + start.getWidth() + end.getWidth(), height + before.getWidth() + after.getWidth(), bpsBefore, bpsAfter, bpsStart, bpsEnd);
        Corner cornerBeforeEnd = Corner.createBeforeEndCorner(before, end, correctionFactor);
        Corner cornerEndAfter = Corner.createEndAfterCorner(end, after, correctionFactor);
        Corner cornerAfterStart = Corner.createAfterStartCorner(after, start, correctionFactor);
        Corner cornerStartBefore = Corner.createStartBeforeCorner(start, before, correctionFactor);
        new PathPainter(startx + cornerStartBefore.radiusX, starty).lineHorizTo(width - cornerStartBefore.radiusX - cornerBeforeEnd.radiusX).drawCorner(cornerBeforeEnd).lineVertTo(height - cornerBeforeEnd.radiusY - cornerEndAfter.radiusY).drawCorner(cornerEndAfter).lineHorizTo(cornerEndAfter.radiusX + cornerAfterStart.radiusX - width).drawCorner(cornerAfterStart).lineVertTo(cornerAfterStart.radiusY + cornerStartBefore.radiusY - height).drawCorner(cornerStartBefore);
        this.clip();
    }

    protected static double calculateCornerCorrectionFactor(int width, int height, BorderProps before, BorderProps after, BorderProps start, BorderProps end) {
        return BorderPainter.calculateCornerScaleCorrection(width, height, BorderPainter.borderSegmentForBefore(before), BorderPainter.borderSegmentForAfter(after), BorderPainter.borderSegmentForStart(start), BorderPainter.borderSegmentForEnd(end));
    }

    protected static double calculateCornerScaleCorrection(int width, int height, BorderSegment before, BorderSegment after, BorderSegment start, BorderSegment end) {
        return CornerScaleCorrectionCalculator.calculate(width, height, before, after, start, end);
    }

    private void drawBorderLine(int x1, int y1, int x2, int y2, boolean horz, boolean startOrBefore, int style, Color color) throws IOException {
        this.graphicsPainter.drawBorderLine(x1, y1, x2, y2, horz, startOrBefore, style, color);
    }

    private void moveTo(int x, int y) throws IOException {
        this.graphicsPainter.moveTo(x, y);
    }

    private void lineTo(int x, int y) throws IOException {
        this.graphicsPainter.lineTo(x, y);
    }

    private void arcTo(double startAngle, double endAngle, int cx, int cy, int width, int height) throws IOException {
        this.graphicsPainter.arcTo(startAngle, endAngle, cx, cy, width, height);
    }

    private void rotateCoordinates(double angle) throws IOException {
        this.graphicsPainter.rotateCoordinates(angle);
    }

    private void translateCoordinates(int xTranslate, int yTranslate) throws IOException {
        this.graphicsPainter.translateCoordinates(xTranslate, yTranslate);
    }

    private void closePath() throws IOException {
        this.graphicsPainter.closePath();
    }

    private void clip() throws IOException {
        this.graphicsPainter.clip();
    }

    private void saveGraphicsState() throws IOException {
        this.graphicsPainter.saveGraphicsState();
    }

    private void restoreGraphicsState() throws IOException {
        this.graphicsPainter.restoreGraphicsState();
    }

    private static final class CornerScaleCorrectionCalculator {
        private double correctionFactor = 1.0;

        private CornerScaleCorrectionCalculator(int width, int height, BorderSegment before, BorderSegment after, BorderSegment start, BorderSegment end) {
            this.calculateForSegment(width, start, before, end);
            this.calculateForSegment(height, before, end, after);
            this.calculateForSegment(width, end, after, start);
            this.calculateForSegment(height, after, start, before);
        }

        public static double calculate(int width, int height, BorderSegment before, BorderSegment after, BorderSegment start, BorderSegment end) {
            return new CornerScaleCorrectionCalculator((int)width, (int)height, (BorderSegment)before, (BorderSegment)after, (BorderSegment)start, (BorderSegment)end).correctionFactor;
        }

        private void calculateForSegment(int width, BorderSegment bpsStart, BorderSegment bpsBefore, BorderSegment bpsEnd) {
            double thisCorrectionFactor;
            double ellipseExtent;
            if (bpsBefore.isSpecified() && (ellipseExtent = (double)(bpsStart.getRadiusEnd() + bpsEnd.getRadiusStart())) > 0.0 && (thisCorrectionFactor = (double)width / ellipseExtent) < this.correctionFactor) {
                this.correctionFactor = thisCorrectionFactor;
            }
        }
    }

    private final class PathPainter {
        private int x;
        private int y;

        PathPainter(int x, int y) throws IOException {
            this.moveTo(x, y);
        }

        private void moveTo(int x, int y) throws IOException {
            this.x += x;
            this.y += y;
            BorderPainter.this.moveTo(this.x, this.y);
        }

        public PathPainter lineTo(int x, int y) throws IOException {
            this.x += x;
            this.y += y;
            BorderPainter.this.lineTo(this.x, this.y);
            return this;
        }

        public PathPainter lineHorizTo(int x) throws IOException {
            return this.lineTo(x, 0);
        }

        public PathPainter lineVertTo(int y) throws IOException {
            return this.lineTo(0, y);
        }

        PathPainter drawCorner(Corner corner) throws IOException {
            if (corner.radiusX == 0 && corner.radiusY == 0) {
                return this;
            }
            if (corner.radiusX == 0 || corner.radiusY == 0) {
                this.x += corner.incrementX;
                this.y += corner.incrementY;
                BorderPainter.this.lineTo(this.x, this.y);
                return this;
            }
            BorderPainter.this.arcTo(corner.angles.start, corner.angles.end, this.x + corner.centerX, this.y + corner.centerY, corner.radiusX, corner.radiusY);
            this.x += corner.incrementX;
            this.y += corner.incrementY;
            return this;
        }
    }

    private static final class Corner {
        private static final Corner SQUARE = new Corner(0, 0, null, 0, 0, 0, 0);
        private final int radiusX;
        private final int radiusY;
        private final CornerAngles angles;
        private final int centerX;
        private final int centerY;
        private final int incrementX;
        private final int incrementY;

        private Corner(int radiusX, int radiusY, CornerAngles angles, int ellipseOffsetX, int ellipseOffsetY, int incrementX, int incrementY) {
            this.radiusX = radiusX;
            this.radiusY = radiusY;
            this.angles = angles;
            this.centerX = ellipseOffsetX;
            this.centerY = ellipseOffsetY;
            this.incrementX = incrementX;
            this.incrementY = incrementY;
        }

        private static int extentFromRadiusStart(BorderSegment border, double correctionFactor) {
            return Corner.extentFromRadius(border.getRadiusStart(), border, correctionFactor);
        }

        private static int extentFromRadiusEnd(BorderSegment border, double correctionFactor) {
            return Corner.extentFromRadius(border.getRadiusEnd(), border, correctionFactor);
        }

        private static int extentFromRadius(int radius, BorderSegment border, double correctionFactor) {
            return Math.max((int)((double)radius * correctionFactor) - border.getWidth(), 0);
        }

        public static Corner createBeforeEndCorner(BorderSegment before, BorderSegment end, double correctionFactor) {
            int width = end.getRadiusStart();
            int height = before.getRadiusEnd();
            if (width == 0 || height == 0) {
                return SQUARE;
            }
            int x = Corner.extentFromRadiusStart(end, correctionFactor);
            int y = Corner.extentFromRadiusEnd(before, correctionFactor);
            return new Corner(x, y, CornerAngles.BEFORE_END, 0, y, x, y);
        }

        public static Corner createEndAfterCorner(BorderSegment end, BorderSegment after, double correctionFactor) {
            int width = end.getRadiusEnd();
            int height = after.getRadiusStart();
            if (width == 0 || height == 0) {
                return SQUARE;
            }
            int x = Corner.extentFromRadiusEnd(end, correctionFactor);
            int y = Corner.extentFromRadiusStart(after, correctionFactor);
            return new Corner(x, y, CornerAngles.END_AFTER, -x, 0, -x, y);
        }

        public static Corner createAfterStartCorner(BorderSegment after, BorderSegment start, double correctionFactor) {
            int width = start.getRadiusStart();
            int height = after.getRadiusEnd();
            if (width == 0 || height == 0) {
                return SQUARE;
            }
            int x = Corner.extentFromRadiusStart(start, correctionFactor);
            int y = Corner.extentFromRadiusEnd(after, correctionFactor);
            return new Corner(x, y, CornerAngles.AFTER_START, 0, -y, -x, -y);
        }

        public static Corner createStartBeforeCorner(BorderSegment start, BorderSegment before, double correctionFactor) {
            int width = start.getRadiusEnd();
            int height = before.getRadiusStart();
            if (width == 0 || height == 0) {
                return SQUARE;
            }
            int x = Corner.extentFromRadiusEnd(start, correctionFactor);
            int y = Corner.extentFromRadiusStart(before, correctionFactor);
            return new Corner(x, y, CornerAngles.START_BEFORE, x, 0, x, -y);
        }
    }

    private static enum CornerAngles {
        BEFORE_END(4.71238898038469, 0.0),
        END_AFTER(0.0, 1.5707963267948966),
        AFTER_START(1.5707963267948966, Math.PI),
        START_BEFORE(Math.PI, 4.71238898038469);

        private final double start;
        private final double end;

        private CornerAngles(double start, double end) {
            this.start = start;
            this.end = end;
        }
    }

    private static abstract class AbstractBorderSegment
    implements BorderSegment {
        private AbstractBorderSegment() {
        }

        private static BorderSegment asBorderSegment(BorderProps borderProps) {
            return borderProps == null ? NullBorderSegment.INSTANCE : new WrappingBorderSegment(borderProps);
        }

        private static BorderSegment asFlippedBorderSegment(BorderProps borderProps) {
            return borderProps == null ? NullBorderSegment.INSTANCE : new FlippedBorderSegment(borderProps);
        }

        @Override
        public boolean isSpecified() {
            return !(this instanceof NullBorderSegment);
        }

        private static final class NullBorderSegment
        extends AbstractBorderSegment {
            public static final NullBorderSegment INSTANCE = new NullBorderSegment();

            private NullBorderSegment() {
            }

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getClippedWidth() {
                return 0;
            }

            @Override
            public int getRadiusStart() {
                return 0;
            }

            @Override
            public int getRadiusEnd() {
                return 0;
            }

            @Override
            public boolean isCollapseOuter() {
                return false;
            }

            @Override
            public Color getColor() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getStyle() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isSpecified() {
                return false;
            }
        }

        private static class FlippedBorderSegment
        extends WrappingBorderSegment {
            FlippedBorderSegment(BorderProps borderProps) {
                super(borderProps);
            }

            @Override
            public int getRadiusStart() {
                return this.borderProps.getRadiusEnd();
            }

            @Override
            public int getRadiusEnd() {
                return this.borderProps.getRadiusStart();
            }
        }

        private static class WrappingBorderSegment
        extends AbstractBorderSegment {
            protected final BorderProps borderProps;
            private final int clippedWidth;

            WrappingBorderSegment(BorderProps borderProps) {
                this.borderProps = borderProps;
                this.clippedWidth = BorderProps.getClippedWidth(borderProps);
            }

            @Override
            public int getStyle() {
                return this.borderProps.style;
            }

            @Override
            public Color getColor() {
                return this.borderProps.color;
            }

            @Override
            public int getWidth() {
                return this.borderProps.width;
            }

            @Override
            public int getClippedWidth() {
                return this.clippedWidth;
            }

            @Override
            public boolean isCollapseOuter() {
                return this.borderProps.isCollapseOuter();
            }

            @Override
            public int getRadiusStart() {
                return this.borderProps.getRadiusStart();
            }

            @Override
            public int getRadiusEnd() {
                return this.borderProps.getRadiusEnd();
            }
        }
    }

    private static interface BorderSegment {
        public Color getColor();

        public int getStyle();

        public int getWidth();

        public int getClippedWidth();

        public int getRadiusStart();

        public int getRadiusEnd();

        public boolean isCollapseOuter();

        public boolean isSpecified();
    }
}

