/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapArrowLink;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArrowLinkView {
    protected MindMapArrowLink arrowLinkModel;
    protected NodeView source;
    protected NodeView target;
    protected int iterativeLevel;
    protected CubicCurve2D arrowLinkCurve;
    static final Stroke DEF_STROKE = new BasicStroke(1.0f);
    private final int MAXIMAL_RECTANGLE_SIZE_FOR_COLLISION_DETECTION = 16;

    protected ArrowLinkView(MindMapArrowLink arrowLinkModel, NodeView source, NodeView target) {
        this.arrowLinkModel = arrowLinkModel;
        this.source = source;
        this.target = target;
    }

    public Rectangle getBounds() {
        if (this.arrowLinkCurve == null) {
            return new Rectangle();
        }
        return this.arrowLinkCurve.getBounds();
    }

    public void paint(Graphics graphics) {
        if (!this.isSourceVisible() && !this.isTargetVisible()) {
            return;
        }
        Point p1 = null;
        Point p2 = null;
        Point p3 = null;
        Point p4 = null;
        boolean targetIsLeft = false;
        boolean sourceIsLeft = false;
        Graphics2D g = (Graphics2D)graphics.create();
        g.setColor(this.getColor());
        g.setStroke(this.getStroke());
        if (!this.isSourceVisible() || !this.isTargetVisible()) {
            g.setStroke(new BasicStroke(this.getWidth(), 1, 1, 0.0f, new float[]{0.0f, 3.0f, 0.0f, 3.0f}, 0.0f));
        }
        if (this.isSourceVisible()) {
            p1 = this.source.getLinkPoint(this.arrowLinkModel.getStartInclination());
            sourceIsLeft = this.source.isLeft();
        }
        if (this.isTargetVisible()) {
            p2 = this.target.getLinkPoint(this.arrowLinkModel.getEndInclination());
            targetIsLeft = this.target.isLeft();
        }
        if (this.arrowLinkModel.getEndInclination() == null || this.arrowLinkModel.getStartInclination() == null) {
            Point incl;
            double dellength;
            double d = dellength = this.isSourceVisible() && this.isTargetVisible() ? p1.distance(p2) / this.getZoom() : 30.0;
            if (this.isSourceVisible() && this.arrowLinkModel.getStartInclination() == null) {
                incl = this.calcInclination(this.source, dellength);
                this.arrowLinkModel.setStartInclination(incl);
                p1 = this.source.getLinkPoint(this.arrowLinkModel.getStartInclination());
            }
            if (this.isTargetVisible() && this.arrowLinkModel.getEndInclination() == null) {
                incl = this.calcInclination(this.target, dellength);
                incl.y = -incl.y;
                this.arrowLinkModel.setEndInclination(incl);
                p2 = this.target.getLinkPoint(this.arrowLinkModel.getEndInclination());
            }
        }
        this.arrowLinkCurve = new CubicCurve2D.Double();
        if (p1 != null) {
            p3 = new Point(p1);
            p3.translate((sourceIsLeft ? -1 : 1) * this.getMap().getZoomed(this.arrowLinkModel.getStartInclination().x), this.getMap().getZoomed(this.arrowLinkModel.getStartInclination().y));
            if (p2 == null) {
                this.arrowLinkCurve.setCurve(p1, p3, p1, p3);
            }
        }
        if (p2 != null) {
            p4 = new Point(p2);
            p4.translate((targetIsLeft ? -1 : 1) * this.getMap().getZoomed(this.arrowLinkModel.getEndInclination().x), this.getMap().getZoomed(this.arrowLinkModel.getEndInclination().y));
            if (p1 == null) {
                this.arrowLinkCurve.setCurve(p2, p4, p2, p4);
            }
        }
        if (p1 != null && p2 != null) {
            this.arrowLinkCurve.setCurve(p1, p3, p4, p2);
            g.draw(this.arrowLinkCurve);
        }
        if (this.isSourceVisible() && !this.arrowLinkModel.getStartArrow().equals("None")) {
            this.paintArrow(p1, p3, g);
        }
        if (this.isTargetVisible() && !this.arrowLinkModel.getEndArrow().equals("None")) {
            this.paintArrow(p2, p4, g);
        }
        if (this.arrowLinkModel.getShowControlPointsFlag() || !this.isSourceVisible() || !this.isTargetVisible()) {
            g.setStroke(new BasicStroke(this.getWidth(), 1, 1, 0.0f, new float[]{0.0f, 3.0f, 0.0f, 3.0f}, 0.0f));
            if (p1 != null) {
                g.drawLine(p1.x, p1.y, p3.x, p3.y);
            }
            if (p2 != null) {
                g.drawLine(p2.x, p2.y, p4.x, p4.y);
            }
        }
    }

    private boolean isTargetVisible() {
        return this.target != null && this.target.isContentVisible();
    }

    private boolean isSourceVisible() {
        return this.source != null && this.source.isContentVisible();
    }

    private Point calcInclination(NodeView node, double dellength) {
        return new Point((int)dellength, 0);
    }

    private void paintArrow(Point p1, Point p3, Graphics2D g) {
        double dx = p3.x - p1.x;
        double dy = p3.y - p1.y;
        double length = Math.sqrt(dx * dx + dy * dy) / (this.getZoom() * 10.0);
        double dxn = dx / length;
        double dyn = dy / length;
        double width = 0.5;
        Polygon p = new Polygon();
        p.addPoint(p1.x, p1.y);
        p.addPoint((int)((double)p1.x + dxn + width * dyn), (int)((double)p1.y + dyn - width * dxn));
        p.addPoint((int)((double)p1.x + dxn - width * dyn), (int)((double)p1.y + dyn + width * dxn));
        p.addPoint(p1.x, p1.y);
        g.fillPolygon(p);
    }

    public boolean detectCollision(Point p) {
        if (this.arrowLinkCurve == null) {
            return false;
        }
        Rectangle2D rec = this.getControlPoint(p);
        FlatteningPathIterator pi = new FlatteningPathIterator(this.arrowLinkCurve.getPathIterator(null), 4.0, 10);
        double oldCoordinateX = 0.0;
        double oldCoordinateY = 0.0;
        while (!pi.isDone()) {
            double[] coordinates = new double[6];
            int type = pi.currentSegment(coordinates);
            switch (type) {
                case 1: {
                    if (rec.intersectsLine(oldCoordinateX, oldCoordinateY, coordinates[0], coordinates[1])) {
                        return true;
                    }
                }
                case 0: {
                    oldCoordinateX = coordinates[0];
                    oldCoordinateY = coordinates[1];
                    break;
                }
            }
            pi.next();
        }
        return false;
    }

    protected Rectangle2D getControlPoint(Point2D p) {
        int side = 16;
        return new Rectangle2D.Double(p.getX() - (double)(side / 2), p.getY() - (double)(side / 2), side, side);
    }

    public Color getColor() {
        return this.getModel().getColor();
    }

    public Stroke getStroke() {
        int width = this.getWidth();
        if (width < 1) {
            return DEF_STROKE;
        }
        return new BasicStroke(width, 0, 0);
    }

    public int getWidth() {
        return this.getModel().getWidth();
    }

    public int getRealWidth() {
        int width = this.getWidth();
        return width < 1 ? 1 : width;
    }

    protected MapView getMap() {
        return this.source == null ? this.target.getMap() : this.source.getMap();
    }

    public MindMapArrowLink getModel() {
        return this.arrowLinkModel;
    }

    protected double getZoom() {
        return this.getMap().getZoom();
    }

    public void changeInclination(int originX, int originY, int newX, int newY) {
    }
}

