/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.api.internal.artifacts.transform.TransformArtifactOperation;
import org.gradle.api.internal.artifacts.transform.TransformFileOperation;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

class TransformingAsyncArtifactListener
implements ResolvedArtifactSet.AsyncArtifactListener {
    private final Map<ResolvableArtifact, TransformArtifactOperation> artifactResults;
    private final Map<File, TransformFileOperation> fileResults;
    private final BuildOperationQueue<RunnableBuildOperation> actions;
    private final ResolvedArtifactSet.AsyncArtifactListener delegate;
    private final ArtifactTransformer transform;

    TransformingAsyncArtifactListener(ArtifactTransformer transform, ResolvedArtifactSet.AsyncArtifactListener delegate, BuildOperationQueue<RunnableBuildOperation> actions, Map<ResolvableArtifact, TransformArtifactOperation> artifactResults, Map<File, TransformFileOperation> fileResults) {
        this.artifactResults = artifactResults;
        this.actions = actions;
        this.transform = transform;
        this.delegate = delegate;
        this.fileResults = fileResults;
    }

    @Override
    public void artifactAvailable(ResolvableArtifact artifact) {
        TransformArtifactOperation operation = new TransformArtifactOperation(artifact, this.transform);
        this.artifactResults.put(artifact, operation);
        if (this.transform.hasCachedResult(artifact.getFile())) {
            operation.run(null);
        } else {
            this.actions.add((BuildOperation)operation);
        }
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    @Override
    public boolean includeFileDependencies() {
        return this.delegate.includeFileDependencies();
    }

    @Override
    public void fileAvailable(File file) {
        TransformFileOperation operation = new TransformFileOperation(file, this.transform);
        this.fileResults.put(file, operation);
        if (this.transform.hasCachedResult(file)) {
            operation.run(null);
        } else {
            this.actions.add((BuildOperation)operation);
        }
    }
}

