/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;
import org.gradle.api.publish.maven.internal.artifact.DerivedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.SingleOutputTaskMavenArtifact;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class DefaultMavenPublication
implements MavenPublicationInternal {
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private static final Comparator<? super UsageContext> USAGE_ORDERING = new Comparator<UsageContext>(){

        @Override
        public int compare(UsageContext left, UsageContext right) {
            if (left.getUsage().getName().equals("java-api")) {
                return -1;
            }
            if (right.getUsage().getName().equals("java-api")) {
                return 1;
            }
            return left.getUsage().getName().compareTo(right.getUsage().getName());
        }
    };
    private final String name;
    private final MavenPomInternal pom;
    private final MutableMavenProjectIdentity projectIdentity;
    private final DefaultMavenArtifactSet mainArtifacts;
    private final PublicationArtifactSet<MavenArtifact> metadataArtifacts;
    private final PublicationArtifactSet<MavenArtifact> derivedArtifacts;
    private final PublicationArtifactSet<MavenArtifact> publishableArtifacts;
    private final Set<MavenDependencyInternal> runtimeDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependencyInternal> apiDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependency> runtimeDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final Set<MavenDependency> apiDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FeaturePreviews featurePreviews;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private MavenArtifact pomArtifact;
    private MavenArtifact moduleMetadataArtifact;
    private Task moduleDescriptorGenerator;
    private SoftwareComponentInternal component;
    private boolean isPublishWithOriginalFileName;
    private boolean alias;
    private boolean populated;
    private boolean artifactsOverridden;

    public DefaultMavenPublication(String name, MutableMavenProjectIdentity projectIdentity, NotationParser<Object, MavenArtifact> mavenArtifactParser, Instantiator instantiator, ObjectFactory objectFactory, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, FeaturePreviews featurePreviews, ImmutableAttributesFactory immutableAttributesFactory) {
        this.name = name;
        this.projectDependencyResolver = projectDependencyResolver;
        this.projectIdentity = projectIdentity;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.mainArtifacts = (DefaultMavenArtifactSet)instantiator.newInstance(DefaultMavenArtifactSet.class, new Object[]{name, mavenArtifactParser, fileCollectionFactory});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "metadata artifacts for " + name, fileCollectionFactory);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "derived artifacts for " + name, fileCollectionFactory);
        this.publishableArtifacts = new CompositePublicationArtifactSet(MavenArtifact.class, new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts});
        this.pom = (MavenPomInternal)instantiator.newInstance(DefaultMavenPom.class, new Object[]{this, instantiator, objectFactory});
        this.featurePreviews = featurePreviews;
    }

    public String getName() {
        return this.name;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((String)"Maven publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public MavenPomInternal getPom() {
        return this.pom;
    }

    @Override
    public void setPomGenerator(Task pomGenerator) {
        if (this.pomArtifact != null) {
            this.metadataArtifacts.remove((Object)this.pomArtifact);
        }
        this.pomArtifact = new SingleOutputTaskMavenArtifact(pomGenerator, "pom", null);
        this.metadataArtifacts.add((Object)this.pomArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(Task descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.moduleMetadataArtifact != null) {
            this.metadataArtifacts.remove((Object)this.moduleMetadataArtifact);
        }
        this.moduleMetadataArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.moduleMetadataArtifact = new SingleOutputTaskMavenArtifact(this.moduleDescriptorGenerator, "module", null);
        this.metadataArtifacts.add((Object)this.moduleMetadataArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void pom(Action<? super MavenPom> configure) {
        configure.execute((Object)this.pom);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Maven publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (this.component == null) {
            return;
        }
        HashSet seenArtifacts = Sets.newHashSet();
        HashSet seenDependencies = Sets.newHashSet();
        HashSet seenConstraints = Sets.newHashSet();
        for (UsageContext usageContext : this.getSortedUsageContexts()) {
            for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                ArtifactKey key = new ArtifactKey(publishArtifact.getFile(), publishArtifact.getClassifier(), publishArtifact.getExtension());
                if (this.artifactsOverridden || !seenArtifacts.add(key)) continue;
                this.artifact(publishArtifact);
            }
            Set globalExcludes = usageContext.getGlobalExcludes();
            Set<MavenDependencyInternal> dependencies = this.dependenciesFor(usageContext.getUsage());
            for (ModuleDependency dependency : usageContext.getDependencies()) {
                if (!seenDependencies.add(dependency)) continue;
                if (dependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)dependency, globalExcludes, dependencies);
                    continue;
                }
                this.addModuleDependency(dependency, globalExcludes, dependencies);
            }
            Set<MavenDependency> dependencyConstraints = this.dependencyConstraintsFor(usageContext.getUsage());
            for (DependencyConstraint dependency : usageContext.getDependencyConstraints()) {
                if (!seenConstraints.add(dependency) || dependency.getVersionConstraint().getPreferredVersion().isEmpty()) continue;
                this.addDependencyConstraint(dependency, dependencyConstraints);
            }
        }
    }

    private List<UsageContext> getSortedUsageContexts() {
        ArrayList usageContexts = Lists.newArrayList((Iterable)this.component.getUsages());
        Collections.sort(usageContexts, USAGE_ORDERING);
        return usageContexts;
    }

    private Set<MavenDependencyInternal> dependenciesFor(Usage usage) {
        if ("java-api".equals(usage.getName())) {
            return this.apiDependencies;
        }
        return this.runtimeDependencies;
    }

    private Set<MavenDependency> dependencyConstraintsFor(Usage usage) {
        if ("java-api".equals(usage.getName())) {
            return this.apiDependencyConstraints;
        }
        return this.runtimeDependencyConstraints;
    }

    private void addProjectDependency(ProjectDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
        ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
        dependencies.add(new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), Collections.emptyList(), DefaultMavenPublication.getExcludeRules(globalExcludes, (ModuleDependency)dependency)));
    }

    private void addModuleDependency(ModuleDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
        dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), dependency.getArtifacts(), DefaultMavenPublication.getExcludeRules(globalExcludes, dependency)));
    }

    private void addDependencyConstraint(DependencyConstraint dependency, Set<MavenDependency> dependencies) {
        dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion()));
    }

    private static Set<ExcludeRule> getExcludeRules(Set<ExcludeRule> globalExcludes, ModuleDependency dependency) {
        return dependency.isTransitive() ? Sets.union(globalExcludes, (Set)dependency.getExcludeRules()) : EXCLUDE_ALL_RULE;
    }

    @Override
    public MavenArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public MavenArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public String getGroupId() {
        return (String)this.projectIdentity.getGroupId().get();
    }

    @Override
    public void setGroupId(String groupId) {
        this.projectIdentity.getGroupId().set((Object)groupId);
    }

    @Override
    public String getArtifactId() {
        return (String)this.projectIdentity.getArtifactId().get();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.projectIdentity.getArtifactId().set((Object)artifactId);
    }

    @Override
    public String getVersion() {
        return (String)this.projectIdentity.getVersion().get();
    }

    @Override
    public void setVersion(String version) {
        this.projectIdentity.getVersion().set((Object)version);
    }

    @Override
    public FileCollection getPublishableFiles() {
        return this.getPublishableArtifacts().getFiles();
    }

    public PublicationArtifactSet<MavenArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public MavenArtifact addDerivedArtifact(MavenArtifact originalArtifact, Factory<File> file) {
        DerivedMavenArtifact artifact = new DerivedMavenArtifact(originalArtifact, file);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(MavenArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public MutableMavenProjectIdentity getMavenProjectIdentity() {
        return this.projectIdentity;
    }

    @Override
    public Set<MavenDependency> getApiDependencyConstraints() {
        this.populateFromComponent();
        return this.apiDependencyConstraints;
    }

    @Override
    public Set<MavenDependency> getRuntimeDependencyConstraints() {
        this.populateFromComponent();
        return this.runtimeDependencyConstraints;
    }

    @Override
    public Set<MavenDependencyInternal> getRuntimeDependencies() {
        this.populateFromComponent();
        return this.runtimeDependencies;
    }

    @Override
    public Set<MavenDependencyInternal> getApiDependencies() {
        this.populateFromComponent();
        return this.apiDependencies;
    }

    @Override
    public MavenNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        DomainObjectSet existingDerivedArtifacts = this.derivedArtifacts.matching((Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact artifact) {
                return artifact.getFile().exists();
            }
        });
        CompositeDomainObjectSet artifactsToBePublished = CompositeDomainObjectSet.create(MavenArtifact.class, (DomainObjectCollection[])new DomainObjectCollection[]{this.mainArtifacts, this.metadataArtifacts, existingDerivedArtifacts});
        return new MavenNormalizedPublication(this.name, this.pom.getPackaging(), this.getPomArtifact(), this.projectIdentity, (Set<MavenArtifact>)artifactsToBePublished, this.determineMainArtifact());
    }

    private MavenArtifact getPomArtifact() {
        if (this.pomArtifact == null) {
            throw new IllegalStateException("pomArtifact not set for publication");
        }
        return this.pomArtifact;
    }

    @Override
    public String determinePackagingFromArtifacts() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next().getExtension();
        }
        return "pom";
    }

    private MavenArtifact determineMainArtifact() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.isEmpty()) {
            return null;
        }
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next();
        }
        for (MavenArtifact unclassifiedArtifact : unclassifiedArtifacts) {
            String packaging = this.pom.getPackaging();
            if (!unclassifiedArtifact.getExtension().equals(packaging)) continue;
            return unclassifiedArtifact;
        }
        return null;
    }

    private Set<MavenArtifact> getUnclassifiedArtifactsWithExtension() {
        this.populateFromComponent();
        return CollectionUtils.filter((Set)((Object)this.mainArtifacts), (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact mavenArtifact) {
                return DefaultMavenPublication.this.hasNoClassifier(mavenArtifact) && DefaultMavenPublication.this.hasExtension(mavenArtifact);
            }
        });
    }

    private boolean hasNoClassifier(MavenArtifact element) {
        return element.getClassifier() == null || element.getClassifier().length() == 0;
    }

    private boolean hasExtension(MavenArtifact element) {
        return element.getExtension() != null && element.getExtension().length() > 0;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return new DefaultModuleVersionIdentifier(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    @Override
    public void publishWithOriginalFileName() {
        this.isPublishWithOriginalFileName = true;
    }

    private boolean canPublishModuleMetadata() {
        if (this.getComponent() == null) {
            return false;
        }
        if (this.getComponent() instanceof ComponentWithVariants) {
            return true;
        }
        return this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA);
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        this.checkThatArtifactIsPublishedUnmodified(source);
        final String publishedUrl = this.getPublishedUrl(source);
        final String publishedName = this.isPublishWithOriginalFileName ? source.getFile().getName() : publishedUrl;
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedName;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Nullable
    public ImmutableAttributes getAttributes() {
        String version = (String)this.getMavenProjectIdentity().getVersion().get();
        String status = MavenVersionUtils.inferStatusFromVersionNumber((String)version);
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
    }

    private void checkThatArtifactIsPublishedUnmodified(PublishArtifact source) {
        this.populateFromComponent();
        Iterator i$ = this.mainArtifacts.iterator();
        while (i$.hasNext()) {
            MavenArtifact mavenArtifact = (MavenArtifact)i$.next();
            if (!source.getFile().equals(mavenArtifact.getFile()) || !source.getExtension().equals(mavenArtifact.getExtension()) || !Strings.nullToEmpty((String)source.getClassifier()).equals(Strings.nullToEmpty((String)mavenArtifact.getClassifier()))) continue;
            return;
        }
        throw new PublishException("Cannot publish module metadata where component artifacts are modified.");
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    private static class ArtifactKey {
        final File file;
        final String classifier;
        final String extension;

        public ArtifactKey(File file, String classifier, String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public boolean equals(Object obj) {
            ArtifactKey other = (ArtifactKey)obj;
            return this.file.equals(other.file) && Objects.equal((Object)this.classifier, (Object)other.classifier) && Objects.equal((Object)this.extension, (Object)other.extension);
        }

        public int hashCode() {
            return this.file.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.classifier, this.extension});
        }
    }
}

