/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.meta;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataCache;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.filters.position.PatternFilter;
import org.jetbrains.kotlin.com.intellij.psi.meta.MetaDataContributor;
import org.jetbrains.kotlin.com.intellij.psi.meta.MetaDataRegistrar;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class MetaRegistry
extends MetaDataRegistrar {
    private static final Logger LOG = Logger.getInstance(MetaRegistry.class);
    private static final List<MyBinding> ourBindings = ContainerUtil.createLockFreeCopyOnWriteList();
    private static volatile boolean ourContributorsLoaded;
    private static final Key<CachedValue<PsiMetaData>> META_DATA_KEY;
    private static final UserDataCache<CachedValue<PsiMetaData>, PsiElement, Object> ourCachedMetaCache;

    public static void bindDataToElement(PsiElement element, PsiMetaData data) {
        CachedValue value = CachedValuesManager.getManager(element.getProject()).createCachedValue(() -> {
            data.init(element);
            return new CachedValueProvider.Result<PsiMetaData>(data, data.getDependences());
        });
        element.putUserData(META_DATA_KEY, value);
    }

    public static PsiMetaData getMeta(PsiElement element) {
        PsiMetaData base = MetaRegistry.getMetaBase(element);
        return base != null ? base : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureContributorsLoaded() {
        if (!ourContributorsLoaded) {
            List<MyBinding> list2 = ourBindings;
            synchronized (list2) {
                if (!ourContributorsLoaded) {
                    for (MetaDataContributor contributor : Extensions.getExtensions(MetaDataContributor.EP_NAME)) {
                        contributor.contributeMetaData(MetaDataRegistrar.getInstance());
                    }
                    ourContributorsLoaded = true;
                }
            }
        }
    }

    @Nullable
    public static PsiMetaData getMetaBase(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        return ourCachedMetaCache.get(META_DATA_KEY, element, (Object)null).getValue();
    }

    public static <T extends PsiMetaData> void addMetadataBinding(ElementFilter filter2, Class<T> aMetadataClass, Disposable parentDisposable) {
        final MyBinding binding = new MyBinding(filter2, aMetadataClass);
        MetaRegistry.addBinding(binding);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ourBindings.remove(binding);
            }
        });
    }

    public static <T extends PsiMetaData> void addMetadataBinding(ElementFilter filter2, Class<T> aMetadataClass) {
        MetaRegistry.addBinding(new MyBinding(filter2, aMetadataClass));
    }

    private static void addBinding(MyBinding binding) {
        ourBindings.add(0, binding);
    }

    @Override
    public <T extends PsiMetaData> void registerMetaData(ElementFilter filter2, Class<T> metadataDescriptorClass) {
        MetaRegistry.addMetadataBinding(filter2, metadataDescriptorClass);
    }

    @Override
    public <T extends PsiMetaData> void registerMetaData(ElementPattern<?> pattern, Class<T> metadataDescriptorClass) {
        MetaRegistry.addMetadataBinding(new PatternFilter(pattern), metadataDescriptorClass);
    }

    static {
        META_DATA_KEY = Key.create("META DATA KEY");
        ourCachedMetaCache = new UserDataCache<CachedValue<PsiMetaData>, PsiElement, Object>(){

            @Override
            protected CachedValue<PsiMetaData> compute(PsiElement element, Object p) {
                return CachedValuesManager.getManager(element.getProject()).createCachedValue(() -> {
                    MetaRegistry.ensureContributorsLoaded();
                    for (MyBinding binding : ourBindings) {
                        Object[] dependences;
                        PsiMetaData data;
                        if (!binding.myFilter.isClassAcceptable(element.getClass()) || !binding.myFilter.isAcceptable(element, element.getParent())) continue;
                        try {
                            data = (PsiMetaData)binding.myDataClass.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException("failed to instantiate " + binding.myDataClass, e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("failed to instantiate " + binding.myDataClass, e);
                        }
                        data.init(element);
                        for (Object dependence : dependences = data.getDependences()) {
                            if (dependence != null) continue;
                            LOG.error(data + "(" + binding.myDataClass + ") provided null dependency");
                        }
                        return new CachedValueProvider.Result<PsiMetaData>(data, ArrayUtil.append(dependences, element));
                    }
                    return new CachedValueProvider.Result<Object>(null, element);
                }, false);
            }
        };
    }

    private static class MyBinding {
        private final ElementFilter myFilter;
        private final Class<? extends PsiMetaData> myDataClass;

        public MyBinding(@NotNull ElementFilter filter2, @NotNull Class<? extends PsiMetaData> dataClass) {
            if (filter2 == null) {
                MyBinding.$$$reportNull$$$0(0);
            }
            if (dataClass == null) {
                MyBinding.$$$reportNull$$$0(1);
            }
            this.myFilter = filter2;
            this.myDataClass = dataClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataClass";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/meta/MetaRegistry$MyBinding";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

