/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskState;
import org.gradle.execution.TaskExecutionGraphInternal;
import org.gradle.execution.taskgraph.DefaultTaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskExecutionGraph
implements TaskExecutionGraphInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskExecutionGraph.class);
    private final TaskPlanExecutor taskPlanExecutor;
    private final ResourceLockCoordinationService coordinationService;
    private final Factory<? extends TaskExecuter> taskExecuter;
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final DefaultTaskExecutionPlan taskExecutionPlan;
    private final BuildOperationExecutor buildOperationExecutor;
    private TaskGraphState taskGraphState = TaskGraphState.EMPTY;
    private List<Task> allTasks;
    private final Set<Task> requestedTasks = Sets.newTreeSet();
    private Spec<? super Task> filter = Specs.SATISFIES_ALL;

    public DefaultTaskExecutionGraph(ListenerManager listenerManager, TaskPlanExecutor taskPlanExecutor, Factory<? extends TaskExecuter> taskExecuter, BuildOperationExecutor buildOperationExecutor, WorkerLeaseService workerLeaseService, ResourceLockCoordinationService coordinationService, GradleInternal gradleInternal) {
        this.taskPlanExecutor = taskPlanExecutor;
        this.taskExecuter = taskExecuter;
        this.buildOperationExecutor = buildOperationExecutor;
        this.coordinationService = coordinationService;
        this.graphListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionGraphListener.class);
        this.taskListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionListener.class);
        this.taskExecutionPlan = new DefaultTaskExecutionPlan(workerLeaseService, gradleInternal);
    }

    @Override
    public void setContinueOnFailure(boolean continueOnFailure) {
        this.taskExecutionPlan.setContinueOnFailure(continueOnFailure);
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        this.filter = (Spec)Cast.uncheckedCast((Object)(filter != null ? filter : Specs.SATISFIES_ALL));
        this.taskExecutionPlan.useFilter(this.filter);
        this.taskGraphState = TaskGraphState.DIRTY;
    }

    @Override
    public void addTasks(Iterable<? extends Task> tasks) {
        assert (tasks != null);
        Timer clock = Time.startTimer();
        LinkedHashSet<Task> taskSet = new LinkedHashSet<Task>();
        for (Task task : tasks) {
            taskSet.add(task);
            this.requestedTasks.add(task);
        }
        this.taskExecutionPlan.addToTaskGraph(taskSet);
        this.taskGraphState = TaskGraphState.DIRTY;
        LOGGER.debug("Timing: Creating the DAG took " + clock.getElapsed());
    }

    @Override
    public void populate() {
        this.ensurePopulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Timer clock = Time.startTimer();
        this.ensurePopulated();
        ((TaskExecutionGraphListener)this.graphListeners.getSource()).graphPopulated((TaskExecutionGraph)this);
        try {
            this.taskPlanExecutor.process(this.taskExecutionPlan, new ExecuteTaskAction((TaskExecuter)this.taskExecuter.create(), this.buildOperationExecutor.getCurrentOperation()));
            LOGGER.debug("Timing: Executing the DAG took " + clock.getElapsed());
        }
        catch (Throwable throwable) {
            this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    DefaultTaskExecutionGraph.this.taskExecutionPlan.clear();
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            throw throwable;
        }
        this.coordinationService.withStateLock((Transformer)new /* invalid duplicate definition of identical inner class */);
    }

    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add((Object)listener);
    }

    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove((Object)listener);
    }

    public void whenReady(Closure closure) {
        this.graphListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("graphPopulated", closure));
    }

    public void whenReady(final Action<TaskExecutionGraph> action) {
        this.graphListeners.add((Object)new TaskExecutionGraphListener(){

            public void graphPopulated(TaskExecutionGraph graph) {
                action.execute((Object)graph);
            }
        });
    }

    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.add((Object)listener);
    }

    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove((Object)listener);
    }

    public void beforeTask(Closure closure) {
        this.taskListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeExecute", closure));
    }

    public void beforeTask(final Action<Task> action) {
        this.taskListeners.add((Object)new TaskExecutionAdapter(){

            public void beforeExecute(Task task) {
                action.execute((Object)task);
            }
        });
    }

    public void afterTask(Closure closure) {
        this.taskListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterExecute", closure));
    }

    public void afterTask(final Action<Task> action) {
        this.taskListeners.add((Object)new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                action.execute((Object)task);
            }
        });
    }

    public boolean hasTask(Task task) {
        this.ensurePopulated();
        return this.taskExecutionPlan.getTasks().contains(task);
    }

    public boolean hasTask(String path) {
        this.ensurePopulated();
        assert (path != null && path.length() > 0);
        for (Task task : this.taskExecutionPlan.getTasks()) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    public List<Task> getAllTasks() {
        this.ensurePopulated();
        if (this.allTasks == null) {
            this.allTasks = ImmutableList.copyOf(this.taskExecutionPlan.getTasks());
        }
        return this.allTasks;
    }

    public Set<Task> getDependencies(Task task) {
        this.ensurePopulated();
        return this.taskExecutionPlan.getDependencies(task);
    }

    private void ensurePopulated() {
        switch (this.taskGraphState) {
            case EMPTY: {
                throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
            }
            case DIRTY: {
                this.taskExecutionPlan.determineExecutionPlan();
                this.allTasks = null;
                this.taskGraphState = TaskGraphState.POPULATED;
                return;
            }
        }
    }

    @Override
    public Set<Task> getRequestedTasks() {
        return this.requestedTasks;
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.taskExecutionPlan.getFilteredTasks();
    }

    @Override
    public TaskExecutionListener getTaskExecutionListenerSource() {
        return (TaskExecutionListener)this.taskListeners.getSource();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecuteTaskAction
    implements Action<TaskInternal> {
        private final TaskExecuter taskExecuter;
        private final BuildOperationRef parentOperation;

        ExecuteTaskAction(TaskExecuter taskExecuter, BuildOperationRef parentOperation) {
            this.taskExecuter = taskExecuter;
            this.parentOperation = parentOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(TaskInternal task) {
            BuildOperationRef previous = CurrentBuildOperationRef.instance().get();
            CurrentBuildOperationRef.instance().set(this.parentOperation);
            try {
                TaskStateInternal state = task.getState();
                DefaultTaskExecutionContext ctx = new DefaultTaskExecutionContext();
                this.taskExecuter.execute(task, state, ctx);
            }
            finally {
                CurrentBuildOperationRef.instance().set(previous);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskGraphState {
        EMPTY,
        DIRTY,
        POPULATED;

    }
}

