/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.JvmOptions;
import org.gradle.process.internal.util.MergeOptionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaForkOptions
extends DefaultProcessForkOptions
implements JavaForkOptionsInternal {
    private final FileResolver resolver;
    private final JvmOptions options;
    private List<CommandLineArgumentProvider> jvmArgumentProviders;

    public DefaultJavaForkOptions(FileResolver resolver) {
        this(resolver, Jvm.current());
    }

    public DefaultJavaForkOptions(FileResolver resolver, Jvm jvm) {
        super(resolver);
        this.resolver = resolver;
        this.options = new JvmOptions(resolver);
        this.setExecutable(jvm.getJavaExecutable());
    }

    public List<String> getAllJvmArgs() {
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this)) {
            JvmOptions copy = this.options.createCopy();
            for (CommandLineArgumentProvider jvmArgumentProvider : this.jvmArgumentProviders) {
                copy.jvmArgs(jvmArgumentProvider.asArguments());
            }
            return copy.getAllJvmArgs();
        }
        return this.options.getAllJvmArgs();
    }

    public void setAllJvmArgs(List<String> arguments) {
        this.options.setAllJvmArgs(arguments);
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this)) {
            this.jvmArgumentProviders.clear();
        }
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.options.setAllJvmArgs(arguments);
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this)) {
            this.jvmArgumentProviders.clear();
        }
    }

    public List<String> getJvmArgs() {
        return this.options.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.options.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.options.setJvmArgs(arguments);
    }

    public JavaForkOptions jvmArgs(Iterable<?> arguments) {
        this.options.jvmArgs(arguments);
        return this;
    }

    public JavaForkOptions jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
        return this;
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        if (this.jvmArgumentProviders == null) {
            this.jvmArgumentProviders = new ArrayList<CommandLineArgumentProvider>();
        }
        return this.jvmArgumentProviders;
    }

    public Map<String, Object> getSystemProperties() {
        return this.options.getMutableSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.options.setSystemProperties(properties);
    }

    public JavaForkOptions systemProperties(Map<String, ?> properties) {
        this.options.systemProperties(properties);
        return this;
    }

    public JavaForkOptions systemProperty(String name, Object value) {
        this.options.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.options.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.options.setBootstrapClasspath(classpath);
    }

    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.options.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.options.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.options.setMinHeapSize(heapSize);
    }

    public String getMaxHeapSize() {
        return this.options.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.options.setMaxHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.options.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.options.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public boolean getEnableAssertions() {
        return this.options.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.options.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.options.getDebug();
    }

    public void setDebug(boolean enabled) {
        this.options.setDebug(enabled);
    }

    public JavaForkOptions copyTo(JavaForkOptions target) {
        super.copyTo((ProcessForkOptions)target);
        this.options.copyTo(target);
        if (this.jvmArgumentProviders != null) {
            for (CommandLineArgumentProvider jvmArgumentProvider : this.jvmArgumentProviders) {
                target.jvmArgs(jvmArgumentProvider.asArguments());
            }
        }
        return this;
    }

    @Override
    public JavaForkOptionsInternal mergeWith(JavaForkOptions options) {
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this) || DefaultJavaForkOptions.hasJvmArgumentProviders(options)) {
            throw new UnsupportedOperationException("Cannot merge options with jvmArgumentProviders.");
        }
        DefaultJavaForkOptions mergedOptions = new DefaultJavaForkOptions(this.resolver);
        if (!MergeOptionsUtil.canBeMerged(this.getExecutable(), options.getExecutable())) {
            throw new IllegalArgumentException("Cannot merge a fork options object with a different executable (this: " + this.getExecutable() + ", other: " + options.getExecutable() + ").");
        }
        mergedOptions.setExecutable(this.getExecutable() != null ? this.getExecutable() : options.getExecutable());
        if (!MergeOptionsUtil.canBeMerged(this.getWorkingDir(), options.getWorkingDir())) {
            throw new IllegalArgumentException("Cannot merge a fork options object with a different working directory (this: " + this.getWorkingDir() + ", other: " + options.getWorkingDir() + ").");
        }
        mergedOptions.setWorkingDir(this.getWorkingDir() != null ? this.getWorkingDir() : options.getWorkingDir());
        if (!MergeOptionsUtil.canBeMerged(this.getDefaultCharacterEncoding(), options.getDefaultCharacterEncoding())) {
            throw new IllegalArgumentException("Cannot merge a fork options object with a different default character encoding (this: " + this.getDefaultCharacterEncoding() + ", other: " + options.getDefaultCharacterEncoding() + ").");
        }
        mergedOptions.setDefaultCharacterEncoding(this.getDefaultCharacterEncoding() != null ? this.getDefaultCharacterEncoding() : options.getDefaultCharacterEncoding());
        mergedOptions.setDebug(this.getDebug() || options.getDebug());
        mergedOptions.setEnableAssertions(this.getEnableAssertions() || options.getEnableAssertions());
        mergedOptions.setMinHeapSize(MergeOptionsUtil.mergeHeapSize(this.getMinHeapSize(), options.getMinHeapSize()));
        mergedOptions.setMaxHeapSize(MergeOptionsUtil.mergeHeapSize(this.getMaxHeapSize(), options.getMaxHeapSize()));
        Set<String> mergedJvmArgs = MergeOptionsUtil.normalized(this.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(options.getJvmArgs()));
        mergedOptions.setJvmArgs(mergedJvmArgs);
        HashMap mergedEnvironment = Maps.newHashMap(this.getEnvironment());
        mergedEnvironment.putAll(options.getEnvironment());
        mergedOptions.setEnvironment(mergedEnvironment);
        HashMap mergedSystemProperties = Maps.newHashMap(this.getSystemProperties());
        mergedSystemProperties.putAll(options.getSystemProperties());
        mergedOptions.setSystemProperties(mergedSystemProperties);
        mergedOptions.setBootstrapClasspath(new UnionFileCollection(this.getBootstrapClasspath(), options.getBootstrapClasspath()));
        return mergedOptions;
    }

    @Override
    public boolean isCompatibleWith(JavaForkOptions options) {
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this) || DefaultJavaForkOptions.hasJvmArgumentProviders(options)) {
            throw new UnsupportedOperationException("Cannot compare options with jvmArgumentProviders.");
        }
        return this.getDebug() == options.getDebug() && this.getEnableAssertions() == options.getEnableAssertions() && MergeOptionsUtil.normalized(this.getExecutable()).equals(MergeOptionsUtil.normalized(options.getExecutable())) && this.getWorkingDir().equals(options.getWorkingDir()) && MergeOptionsUtil.normalized(this.getDefaultCharacterEncoding()).equals(MergeOptionsUtil.normalized(options.getDefaultCharacterEncoding())) && MergeOptionsUtil.getHeapSizeMb(this.getMinHeapSize()) >= MergeOptionsUtil.getHeapSizeMb(options.getMinHeapSize()) && MergeOptionsUtil.getHeapSizeMb(this.getMaxHeapSize()) >= MergeOptionsUtil.getHeapSizeMb(options.getMaxHeapSize()) && MergeOptionsUtil.normalized(this.getJvmArgs()).containsAll(MergeOptionsUtil.normalized(options.getJvmArgs())) && MergeOptionsUtil.containsAll(this.getSystemProperties(), options.getSystemProperties()) && MergeOptionsUtil.containsAll(this.getEnvironment(), options.getEnvironment()) && this.getBootstrapClasspath().getFiles().containsAll(options.getBootstrapClasspath().getFiles());
    }

    private static boolean hasJvmArgumentProviders(JavaForkOptions forkOptions) {
        return forkOptions instanceof DefaultJavaForkOptions && DefaultJavaForkOptions.hasJvmArgumentProviders((DefaultJavaForkOptions)forkOptions);
    }

    private static boolean hasJvmArgumentProviders(DefaultJavaForkOptions forkOptions) {
        return forkOptions.jvmArgumentProviders != null && !forkOptions.jvmArgumentProviders.isEmpty();
    }
}

