/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import org.gradle.api.internal.tasks.testing.JULRedirector;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.TestSuiteExecutionException;
import org.gradle.api.internal.tasks.testing.processors.CaptureTestOutputTestResultProcessor;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.time.Clock;

public class SuiteTestClassProcessor
implements TestClassProcessor {
    private final TestClassProcessor processor;
    private final Clock clock;
    private final TestDescriptorInternal suiteDescriptor;
    private TestResultProcessor resultProcessor;

    public SuiteTestClassProcessor(TestDescriptorInternal suiteDescriptor, TestClassProcessor processor, Clock clock) {
        this.suiteDescriptor = suiteDescriptor;
        this.processor = processor;
        this.clock = clock;
    }

    @Override
    public void startProcessing(TestResultProcessor testResultProcessor) {
        try {
            this.resultProcessor = new AttachParentTestResultProcessor(new CaptureTestOutputTestResultProcessor(testResultProcessor, new JULRedirector()));
            this.resultProcessor.started(this.suiteDescriptor, new TestStartEvent(this.clock.getCurrentTime()));
            this.processor.startProcessing(this.resultProcessor);
        }
        catch (Throwable t) {
            this.resultProcessor.failure(this.suiteDescriptor.getId(), (Throwable)((Object)new TestSuiteExecutionException(String.format("Could not start %s.", this.suiteDescriptor), t)));
        }
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        try {
            this.processor.processTestClass(testClass);
        }
        catch (Throwable t) {
            this.resultProcessor.failure(this.suiteDescriptor.getId(), (Throwable)((Object)new TestSuiteExecutionException(String.format("Could not execute test class '%s'.", testClass.getTestClassName()), t)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.processor.stop();
        }
        catch (Throwable t) {
            this.resultProcessor.failure(this.suiteDescriptor.getId(), (Throwable)((Object)new TestSuiteExecutionException(String.format("Could not complete execution for %s.", this.suiteDescriptor), t)));
        }
        finally {
            this.resultProcessor.completed(this.suiteDescriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    @Override
    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }
}

