/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.hub.ConnectionSet;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.remote.internal.hub.queue.EndPointQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionState {
    private boolean receiveFinished;
    private boolean dispatchFinished;
    private final RemoteConnection<InterHubMessage> connection;
    private final ConnectionSet owner;
    private final EndPointQueue dispatchQueue;

    ConnectionState(ConnectionSet owner, RemoteConnection<InterHubMessage> connection, EndPointQueue dispatchQueue) {
        this.owner = owner;
        this.connection = connection;
        this.dispatchQueue = dispatchQueue;
    }

    public RemoteConnection<InterHubMessage> getConnection() {
        return this.connection;
    }

    public EndPointQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void receiveFinished() {
        this.receiveFinished = true;
        if (!this.dispatchFinished) {
            this.dispatchQueue.stop();
        }
        this.maybeDisconnected();
    }

    public void dispatchFinished() {
        this.dispatchFinished = true;
        this.maybeDisconnected();
    }

    private void maybeDisconnected() {
        if (this.dispatchFinished && this.receiveFinished) {
            this.owner.finished(this);
        }
    }
}

