/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;

public final class BCSNIHostName
extends BCSNIServerName {
    private final String hostName;

    public static BCSNIMatcher createSNIMatcher(String string) {
        if (string == null) {
            throw new NullPointerException("'regex' cannot be null");
        }
        return new BCSNIHostNameMatcher(string);
    }

    private static String fromAscii(byte[] byArray) {
        try {
            return new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static byte[] toAscii(String string) {
        try {
            return string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public BCSNIHostName(String string) {
        super(0, BCSNIHostName.toAscii(string));
        this.hostName = string;
    }

    public BCSNIHostName(byte[] byArray) {
        super(0, byArray);
        this.hostName = BCSNIHostName.fromAscii(byArray);
    }

    public String getAsciiName() {
        return this.hostName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BCSNIHostName)) {
            return false;
        }
        BCSNIHostName bCSNIHostName = (BCSNIHostName)object;
        return this.hostName.equalsIgnoreCase(bCSNIHostName.hostName);
    }

    public int hashCode() {
        return this.hostName.toUpperCase(Locale.ENGLISH).hashCode();
    }

    private static final class BCSNIHostNameMatcher
    extends BCSNIMatcher {
        private final Pattern pattern;

        BCSNIHostNameMatcher(String string) {
            super(0);
            this.pattern = Pattern.compile(string, 2);
        }

        public boolean matches(BCSNIServerName bCSNIServerName) {
            if (bCSNIServerName == null || bCSNIServerName.getType() != 0) {
                return false;
            }
            String string = BCSNIHostName.fromAscii(bCSNIServerName.getEncoded());
            return this.pattern.matcher(string).matches();
        }
    }
}

