/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;

    @Override
    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId) {
        if (runnable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(1);
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(3);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(4);
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, null);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(5);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(6);
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, true, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(9);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(10);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            CommandLog.LOG.error("Project " + project + " already disposed");
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(project, this.myCurrentCommand, throwable);
        }
    }

    public void finishCommand(Project project, Object command, Throwable throwable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, "no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        try {
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.beforeCommandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
        finally {
            this.myCurrentCommand = null;
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.commandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
    }

    @Override
    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Override
    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        for (CommandListener listener : this.myListeners) {
            try {
                listener.commandStarted(event);
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommandListener";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCommandListener";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "runUndoTransparentAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandDescriptor {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;
        public final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command, Project project, String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
            if (command == null) {
                CommandDescriptor.$$$reportNull$$$0(0);
            }
            if (undoConfirmationPolicy == null) {
                CommandDescriptor.$$$reportNull$$$0(1);
            }
            this.myCommand = command;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "undoConfirmationPolicy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

