/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> myKeyToValueMap = new THashMap();
    private final Map<V, List<K>> myValueToKeysMap = new THashMap<V, List<K>>();

    @Override
    public V put(K key, V value) {
        List<K> array;
        V oldValue = this.myKeyToValueMap.put(key, value);
        if (oldValue != null) {
            if (oldValue.equals(value)) {
                return oldValue;
            }
            array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
        }
        if ((array = this.myValueToKeysMap.get(value)) == null) {
            array = new ArrayList<K>();
            this.myValueToKeysMap.put((List<K>)value, (List<V>)array);
        }
        array.add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public List<K> getKeysByValue(V value) {
        return this.myValueToKeysMap.get(value);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myKeyToValueMap.keySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    @Override
    public V remove(Object key) {
        V value = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            BidirectionalMap.$$$reportNull$$$0(1);
        }
        for (K k1 : t.keySet()) {
            this.put(k1, t.get(k1));
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Set<V> set = this.myValueToKeysMap.keySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.myKeyToValueMap.entrySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    public String toString() {
        return new HashMap(this.myKeyToValueMap).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/BidirectionalMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/BidirectionalMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

