/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingServices;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiConstantParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.PsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiCallsEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiConditionalEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiReturnsEffectParser;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "contractParsingServices", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;)V", "conditionParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "constantParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConstantParser;", "getContractParsingServices", "()Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "effectsParsers", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/contracts/parsing/PsiEffectParser;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "parseCondition", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parseConstant", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "parseContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parseEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "parseValue", "Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "parseVariable", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "frontend"})
public final class PsiContractParserDispatcher {
    private final PsiConditionParser conditionParser;
    private final PsiConstantParser constantParser;
    private final Map<Name, PsiEffectParser> effectsParsers;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final ContractParsingServices contractParsingServices;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ContractDescription parseContract(@Nullable KtExpression expression2, @NotNull FunctionDescriptor ownerDescriptor) {
        Collection destination$iv$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(ownerDescriptor, "ownerDescriptor");
        if (expression2 == null) {
            return null;
        }
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        if (!this.contractParsingServices.isContractDescriptionCall$frontend(expression2, bindingContext)) {
            return null;
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (resolvedCall3 == null) {
            Intrinsics.throwNpe();
        }
        if (!((ktExpression = PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall2 = resolvedCall3)) instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)ktExpression;
        if (ktLambdaExpression == null) {
            return null;
        }
        KtLambdaExpression lambda2 = ktLambdaExpression;
        Object object = lambda2.getBodyExpression();
        if (object != null && (object = ((KtBlockExpression)object).getStatements()) != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                EffectDeclaration effectDeclaration;
                Object element$iv$iv = element$iv$iv$iv;
                KtExpression it = (KtExpression)element$iv$iv;
                if (this.parseEffect(it) == null) continue;
                EffectDeclaration it$iv$iv = effectDeclaration;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return null;
        }
        List effects = (List)destination$iv$iv;
        if (effects.isEmpty()) {
            return null;
        }
        return new ContractDescription(effects, ownerDescriptor);
    }

    @Nullable
    public final BooleanExpression parseCondition(@Nullable KtExpression expression2) {
        KtExpression ktExpression = expression2;
        return ktExpression != null ? (BooleanExpression)ktExpression.accept(this.conditionParser, Unit.INSTANCE) : null;
    }

    @Nullable
    public final EffectDeclaration parseEffect(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        KotlinType kotlinType = CallUtilKt.getType(expression2, bindingContext);
        if (kotlinType == null) {
            return null;
        }
        KotlinType returnType = kotlinType;
        Map<Name, PsiEffectParser> map2 = this.effectsParsers;
        ClassifierDescriptor classifierDescriptor = returnType.getConstructor().getDeclarationDescriptor();
        Name name = classifierDescriptor != null ? classifierDescriptor.getName() : null;
        PsiEffectParser parser = map2.get(name);
        if (parser == null) {
            this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)expression2), "Unrecognized effect"));
            return null;
        }
        return parser.tryParseEffect(expression2);
    }

    @Nullable
    public final ConstantReference parseConstant(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        return (ConstantReference)expression2.accept(this.constantParser, Unit.INSTANCE);
    }

    @Nullable
    public final VariableReference parseVariable(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall2;
        if (!(descriptor2 instanceof ParameterDescriptor)) {
            this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)expression2), "only references to parameters are allowed in contract description"));
            return null;
        }
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            ClassifierDescriptor classifierDescriptor = ((ReceiverParameterDescriptor)((Object)descriptor2)).getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor != null) {
                if (PsiContractsUtilsKt.isFromContractDsl(classifierDescriptor)) {
                    this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)expression2), "only references to parameters are allowed. Did you miss label on <this>?"));
                }
            }
        }
        return KotlinBuiltIns.isBoolean(((ParameterDescriptor)((Object)descriptor2)).getType()) ? (VariableReference)new BooleanVariableReference((ParameterDescriptor)((Object)descriptor2)) : new VariableReference((ParameterDescriptor)((Object)descriptor2));
    }

    @Nullable
    public final ContractDescriptionValue parseValue(@Nullable KtExpression expression2) {
        VariableReference variable2 = this.parseVariable(expression2);
        if (variable2 != null) {
            return variable2;
        }
        return this.parseConstant(expression2);
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public final ContractParsingServices getContractParsingServices() {
        return this.contractParsingServices;
    }

    public PsiContractParserDispatcher(@NotNull BindingTrace trace, @NotNull ContractParsingServices contractParsingServices) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(contractParsingServices, "contractParsingServices");
        this.trace = trace;
        this.contractParsingServices = contractParsingServices;
        this.conditionParser = new PsiConditionParser(this.trace, this);
        this.constantParser = new PsiConstantParser(this.trace);
        this.effectsParsers = MapsKt.mapOf(TuplesKt.to(ContractsDslNames.INSTANCE.getRETURNS_EFFECT(), new PsiReturnsEffectParser(this.trace, this)), TuplesKt.to(ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL_EFFECT(), new PsiReturnsEffectParser(this.trace, this)), TuplesKt.to(ContractsDslNames.INSTANCE.getCALLS_IN_PLACE_EFFECT(), new PsiCallsEffectParser(this.trace, this)), TuplesKt.to(ContractsDslNames.INSTANCE.getCONDITIONAL_EFFECT(), new PsiConditionalEffectParser(this.trace, this)));
    }
}

