/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"binaryOperationTypes", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
public final class BinaryOperationIntrinsicsKt {
    @NotNull
    public static final Pair<KotlinType, KotlinType> binaryOperationTypes(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        KtExpression ktExpression;
        KtExpression it;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        PrimitiveNumericComparisonInfo info = UtilsKt.getPrimitiveNumericComparisonInfo(context, expression2);
        if (info != null) {
            return TuplesKt.to(info.getLeftType(), info.getRightType());
        }
        KtExpression ktExpression2 = expression2.getLeft();
        if (ktExpression2 != null) {
            KtExpression ktExpression3 = it = (ktExpression = ktExpression2);
            Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "it");
            kotlinType2 = UtilsKt.getPrecisePrimitiveType(context, ktExpression3);
        } else {
            kotlinType2 = null;
        }
        KtExpression ktExpression4 = expression2.getRight();
        if (ktExpression4 != null) {
            ktExpression = ktExpression4;
            KotlinType kotlinType3 = kotlinType2;
            KtExpression ktExpression5 = it = ktExpression;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression5, "it");
            KotlinType kotlinType4 = UtilsKt.getPrecisePrimitiveType(context, ktExpression5);
            kotlinType2 = kotlinType3;
            kotlinType = kotlinType4;
        } else {
            kotlinType = null;
        }
        return TuplesKt.to(kotlinType2, kotlinType);
    }
}

