/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalClassGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateLocalClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateObjectLiteral", "ktObjectLiteral", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "ir.psi2ir"})
public final class LocalClassGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrStatement generateObjectLiteral(@NotNull KtObjectLiteralExpression ktObjectLiteral) {
        boolean bl;
        ClassConstructorDescriptor objectConstructor;
        Intrinsics.checkParameterIsNotNull(ktObjectLiteral, "ktObjectLiteral");
        KotlinType objectLiteralType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktObjectLiteral);
        IrBlockImpl irBlock2 = new IrBlockImpl(PsiUtilsKt.getStartOffset(ktObjectLiteral), PsiUtilsKt.getEndOffset(ktObjectLiteral), objectLiteralType, IrStatementOrigin.OBJECT_LITERAL.INSTANCE);
        DeclarationGenerator declarationGenerator = new DeclarationGenerator(this.getStatementGenerator().getContext());
        KtObjectDeclaration ktObjectDeclaration = ktObjectLiteral.getObjectDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(ktObjectDeclaration, "ktObjectLiteral.objectDeclaration");
        IrClass irClass = declarationGenerator.generateClassOrObjectDeclaration(ktObjectDeclaration);
        irBlock2.getStatements().add(irClass);
        ClassConstructorDescriptor classConstructorDescriptor = irClass.getDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Object literal should have a primary constructor: " + irClass.getDescriptor())));
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = objectConstructor = classConstructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor2, "objectConstructor");
        boolean bl2 = bl = classConstructorDescriptor2.getDispatchReceiverParameter() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Object literal constructor should have no dispatch receiver parameter: " + objectConstructor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = objectConstructor.getExtensionReceiverParameter() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Object literal constructor should have no extension receiver parameter: " + objectConstructor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl4 = bl = objectConstructor.getValueParameters().size() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Object literal constructor should have no value parameters: " + objectConstructor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        irBlock2.getStatements().add(new IrCallImpl(PsiUtilsKt.getStartOffset(ktObjectLiteral), PsiUtilsKt.getEndOffset(ktObjectLiteral), objectLiteralType, this.getContext().getSymbolTable().referenceConstructor(objectConstructor), objectConstructor, null, IrStatementOrigin.OBJECT_LITERAL.INSTANCE, null, 128, null));
        return irBlock2;
    }

    @NotNull
    public final IrStatement generateLocalClass(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull(ktClassOrObject, "ktClassOrObject");
        return new DeclarationGenerator(this.getStatementGenerator().getContext()).generateClassOrObjectDeclaration(ktClassOrObject);
    }

    public LocalClassGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }
}

