package Lire::Config::ChartSpec;

use strict;

use base qw/Lire::Config::CompoundSpec/;

use Lire::Config::StringSpec;
use Lire::Config::ChartTypeSpec;
use Lire::Report::ChartConfig;
use Locale::TextDomain 'lire';

=pod

=head1 NAME

Lire::Config::ChartSpec - Defines a chart to generate.

=head1 DESCRIPTION

This Lire::Config::TypeSpec is a CompoundSpec which can be used to
configure a chart to generate from a Subreport.

=head2 new()

Create a Lire::Config::ChartSpec object.

=cut

sub new {
    my $self = shift->SUPER::new( @_, 'label' => 'name' );

    $self->add( new Lire::Config::StringSpec( 'name' => 'name',
                                              'required' => '0',
                                              'summary' => "Chart's basename",
                                              'description' => '<para>' . join( "", N__( "The basename of the chart. An extension will be appended based on the chart's format. If this attribute isn't set, the Subreport'id will be used." ) ) . "</para>" ) );

    $self->add( new Lire::Config::StringSpec( 'name' => 'title',
                                              'required' => 0,
                                              'summary' => "Title",
                                              'description' => '<para>' . join( "", N__( "The title that will appear on the chart." ) ) . "</para>" ) );

    $self->add( new Lire::Config::ChartTypeSpec( 'name' => 'type',
                                                 'summary' => "Type",
                                                 'description' => '<para>' . join( "", N__( "The type of charts to generate. Chart types are plugins." ) ) . "</para>" ) );

   $self->add( new Lire::Config::ReferenceSpec( 'name' => 'case_var',
                                                'index' => 'categorical_variables',
                                                'summary' => "Case",
                                                'description' => '<para>' . join( "", N__( "The categorical variable that will be used to select the case that will make the chart's data." ) ) . "</para>" ) );

    $self->add( new Lire::Config::StringSpec( 'name' => 'xlabel',
                                              'required' => 0,
                                              'summary' => "X Axis Label",
                                              'description' => '<para>' . join( "", N__( "A title that will appear under the X axis." ) ) . "</para>" ) );

    $self->add( new Lire::Config::StringSpec( 'name' => 'ylabel',
                                              'required' => 0,
                                              'summary' => "Y Axis Label",
                                              'description' => '<para>' . join( "", N__( "A title that will appear along the Y axis." ) ) . "</para>" ) );
    return $self;
}

sub instance_class {
    return "Lire::Report::ChartConfig";
}

1;

__END__

=pod

=head2 SEE ALSO

  Lire::Config::ChartTypeSpec(3pm), Lire::ChartType(3pm)

=head1 VERSION

$Id: ChartSpec.pm,v 1.6 2006/07/23 13:16:30 vanbaal Exp $

=head1 AUTHOR

  Francis J. Lacoste <flacoste@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
