from typing import TypeVar, Generic, Any, Iterable, Iterator, Callable, Tuple, Optional, Set, NamedTuple

FIRST_COMPLETED = ...  # type: str
FIRST_EXCEPTION = ...  # type: str
ALL_COMPLETED = ...  # type: str
PENDING = ...  # type: Any
RUNNING = ...  # type: Any
CANCELLED = ...  # type: Any
CANCELLED_AND_NOTIFIED = ...  # type: Any
FINISHED = ...  # type: Any
LOGGER = ...  # type: Any

class Error(Exception): ...
class CancelledError(Error): ...
class TimeoutError(Error): ...

_T = TypeVar('_T')

class Future(Generic[_T]):
    def __init__(self) -> None: ...
    def cancel(self) -> bool: ...
    def cancelled(self) -> bool: ...
    def running(self) -> bool: ...
    def done(self) -> bool: ...
    def add_done_callback(self, fn: Callable[[Future[_T]], Any]) -> None: ...
    def result(self, timeout: Optional[float] = ...) -> _T: ...
    def exception(self, timeout: Optional[float] = ...) -> Optional[BaseException]: ...
    def set_running_or_notify_cancel(self) -> bool: ...
    def set_result(self, result: _T) -> None: ...
    def set_exception(self, exception: Optional[BaseException]) -> None: ...

class Executor:
    def submit(self, fn: Callable[..., _T], *args: Any, **kwargs: Any) -> Future[_T]: ...
    def map(self, func: Callable[..., _T], *iterables: Iterable[Any], timeout: Optional[float] = ..., chunksize: int = ...) -> Iterator[_T]: ...
    def shutdown(self, wait: bool = ...) -> None: ...
    def __enter__(self: _T) -> _T: ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> bool: ...

def as_completed(fs: Iterable[Future[_T]], timeout: Optional[float] = ...) -> Iterator[Future[_T]]: ...

def wait(fs: Iterable[Future[_T]], timeout: Optional[float] = ..., return_when: str = ...) -> Tuple[Set[Future[_T]], Set[Future[_T]]]: ...
