/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.ontology.OWLOntologyFrame;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.metrics.MetricsPanel;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLOntologyDisplayPanel
extends JPanel {
    private static final long serialVersionUID = -807382490474755622L;
    private OWLEditorKit owlEditorKit;
    private JLabel ontologyURILabel;
    private OWLOntologyFrame ontologyFrame;
    private OWLFrameList<OWLOntology> frameList;
    private MetricsPanel metricsPanel;

    public OWLOntologyDisplayPanel(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.createUI();
        this.setOntology(owlEditorKit.getModelManager().getActiveOntology());
    }

    private void createUI() {
        this.setLayout(new BorderLayout(7, 7));
        this.ontologyURILabel = new JLabel();
        this.add((Component)this.ontologyURILabel, "North");
        this.ontologyFrame = new OWLOntologyFrame(this.owlEditorKit);
        this.ontologyFrame.setRootObject(null);
        this.frameList = new OWLFrameList<OWLOntology>(this.owlEditorKit, this.ontologyFrame);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.85);
        this.add(splitPane);
        splitPane.setBorder(null);
        splitPane.setLeftComponent(new JScrollPane((Component)((Object)this.frameList)));
        this.metricsPanel = new MetricsPanel(this.owlEditorKit);
        splitPane.setRightComponent(this.metricsPanel);
    }

    public void setOntology(OWLOntology ontology) {
        this.frameList.setRootObject(ontology);
        try {
            this.metricsPanel.updateView(ontology);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

