/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.osgi.obr.xml.RequirementFilter;

public abstract class MultiOperatorFilter
extends RequirementFilter {
    private List subFilters = new ArrayList();

    public MultiOperatorFilter() {
    }

    public MultiOperatorFilter(RequirementFilter[] requirementFilterArray) {
        for (int i = 0; i < requirementFilterArray.length; ++i) {
            RequirementFilter requirementFilter = requirementFilterArray[i];
            this.add(requirementFilter);
        }
    }

    protected abstract char operator();

    @Override
    public void append(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        stringBuffer.append(this.operator());
        for (RequirementFilter requirementFilter : this.subFilters) {
            requirementFilter.append(stringBuffer);
        }
        stringBuffer.append(')');
    }

    public void add(RequirementFilter requirementFilter) {
        this.subFilters.add(requirementFilter);
    }

    public List getSubFilters() {
        return this.subFilters;
    }

    public int hashCode() {
        int n = 1;
        for (RequirementFilter requirementFilter : this.subFilters) {
            n = 31 * n + (requirementFilter == null ? 0 : requirementFilter.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MultiOperatorFilter)) {
            return false;
        }
        MultiOperatorFilter multiOperatorFilter = (MultiOperatorFilter)object;
        if (this.subFilters == null) {
            if (multiOperatorFilter.subFilters != null) {
                return false;
            }
        } else {
            if (multiOperatorFilter.subFilters == null) {
                return false;
            }
            if (this.subFilters.size() != multiOperatorFilter.subFilters.size()) {
                return false;
            }
            if (!this.subFilters.containsAll(multiOperatorFilter.subFilters)) {
                return false;
            }
        }
        return true;
    }
}

