/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CloseConnectionException;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.ConnectionLostException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.MemoryLimitException;
import com.zeroc.Ice.ObjectAdapterDeactivatedException;
import com.zeroc.Ice.ProtocolException;
import com.zeroc.Ice.WSConnectionInfo;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.HttpParser;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceInternal.WebSocketException;
import com.zeroc.IceUtilInternal.Base64;
import com.zeroc.IceUtilInternal.StringUtil;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

final class WSTransceiver
implements Transceiver {
    private ProtocolInstance _instance;
    private Transceiver _delegate;
    private String _host;
    private String _resource;
    private boolean _incoming;
    private ReadyCallback _readyCallback;
    private int _state;
    private int _nextState;
    private HttpParser _parser;
    private String _key;
    private int _readState;
    private Buffer _readBuffer;
    private int _readBufferPos;
    private int _readBufferSize;
    private boolean _readLastFrame;
    private int _readOpCode;
    private int _readHeaderLength;
    private int _readPayloadLength;
    private int _readStart;
    private int _readFrameStart;
    private byte[] _readMask;
    private int _writeState;
    private Buffer _writeBuffer;
    private int _writeBufferSize;
    private byte[] _writeMask;
    private int _writePayloadLength;
    private boolean _closingInitiator;
    private int _closingReason;
    private byte[] _pingPayload;
    private Random _rand;
    static final Charset _ascii = Charset.forName("US-ASCII");

    @Override
    public SelectableChannel fd() {
        return this._delegate.fd();
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
        this._readyCallback = callback;
        this._delegate.setReadyCallback(callback);
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer) {
        if (this._state == 0) {
            int op = this._delegate.initialize(readBuffer, writeBuffer);
            if (op != 0) {
                return op;
            }
            this._state = 1;
        }
        try {
            block27: {
                block26: {
                    int p;
                    if (this._state == 1) {
                        this._readBuffer.resize(1024, true);
                        this._readBuffer.b.position(0);
                        this._readBufferPos = 0;
                        this._state = 2;
                        if (!this._incoming) {
                            StringBuffer out = new StringBuffer();
                            out.append("GET " + this._resource + " HTTP/1.1\r\n");
                            out.append("Host: " + this._host);
                            out.append("\r\n");
                            out.append("Upgrade: websocket\r\n");
                            out.append("Connection: Upgrade\r\n");
                            out.append("Sec-WebSocket-Protocol: ice.zeroc.com\r\n");
                            out.append("Sec-WebSocket-Version: 13\r\n");
                            out.append("Sec-WebSocket-Key: ");
                            byte[] key = new byte[16];
                            this._rand.nextBytes(key);
                            this._key = Base64.encode(key);
                            out.append(this._key + "\r\n\r\n");
                            this._writeBuffer.resize(out.length(), false);
                            this._writeBuffer.b.position(0);
                            this._writeBuffer.b.put(out.toString().getBytes(_ascii));
                            this._writeBuffer.b.flip();
                        }
                    }
                    if (this._state == 2 && !this._incoming) {
                        int s;
                        if (this._writeBuffer.b.hasRemaining() && (s = this._delegate.write(this._writeBuffer)) != 0) {
                            return s;
                        }
                        assert (!this._writeBuffer.b.hasRemaining());
                        this._state = 3;
                    }
                    while (true) {
                        int s;
                        if (this._readBuffer.b.hasRemaining() && ((s = this._delegate.read(this._readBuffer)) == 4 || this._readBuffer.b.position() == 0)) {
                            return s;
                        }
                        if ((this._state != 2 || !this._incoming) && (this._state != 3 || this._incoming)) break block26;
                        p = this._parser.isCompleteMessage(this._readBuffer.b, 0, this._readBuffer.b.position());
                        if (p != -1) break;
                        if (this._readBuffer.b.hasRemaining()) {
                            return 1;
                        }
                        int oldSize = this._readBuffer.b.position();
                        if (oldSize + 1024 > this._instance.messageSizeMax()) {
                            throw new MemoryLimitException();
                        }
                        this._readBuffer.resize(oldSize + 1024, true);
                        this._readBuffer.b.position(oldSize);
                    }
                    this._readBufferPos = p;
                }
                try {
                    if (this._state == 2 && this._incoming) {
                        if (this._parser.parse(this._readBuffer.b, 0, this._readBufferPos)) {
                            this.handleRequest(this._writeBuffer);
                            this._state = 3;
                        } else {
                            throw new ProtocolException("incomplete request message");
                        }
                    }
                    if (this._state != 3) break block27;
                    if (this._incoming) {
                        int s;
                        if (this._writeBuffer.b.hasRemaining() && (s = this._delegate.write(this._writeBuffer)) != 0) {
                            return s;
                        }
                        break block27;
                    }
                    if (this._parser.parse(this._readBuffer.b, 0, this._readBufferPos)) {
                        this.handleResponse();
                        break block27;
                    }
                    throw new ProtocolException("incomplete response message");
                }
                catch (WebSocketException ex) {
                    throw new ProtocolException(ex.getMessage(), ex);
                }
            }
            this._state = 4;
            this._nextState = 4;
            if (this._readBufferPos < this._readBuffer.b.position()) {
                this._readyCallback.ready(1, true);
            }
        }
        catch (LocalException ex) {
            if (this._instance.traceLevel() >= 2) {
                this._instance.logger().trace(this._instance.traceCategory(), this.protocol() + " connection HTTP upgrade request failed\n" + this.toString() + "\n" + ex);
            }
            throw ex;
        }
        if (this._instance.traceLevel() >= 1) {
            if (this._incoming) {
                this._instance.logger().trace(this._instance.traceCategory(), "accepted " + this.protocol() + " connection HTTP upgrade request\n" + this.toString());
            } else {
                this._instance.logger().trace(this._instance.traceCategory(), this.protocol() + " connection HTTP upgrade request accepted\n" + this.toString());
            }
        }
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException reason) {
        int s;
        if (this._instance.traceLevel() >= 1) {
            this._instance.logger().trace(this._instance.traceCategory(), "gracefully closing " + this.protocol() + " connection\n" + this.toString());
        }
        int n = s = this._nextState == 4 ? this._state : this._nextState;
        if (s == 7 && this._closingInitiator) {
            assert (!initiator);
            this._closingInitiator = false;
            return 4;
        }
        if (s >= 7) {
            return 0;
        }
        this._closingInitiator = initiator;
        if (reason instanceof CloseConnectionException) {
            this._closingReason = 1000;
        } else if (reason instanceof ObjectAdapterDeactivatedException || reason instanceof CommunicatorDestroyedException) {
            this._closingReason = 1001;
        } else if (reason instanceof ProtocolException) {
            this._closingReason = 1002;
        } else if (reason instanceof MemoryLimitException) {
            this._closingReason = 1009;
        }
        if (this._state == 4) {
            this._state = 7;
            return initiator ? 1 : 4;
        }
        this._nextState = 7;
        return 0;
    }

    @Override
    public void close() {
        this._delegate.close();
        this._state = 9;
        this._writeBuffer.clear();
        this._readBuffer.clear();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buf) {
        if (this._state < 4) {
            if (this._state < 1) {
                return this._delegate.write(buf);
            }
            return this._delegate.write(this._writeBuffer);
        }
        int s = 0;
        do {
            if (!this.preWrite(buf)) continue;
            if (this._writeState == 3) {
                assert (!buf.b.hasRemaining());
                s = this._delegate.write(buf);
            }
            if (s == 0 && this._writeBuffer.b.hasRemaining()) {
                s = this._delegate.write(this._writeBuffer);
                continue;
            }
            if (s != 0 || !this._incoming || buf.empty() || this._writeState != 1) continue;
            s = this._delegate.write(buf);
        } while (this.postWrite(buf, s));
        if (s != 0) {
            return s;
        }
        if (this._state == 8 && !this._closingInitiator) {
            return 1;
        }
        return 0;
    }

    @Override
    public int read(Buffer buf) {
        if (this._state < 4) {
            if (this._state < 1) {
                return this._delegate.read(buf);
            }
            if (this._delegate.read(this._readBuffer) == 4) {
                return 4;
            }
            return 0;
        }
        if (!buf.b.hasRemaining()) {
            if (this._readBufferPos < this._readBuffer.b.position()) {
                this._readyCallback.ready(1, true);
            }
            return 0;
        }
        int s = 0;
        do {
            if (!this.preRead(buf)) continue;
            if (this._readState == 3) {
                int readSz = this._readPayloadLength - (buf.b.position() - this._readStart);
                if (buf.b.remaining() > readSz) {
                    int size = buf.size();
                    buf.resize(buf.b.position() + readSz, true);
                    s = this._delegate.read(buf);
                    buf.resize(size, true);
                } else {
                    s = this._delegate.read(buf);
                }
            } else {
                s = this._delegate.read(this._readBuffer);
            }
            if (s != 4) continue;
            this.postRead(buf);
            return s;
        } while (this.postRead(buf));
        if (!buf.b.hasRemaining()) {
            if (this._readBufferPos < this._readBuffer.b.position()) {
                this._readyCallback.ready(1, true);
            }
            s = 0;
        } else {
            this._readyCallback.ready(1, false);
            s = 1;
        }
        if ((this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator || this._state == 5 || this._state == 6) && this._writeState == 0) {
            s |= 4;
        }
        return s;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._delegate.toString();
    }

    @Override
    public String toDetailedString() {
        return this._delegate.toDetailedString();
    }

    @Override
    public ConnectionInfo getInfo() {
        WSConnectionInfo info = new WSConnectionInfo();
        info.underlying = this._delegate.getInfo();
        info.headers = this._parser.getHeaders();
        return info;
    }

    @Override
    public void checkSendSize(Buffer buf) {
        this._delegate.checkSendSize(buf);
    }

    @Override
    public void setBufferSize(int rcvSize, int sndSize) {
        this._delegate.setBufferSize(rcvSize, sndSize);
    }

    WSTransceiver(ProtocolInstance instance, Transceiver del, String host, String resource) {
        this.init(instance, del);
        this._host = host;
        this._resource = resource;
        this._incoming = false;
        this._writeBufferSize = 16384;
        assert (this._writeBufferSize > 256);
        assert (this._readBufferSize > 256);
    }

    WSTransceiver(ProtocolInstance instance, Transceiver del) {
        this.init(instance, del);
        this._host = "";
        this._resource = "";
        this._incoming = true;
        assert (this._writeBufferSize > 256);
        assert (this._readBufferSize > 256);
    }

    private void init(ProtocolInstance instance, Transceiver del) {
        this._instance = instance;
        this._delegate = del;
        this._state = 0;
        this._parser = new HttpParser();
        this._readState = 0;
        this._readBuffer = new Buffer(false, ByteOrder.BIG_ENDIAN);
        this._readBufferSize = 1024;
        this._readLastFrame = true;
        this._readOpCode = 0;
        this._readHeaderLength = 0;
        this._readPayloadLength = 0;
        this._readMask = new byte[4];
        this._writeState = 0;
        this._writeBuffer = new Buffer(false, ByteOrder.BIG_ENDIAN);
        this._writeBufferSize = 1024;
        this._readMask = new byte[4];
        this._writeMask = new byte[4];
        this._key = "";
        this._pingPayload = new byte[0];
        this._rand = new Random();
    }

    private void handleRequest(Buffer responseBuffer) {
        String key;
        if (this._parser.versionMajor() != 1 || this._parser.versionMinor() != 1) {
            throw new WebSocketException("unsupported HTTP version");
        }
        String val = this._parser.getHeader("Upgrade", true);
        if (val == null) {
            throw new WebSocketException("missing value for Upgrade field");
        }
        if (!val.equals("websocket")) {
            throw new WebSocketException("invalid value `" + val + "' for Upgrade field");
        }
        val = this._parser.getHeader("Connection", true);
        if (val == null) {
            throw new WebSocketException("missing value for Connection field");
        }
        if (val.indexOf("upgrade") == -1) {
            throw new WebSocketException("invalid value `" + val + "' for Connection field");
        }
        val = this._parser.getHeader("Sec-WebSocket-Version", false);
        if (val == null) {
            throw new WebSocketException("missing value for WebSocket version");
        }
        if (!val.equals("13")) {
            throw new WebSocketException("unsupported WebSocket version `" + val + "'");
        }
        boolean addProtocol = false;
        val = this._parser.getHeader("Sec-WebSocket-Protocol", true);
        if (val != null) {
            String[] protocols = StringUtil.splitString(val, ",");
            if (protocols == null) {
                throw new WebSocketException("invalid value `" + val + "' for WebSocket protocol");
            }
            for (String p : protocols) {
                if (!p.trim().equals("ice.zeroc.com")) {
                    throw new WebSocketException("unknown value `" + p + "' for WebSocket protocol");
                }
                addProtocol = true;
            }
        }
        if ((key = this._parser.getHeader("Sec-WebSocket-Key", false)) == null) {
            throw new WebSocketException("missing value for WebSocket key");
        }
        try {
            byte[] decodedKey = Base64.decode(key);
            if (decodedKey.length != 16) {
                throw new WebSocketException("WebSocket key `" + key + "' has invalid length");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new WebSocketException("invalid base64 value `" + key + "' for WebSocket key");
        }
        this._resource = this._parser.uri();
        StringBuffer out = new StringBuffer();
        out.append("HTTP/1.1 101 Switching Protocols\r\n");
        out.append("Upgrade: websocket\r\n");
        out.append("Connection: Upgrade\r\n");
        if (addProtocol) {
            out.append("Sec-WebSocket-Protocol: ice.zeroc.com\r\n");
        }
        out.append("Sec-WebSocket-Accept: ");
        String input = key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(input.getBytes(_ascii));
            byte[] hash = sha1.digest();
            out.append(Base64.encode(hash) + "\r\n\r\n");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WebSocketException(ex);
        }
        byte[] bytes = out.toString().getBytes(_ascii);
        assert (bytes.length == out.length());
        responseBuffer.resize(bytes.length, false);
        responseBuffer.b.position(0);
        responseBuffer.b.put(bytes);
        responseBuffer.b.flip();
    }

    private void handleResponse() {
        if (this._parser.versionMajor() != 1 || this._parser.versionMinor() != 1) {
            throw new WebSocketException("unsupported HTTP version");
        }
        if (this._parser.status() != 101) {
            StringBuffer out = new StringBuffer("unexpected status value " + this._parser.status());
            if (this._parser.reason().length() > 0) {
                out.append(":\n" + this._parser.reason());
            }
            throw new WebSocketException(out.toString());
        }
        String val = this._parser.getHeader("Upgrade", true);
        if (val == null) {
            throw new WebSocketException("missing value for Upgrade field");
        }
        if (!val.equals("websocket")) {
            throw new WebSocketException("invalid value `" + val + "' for Upgrade field");
        }
        val = this._parser.getHeader("Connection", true);
        if (val == null) {
            throw new WebSocketException("missing value for Connection field");
        }
        if (val.indexOf("upgrade") == -1) {
            throw new WebSocketException("invalid value `" + val + "' for Connection field");
        }
        val = this._parser.getHeader("Sec-WebSocket-Protocol", true);
        if (val != null && !val.equals("ice.zeroc.com")) {
            throw new WebSocketException("invalid value `" + val + "' for WebSocket protocol");
        }
        val = this._parser.getHeader("Sec-WebSocket-Accept", false);
        if (val == null) {
            throw new WebSocketException("missing value for Sec-WebSocket-Accept");
        }
        try {
            String input = this._key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(input.getBytes(_ascii));
            if (!val.equals(Base64.encode(sha1.digest()))) {
                throw new WebSocketException("invalid value `" + val + "' for Sec-WebSocket-Accept");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WebSocketException(ex);
        }
    }

    private boolean preRead(Buffer buf) {
        do {
            if (this._readState == 0) {
                boolean masked;
                int ch;
                if (!this.readBuffered(2)) {
                    return true;
                }
                if ((ch = this._readBuffer.b.get(this._readBufferPos++)) < 0) {
                    ch += 256;
                }
                this._readOpCode = ch & 0xF;
                if (this._readOpCode == 2) {
                    if (!this._readLastFrame) {
                        throw new ProtocolException("invalid data frame, no FIN on previous frame");
                    }
                    this._readLastFrame = (ch & 0x80) == 128;
                } else if (this._readOpCode == 0) {
                    if (this._readLastFrame) {
                        throw new ProtocolException("invalid continuation frame, previous frame FIN set");
                    }
                    this._readLastFrame = (ch & 0x80) == 128;
                }
                ch = this._readBuffer.b.get(this._readBufferPos++);
                if (ch < 0) {
                    ch += 256;
                }
                boolean bl = masked = (ch & 0x80) == 128;
                if (masked != this._incoming) {
                    throw new ProtocolException("invalid masking");
                }
                this._readPayloadLength = ch & 0x7F;
                this._readHeaderLength = this._readPayloadLength < 126 ? 0 : (this._readPayloadLength == 126 ? 2 : 8);
                if (masked) {
                    this._readHeaderLength += 4;
                }
                this._readState = 1;
            }
            if (this._readState == 1) {
                if (this._readHeaderLength > 0 && !this.readBuffered(this._readHeaderLength)) {
                    return true;
                }
                if (this._readPayloadLength == 126) {
                    this._readPayloadLength = this._readBuffer.b.getShort(this._readBufferPos);
                    if (this._readPayloadLength < 0) {
                        this._readPayloadLength += 65536;
                    }
                    this._readBufferPos += 2;
                } else if (this._readPayloadLength == 127) {
                    long l = this._readBuffer.b.getLong(this._readBufferPos);
                    this._readBufferPos += 8;
                    if (l < 0L || l > Integer.MAX_VALUE) {
                        throw new ProtocolException("invalid WebSocket payload length: " + l);
                    }
                    this._readPayloadLength = (int)l;
                }
                if (this._incoming) {
                    assert (this._readBuffer.b.position() - this._readBufferPos >= 4);
                    for (int i = 0; i < 4; ++i) {
                        this._readMask[i] = this._readBuffer.b.get(this._readBufferPos++);
                    }
                }
                switch (this._readOpCode) {
                    case 1: {
                        throw new ProtocolException("text frames not supported");
                    }
                    case 0: 
                    case 2: {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + (this._readOpCode == 2 ? " data" : " continuation") + " frame with payload length of " + this._readPayloadLength + " bytes\n" + this.toString());
                        }
                        if (this._readPayloadLength <= 0) {
                            throw new ProtocolException("payload length is 0");
                        }
                        this._readState = 3;
                        assert (buf.b.hasRemaining());
                        this._readFrameStart = buf.b.position();
                        break;
                    }
                    case 8: {
                        int s;
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + " connection close frame\n" + this.toString());
                        }
                        int n = s = this._nextState == 4 ? this._state : this._nextState;
                        if (s == 7) {
                            if (!this._closingInitiator) {
                                this._closingInitiator = true;
                            }
                            if (this._state == 7) {
                                this._state = 8;
                            } else {
                                this._nextState = 8;
                            }
                            return false;
                        }
                        throw new ConnectionLostException();
                    }
                    case 9: {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + " connection ping frame\n" + this.toString());
                        }
                        this._readState = 2;
                        break;
                    }
                    case 10: {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + " connection pong frame\n" + this.toString());
                        }
                        this._readState = 2;
                        break;
                    }
                    default: {
                        throw new ProtocolException("unsupported opcode: " + this._readOpCode);
                    }
                }
            }
            if (this._readState != 2) continue;
            if (this._readPayloadLength > 0 && !this.readBuffered(this._readPayloadLength)) {
                return true;
            }
            if (this._readPayloadLength > 0 && this._readOpCode == 9) {
                this._pingPayload = new byte[this._readPayloadLength];
                if (this._readBuffer.b.hasArray()) {
                    System.arraycopy(this._readBuffer.b.array(), this._readBuffer.b.arrayOffset() + this._readBufferPos, this._pingPayload, 0, this._readPayloadLength);
                } else {
                    for (int i = 0; i < this._readPayloadLength; ++i) {
                        this._pingPayload[i] = this._readBuffer.b.get(this._readBufferPos + i);
                    }
                }
            }
            this._readBufferPos += this._readPayloadLength;
            this._readPayloadLength = 0;
            if (this._readOpCode == 9) {
                if (this._state == 4) {
                    this._state = 6;
                } else if (this._nextState < 6) {
                    this._nextState = 6;
                }
            }
            this._readState = 0;
        } while (this._readState != 3);
        this._readStart = buf.b.position();
        if (buf.empty() || !buf.b.hasRemaining()) {
            return false;
        }
        int n = Math.min(this._readBuffer.b.position() - this._readBufferPos, buf.b.remaining());
        if (n > this._readPayloadLength) {
            n = this._readPayloadLength;
        }
        if (n > 0) {
            if (buf.b.hasArray() && this._readBuffer.b.hasArray()) {
                System.arraycopy(this._readBuffer.b.array(), this._readBuffer.b.arrayOffset() + this._readBufferPos, buf.b.array(), buf.b.arrayOffset() + buf.b.position(), n);
                buf.b.position(buf.b.position() + n);
            } else {
                for (int i = 0; i < n; ++i) {
                    buf.b.put(this._readBuffer.b.get(this._readBufferPos + i));
                }
            }
            this._readBufferPos += n;
        }
        return buf.b.hasRemaining() && n < this._readPayloadLength;
    }

    private boolean postRead(Buffer buf) {
        if (this._readState != 3) {
            return this._readStart < this._readBuffer.b.position();
        }
        if (this._readStart == buf.b.position()) {
            return false;
        }
        assert (this._readStart < buf.b.position());
        if (this._incoming) {
            int pos = buf.b.position();
            if (buf.b.hasArray()) {
                byte[] arr = buf.b.array();
                int offset = buf.b.arrayOffset();
                for (int n = this._readStart; n < pos; ++n) {
                    arr[n + offset] = (byte)(arr[n + offset] ^ this._readMask[(n - this._readFrameStart) % 4]);
                }
            } else {
                for (int n = this._readStart; n < pos; ++n) {
                    byte b = (byte)(buf.b.get(n) ^ this._readMask[(n - this._readFrameStart) % 4]);
                    buf.b.put(n, b);
                }
            }
        }
        this._readPayloadLength -= buf.b.position() - this._readStart;
        this._readStart = buf.b.position();
        if (this._readPayloadLength == 0) {
            this._readState = 0;
        }
        return buf.b.hasRemaining();
    }

    private boolean preWrite(Buffer buf) {
        if (this._writeState == 0) {
            if (this._state == 4) {
                if (buf.empty() || !buf.b.hasRemaining()) {
                    return false;
                }
                assert (buf.b.position() == 0);
                this.prepareWriteHeader((byte)2, buf.size());
                this._writeState = 1;
            } else if (this._state == 5) {
                this.prepareWriteHeader((byte)9, 0);
                this._writeState = 2;
                this._writeBuffer.b.flip();
            } else if (this._state == 6) {
                this.prepareWriteHeader((byte)10, this._pingPayload.length);
                if (this._pingPayload.length > this._writeBuffer.b.remaining()) {
                    int pos = this._writeBuffer.b.position();
                    this._writeBuffer.resize(pos + this._pingPayload.length, false);
                    this._writeBuffer.b.position(pos);
                }
                this._writeBuffer.b.put(this._pingPayload);
                this._pingPayload = new byte[0];
                this._writeState = 2;
                this._writeBuffer.b.flip();
            } else if (this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator) {
                this.prepareWriteHeader((byte)8, 2);
                this._writeBuffer.b.putShort((short)this._closingReason);
                if (!this._incoming) {
                    int pos = this._writeBuffer.b.position() - 2;
                    byte b = (byte)(this._writeBuffer.b.get(pos) ^ this._writeMask[0]);
                    this._writeBuffer.b.put(pos, b);
                    b = (byte)(this._writeBuffer.b.get(++pos) ^ this._writeMask[1]);
                    this._writeBuffer.b.put(pos, b);
                }
                this._writeState = 2;
                this._writeBuffer.b.flip();
            } else {
                assert (this._state != 9);
                return false;
            }
            this._writePayloadLength = 0;
        }
        if (this._writeState == 1) {
            int n;
            if (!(this._incoming || this._writePayloadLength != 0 && this._writeBuffer.b.hasRemaining())) {
                if (!this._writeBuffer.b.hasRemaining()) {
                    this._writeBuffer.b.position(0);
                }
                int sz = buf.size();
                if (buf.b.hasArray() && this._writeBuffer.b.hasArray()) {
                    int pos = this._writeBuffer.b.position();
                    int count = Math.min(sz - n, this._writeBuffer.b.remaining());
                    byte[] src = buf.b.array();
                    int srcOff = buf.b.arrayOffset();
                    byte[] dest = this._writeBuffer.b.array();
                    int destOff = this._writeBuffer.b.arrayOffset();
                    int i = 0;
                    while (i < count) {
                        dest[destOff + pos] = (byte)(src[srcOff + n] ^ this._writeMask[n % 4]);
                        ++i;
                        ++n;
                        ++pos;
                    }
                    this._writeBuffer.b.position(pos);
                } else {
                    for (n = buf.b.position(); n < sz && this._writeBuffer.b.hasRemaining(); ++n) {
                        byte b = (byte)(buf.b.get(n) ^ this._writeMask[n % 4]);
                        this._writeBuffer.b.put(b);
                    }
                }
                this._writePayloadLength = n;
                this._writeBuffer.b.flip();
            } else if (this._writePayloadLength == 0) {
                assert (this._incoming);
                if (this._writeBuffer.b.hasRemaining()) {
                    assert (buf.b.position() == 0);
                    n = this._writeBuffer.b.remaining();
                    if (buf.b.remaining() > n) {
                        int limit = buf.b.limit();
                        buf.b.limit(n);
                        this._writeBuffer.b.put(buf.b);
                        buf.b.limit(limit);
                        this._writePayloadLength = n;
                    } else {
                        this._writePayloadLength = buf.b.remaining();
                        this._writeBuffer.b.put(buf.b);
                    }
                    buf.b.position(0);
                }
                this._writeBuffer.b.flip();
            }
            return true;
        }
        if (this._writeState == 2) {
            return this._writeBuffer.b.hasRemaining();
        }
        assert (this._writeState == 3);
        return true;
    }

    private boolean postWrite(Buffer buf, int status) {
        if (this._state > 4 && this._writeState == 2) {
            if (!this._writeBuffer.b.hasRemaining()) {
                if (this._state == 5) {
                    if (this._instance.traceLevel() >= 2) {
                        this._instance.logger().trace(this._instance.traceCategory(), "sent " + this.protocol() + " connection ping frame\n" + this.toString());
                    }
                } else if (this._state == 6) {
                    if (this._instance.traceLevel() >= 2) {
                        this._instance.logger().trace(this._instance.traceCategory(), "sent " + this.protocol() + " connection pong frame\n" + this.toString());
                    }
                } else {
                    if (this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator) {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "sent " + this.protocol() + " connection close frame\n" + this.toString());
                        }
                        if (this._state == 7 && !this._closingInitiator) {
                            this._writeState = 0;
                            this._state = 8;
                            return false;
                        }
                        throw new ConnectionLostException();
                    }
                    if (this._state == 9) {
                        return false;
                    }
                }
                this._state = this._nextState;
                this._nextState = 4;
                this._writeState = 0;
            } else {
                return status == 0;
            }
        }
        if (!(this._incoming && buf.b.position() != 0 || this._writePayloadLength <= 0 || this._writeBuffer.b.hasRemaining())) {
            buf.b.position(this._writePayloadLength);
        }
        if (status == 4 && !buf.b.hasRemaining() && !this._writeBuffer.b.hasRemaining()) {
            this._writeState = 3;
            return false;
        }
        if (!buf.b.hasRemaining()) {
            this._writeState = 0;
            if (this._state == 5 || this._state == 6 || this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator) {
                return true;
            }
        } else if (this._state == 4) {
            return status == 0;
        }
        return false;
    }

    private boolean readBuffered(int sz) {
        if (this._readBufferPos == this._readBuffer.b.position()) {
            this._readBuffer.resize(this._readBufferSize, true);
            this._readBufferPos = 0;
            this._readBuffer.b.position(0);
        } else {
            int available = this._readBuffer.b.position() - this._readBufferPos;
            if (available < sz) {
                if (this._readBufferPos > 0) {
                    this._readBuffer.b.limit(this._readBuffer.b.position());
                    this._readBuffer.b.position(this._readBufferPos);
                    this._readBuffer.b.compact();
                    assert (this._readBuffer.b.position() == available);
                }
                this._readBuffer.resize(Math.max(this._readBufferSize, sz), true);
                this._readBufferPos = 0;
                this._readBuffer.b.position(available);
            }
        }
        this._readStart = this._readBuffer.b.position();
        if (this._readBufferPos + sz > this._readBuffer.b.position()) {
            return false;
        }
        assert (this._readBuffer.b.position() > this._readBufferPos);
        return true;
    }

    private void prepareWriteHeader(byte opCode, int payloadLength) {
        this._writeBuffer.resize(this._writeBufferSize, false);
        this._writeBuffer.b.limit(this._writeBufferSize);
        this._writeBuffer.b.position(0);
        this._writeBuffer.b.put((byte)(opCode | 0x80));
        if (payloadLength <= 125) {
            this._writeBuffer.b.put((byte)payloadLength);
        } else if (payloadLength > 125 && payloadLength <= 65535) {
            this._writeBuffer.b.put((byte)126);
            this._writeBuffer.b.putShort((short)payloadLength);
        } else if (payloadLength > 65535) {
            this._writeBuffer.b.put((byte)127);
            this._writeBuffer.b.putLong(payloadLength);
        }
        if (!this._incoming) {
            this._writeBuffer.b.put(1, (byte)(this._writeBuffer.b.get(1) | 0x80));
            this._rand.nextBytes(this._writeMask);
            this._writeBuffer.b.put(this._writeMask);
        }
    }
}

