// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 *
 **/
public interface QueryPrx extends Ice.ObjectPrx
{
    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @return The proxy or null if no such object has been found.
     *
     **/
    public Ice.ObjectPrx findObjectById(Ice.Identity id);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxy or null if no such object has been found.
     *
     **/
    public Ice.ObjectPrx findObjectById(Ice.Identity id, java.util.Map<String, String> context);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id, java.util.Map<String, String> context);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id, Ice.Callback cb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id, Callback_Query_findObjectById cb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id, java.util.Map<String, String> context, Callback_Query_findObjectById cb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find a well-known object by identity.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Ice.Identity id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find a well-known object by identity.
     *
     * @param result The asynchronous result object.
     * @return The proxy or null if no such object has been found.
     *
     **/
    public Ice.ObjectPrx end_findObjectById(Ice.AsyncResult result);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @return The proxy or null, if no such object has been found.
     *
     **/
    public Ice.ObjectPrx findObjectByType(String type);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     *
     **/
    public Ice.ObjectPrx findObjectByType(String type, java.util.Map<String, String> context);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type, java.util.Map<String, String> context);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type, Ice.Callback cb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type, Callback_Query_findObjectByType cb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type, java.util.Map<String, String> context, Callback_Query_findObjectByType cb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByType(String type,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     *
     * @param result The asynchronous result object.
     * @return The proxy or null, if no such object has been found.
     *
     **/
    public Ice.ObjectPrx end_findObjectByType(Ice.AsyncResult result);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @return The proxy or null, if no such object has been found.
     *
     **/
    public Ice.ObjectPrx findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     *
     **/
    public Ice.ObjectPrx findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, java.util.Map<String, String> context);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, java.util.Map<String, String> context);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, Ice.Callback cb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, Callback_Query_findObjectByTypeOnLeastLoadedNode cb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, java.util.Map<String, String> context, Callback_Query_findObjectByTypeOnLeastLoadedNode cb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type,
                                                                   LoadSample sample,
                                                                   IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type,
                                                                   LoadSample sample,
                                                                   IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type,
                                                                   LoadSample sample,
                                                                   java.util.Map<String, String> context,
                                                                   IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param type The object type.
     *
     * @param sample The sampling interval.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectByTypeOnLeastLoadedNode(String type,
                                                                   LoadSample sample,
                                                                   java.util.Map<String, String> context,
                                                                   IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     *
     * @param result The asynchronous result object.
     * @return The proxy or null, if no such object has been found.
     *
     **/
    public Ice.ObjectPrx end_findObjectByTypeOnLeastLoadedNode(Ice.AsyncResult result);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     *
     **/
    public Ice.ObjectPrx[] findAllObjectsByType(String type);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     *
     **/
    public Ice.ObjectPrx[] findAllObjectsByType(String type, java.util.Map<String, String> context);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type, java.util.Map<String, String> context);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type, Ice.Callback cb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type, Callback_Query_findAllObjectsByType cb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type, java.util.Map<String, String> context, Callback_Query_findAllObjectsByType cb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllObjectsByType(String type,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find all the well-known objects with the given type.
     *
     * @param result The asynchronous result object.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     *
     **/
    public Ice.ObjectPrx[] end_findAllObjectsByType(Ice.AsyncResult result);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     *
     **/
    public Ice.ObjectPrx[] findAllReplicas(Ice.ObjectPrx proxy);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     *
     **/
    public Ice.ObjectPrx[] findAllReplicas(Ice.ObjectPrx proxy, java.util.Map<String, String> context);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy, java.util.Map<String, String> context);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy, Ice.Callback cb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy, Callback_Query_findAllReplicas cb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy, java.util.Map<String, String> context, Callback_Query_findAllReplicas cb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param proxy The object proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAllReplicas(Ice.ObjectPrx proxy,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     *
     * @param result The asynchronous result object.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     *
     **/
    public Ice.ObjectPrx[] end_findAllReplicas(Ice.AsyncResult result);
}
