// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * An enumeration representing the state of the server.
 *
 **/
public enum ServerState implements java.io.Serializable
{
    /**
     * The server is not running.
     *
     **/
    Inactive(0),

    /**
     * The server is being activated and will change to the active
     * state when the registered server object adapters are activated
     * or to the activation timed out state if the activation timeout
     * expires.
     *
     **/
    Activating(1),

    /**
     * The activation timed out state indicates that the server
     * activation timed out.
     *
     **/
    ActivationTimedOut(2),

    /**
     * The server is running.
     *
     **/
    Active(3),

    /**
     * The server is being deactivated.
     *
     **/
    Deactivating(4),

    /**
     * The server is being destroyed.
     *
     **/
    Destroying(5),

    /**
     * The server is destroyed.
     *
     **/
    Destroyed(6);

    public int value()
    {
        return _value;
    }

    public static ServerState valueOf(int v)
    {
        switch(v)
        {
        case 0:
            return Inactive;
        case 1:
            return Activating;
        case 2:
            return ActivationTimedOut;
        case 3:
            return Active;
        case 4:
            return Deactivating;
        case 5:
            return Destroying;
        case 6:
            return Destroyed;
        }
        return null;
    }

    private ServerState(int v)
    {
        _value = v;
    }

    public void ice_write(Ice.OutputStream ostr)
    {
        ostr.writeEnum(_value, 6);
    }

    public static void ice_write(Ice.OutputStream ostr, ServerState v)
    {
        if(v == null)
        {
            ostr.writeEnum(IceGrid.ServerState.Inactive.value(), 6);
        }
        else
        {
            ostr.writeEnum(v.value(), 6);
        }
    }

    public static ServerState ice_read(Ice.InputStream istr)
    {
        int v = istr.readEnum(6);
        return validate(v);
    }

    private static ServerState validate(int v)
    {
        final ServerState e = valueOf(v);
        if(e == null)
        {
            throw new Ice.MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }

    private final int _value;
}
