/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.Instance;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.RetryTask;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class RetryQueue {
    private Instance _instance;
    private HashSet<RetryTask> _requests = new HashSet();

    RetryQueue(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(ProxyOutgoingAsyncBase outAsync, int interval) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        RetryTask task = new RetryTask(this._instance, this, outAsync);
        outAsync.cancelable(task);
        task.setFuture(this._instance.timer().schedule(task, (long)interval, TimeUnit.MILLISECONDS));
        this._requests.add(task);
    }

    public synchronized void destroy() {
        if (this._instance == null) {
            return;
        }
        HashSet<RetryTask> keep = new HashSet<RetryTask>();
        for (RetryTask task : this._requests) {
            if (task.destroy()) continue;
            keep.add(task);
        }
        this._requests = keep;
        this._instance = null;
        boolean interrupted = false;
        while (!this._requests.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized boolean remove(RetryTask task) {
        boolean removed = this._requests.remove(task);
        if (this._instance == null && this._requests.isEmpty()) {
            this.notify();
        }
        return removed;
    }
}

