/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;

public abstract class ScriptDocValues<T>
extends AbstractList<T> {
    public abstract void setNextDocId(int var1) throws IOException;

    public final List<T> getValues() {
        return this;
    }

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final T set(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    public static final class BytesRefs
    extends BinaryScriptDocValues<BytesRef> {
        public BytesRefs(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        public BytesRef get(int index) {
            return this.values[index].toBytesRef();
        }

        public BytesRef getValue() {
            return this.count == 0 ? new BytesRef() : this.get(0);
        }
    }

    public static final class Strings
    extends BinaryScriptDocValues<String> {
        public Strings(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        public String get(int index) {
            return this.values[index].get().utf8ToString();
        }

        public String getValue() {
            return this.count == 0 ? null : this.get(0);
        }
    }

    static abstract class BinaryScriptDocValues<T>
    extends ScriptDocValues<T> {
        private final SortedBinaryDocValues in;
        protected BytesRefBuilder[] values = new BytesRefBuilder[0];
        protected int count;

        BinaryScriptDocValues(SortedBinaryDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i].copyBytes(this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new BytesRefBuilder();
                }
            }
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Booleans
    extends ScriptDocValues<Boolean> {
        private final SortedNumericDocValues in;
        private boolean[] values = new boolean[0];
        private int count;

        public Booleans(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue() == 1L;
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = Booleans.grow(this.values, this.count);
        }

        public boolean getValue() {
            return this.count != 0 && this.values[0];
        }

        @Override
        public Boolean get(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        private static boolean[] grow(boolean[] array, int minSize) {
            assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
            if (array.length < minSize) {
                return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 1));
            }
            return array;
        }
    }

    public static final class GeoPoints
    extends ScriptDocValues<GeoPoint> {
        private final MultiGeoPointValues in;
        private GeoPoint[] values = new GeoPoint[0];
        private int count;

        public GeoPoints(MultiGeoPointValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    GeoPoint point = this.in.nextValue();
                    this.values[i] = new GeoPoint(point.lat(), point.lon());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new GeoPoint();
                }
            }
        }

        public GeoPoint getValue() {
            if (this.count == 0) {
                return null;
            }
            return this.values[0];
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            List points = this.getValues();
            double[] lats = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lats[i] = ((GeoPoint)points.get(i)).lat();
            }
            return lats;
        }

        public double[] getLons() {
            List points = this.getValues();
            double[] lons = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lons[i] = ((GeoPoint)points.get(i)).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public GeoPoint get(int index) {
            GeoPoint point = this.values[index];
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.count;
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), GeoHashUtils.decodeLatitude(geohash), GeoHashUtils.decodeLongitude(geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }
    }

    public static final class Doubles
    extends ScriptDocValues<Double> {
        private final SortedNumericDoubleValues in;
        private double[] values = new double[0];
        private int count;

        public Doubles(SortedNumericDoubleValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow(this.values, this.count);
        }

        public SortedNumericDoubleValues getInternalValues() {
            return this.in;
        }

        public double getValue() {
            if (this.count == 0) {
                return 0.0;
            }
            return this.values[0];
        }

        @Override
        public Double get(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Dates
    extends ScriptDocValues<ReadableDateTime> {
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(ESLoggerFactory.getLogger(Dates.class));
        private static final ReadableDateTime EPOCH = new DateTime(0L, DateTimeZone.UTC);
        private final SortedNumericDocValues in;
        private final Consumer<String> deprecationCallback;
        private MutableDateTime[] dates;
        private int count;

        public Dates(SortedNumericDocValues in) {
            this(in, x$0 -> deprecationLogger.deprecated((String)x$0, new Object[0]));
        }

        Dates(SortedNumericDocValues in, Consumer<String> deprecationCallback) {
            this.in = in;
            this.deprecationCallback = deprecationCallback;
        }

        public ReadableDateTime getValue() {
            if (this.count == 0) {
                return EPOCH;
            }
            return this.get(0);
        }

        @Deprecated
        public ReadableDateTime getDate() {
            this.deprecated("getDate is no longer necessary on date fields as the value is now a date.");
            return this.getValue();
        }

        @Deprecated
        public List<ReadableDateTime> getDates() {
            this.deprecated("getDates is no longer necessary on date fields as the values are now dates.");
            return this;
        }

        @Override
        public ReadableDateTime get(int index) {
            if (index >= this.count) {
                throw new IndexOutOfBoundsException("attempted to fetch the [" + index + "] date when there are only [" + this.count + "] dates.");
            }
            return this.dates[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.count = this.in.advanceExact(docId) ? this.in.docValueCount() : 0;
            this.refreshArray();
        }

        void refreshArray() throws IOException {
            if (this.count == 0) {
                return;
            }
            if (this.dates == null) {
                this.dates = new MutableDateTime[this.count];
                for (int i = 0; i < this.dates.length; ++i) {
                    this.dates[i] = new MutableDateTime(this.in.nextValue(), DateTimeZone.UTC);
                }
                return;
            }
            if (this.count > this.dates.length) {
                int i;
                MutableDateTime[] backup = this.dates;
                this.dates = new MutableDateTime[this.count];
                System.arraycopy(backup, 0, this.dates, 0, backup.length);
                for (i = 0; i < backup.length; ++i) {
                    this.dates[i].setMillis(this.in.nextValue());
                }
                for (i = backup.length; i < this.dates.length; ++i) {
                    this.dates[i] = new MutableDateTime(this.in.nextValue(), DateTimeZone.UTC);
                }
                return;
            }
            for (int i = 0; i < this.count; ++i) {
                this.dates[i] = new MutableDateTime(this.in.nextValue(), DateTimeZone.UTC);
            }
        }

        private void deprecated(final String message) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    deprecationCallback.accept(message);
                    return null;
                }
            });
        }
    }

    public static final class Longs
    extends ScriptDocValues<Long> {
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(ESLoggerFactory.getLogger(Longs.class));
        private final SortedNumericDocValues in;
        private final Consumer<String> deprecationCallback;
        private long[] values = new long[0];
        private int count;
        private Dates dates;
        private int docId = -1;

        public Longs(SortedNumericDocValues in) {
            this(in, x$0 -> deprecationLogger.deprecated((String)x$0, new Object[0]));
        }

        Longs(SortedNumericDocValues in, Consumer<String> deprecationCallback) {
            this.in = in;
            this.deprecationCallback = deprecationCallback;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.docId = docId;
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
            if (this.dates != null) {
                this.dates.setNextDocId(docId);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow(this.values, this.count);
        }

        public SortedNumericDocValues getInternalValues() {
            return this.in;
        }

        public long getValue() {
            if (this.count == 0) {
                return 0L;
            }
            return this.values[0];
        }

        @Deprecated
        public ReadableDateTime getDate() throws IOException {
            this.deprecated("getDate on numeric fields is deprecated. Use a date field to get dates.");
            if (this.dates == null) {
                this.dates = new Dates(this.in);
                this.dates.setNextDocId(this.docId);
            }
            return this.dates.getValue();
        }

        @Deprecated
        public List<ReadableDateTime> getDates() throws IOException {
            this.deprecated("getDates on numeric fields is deprecated. Use a date field to get dates.");
            if (this.dates == null) {
                this.dates = new Dates(this.in);
                this.dates.setNextDocId(this.docId);
            }
            return this.dates;
        }

        @Override
        public Long get(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        private void deprecated(final String message) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    deprecationCallback.accept(message);
                    return null;
                }
            });
        }
    }
}

