/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

public final class ECapturingFunctionRef
extends AExpression
implements ILambda {
    private final String variable;
    private final String call;
    private FunctionRef ref;
    private Locals.Variable captured;
    private String defPointer;

    public ECapturingFunctionRef(Location location, String variable, String call) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.call = Objects.requireNonNull(call);
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    @Override
    void analyze(Locals locals) {
        this.captured = locals.getVariable(this.location, this.variable);
        if (this.expected == null) {
            this.defPointer = this.captured.clazz == Definition.def.class ? "D" + this.variable + "." + this.call + ",1" : "S" + Definition.ClassToName(this.captured.clazz) + "." + this.call + ",1";
            this.actual = String.class;
        } else {
            this.defPointer = null;
            if (this.captured.clazz != Definition.def.class) {
                try {
                    this.ref = new FunctionRef(locals.getDefinition(), this.expected, Definition.ClassToName(this.captured.clazz), this.call, 1);
                    for (int i = 0; i < this.ref.interfaceMethod.arguments.size(); ++i) {
                        Class<?> from = this.ref.interfaceMethod.arguments.get(i);
                        Class<?> to = this.ref.delegateMethod.arguments.get(i);
                        AnalyzerCaster.getLegalCast(this.location, from, to, false, true);
                    }
                    if (this.ref.interfaceMethod.rtn != Void.TYPE) {
                        AnalyzerCaster.getLegalCast(this.location, this.ref.delegateMethod.rtn, this.ref.interfaceMethod.rtn, false, true);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw this.createError(e);
                }
            }
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.defPointer != null) {
            writer.push(null);
            writer.visitVarInsn(MethodWriter.getType(this.captured.clazz).getOpcode(21), this.captured.getSlot());
        } else if (this.ref == null) {
            writer.visitVarInsn(MethodWriter.getType(this.captured.clazz).getOpcode(21), this.captured.getSlot());
            Type methodType = Type.getMethodType((Type)MethodWriter.getType(this.expected), (Type[])new Type[]{MethodWriter.getType(this.captured.clazz)});
            writer.invokeDefCall(this.call, methodType, 6, Definition.ClassToName(this.expected));
        } else {
            writer.visitVarInsn(MethodWriter.getType(this.captured.clazz).getOpcode(21), this.captured.getSlot());
            writer.invokeDynamic(this.ref.interfaceMethodName, this.ref.factoryDescriptor, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{this.ref.interfaceType, this.ref.delegateClassName, this.ref.delegateInvokeType, this.ref.delegateMethodName, this.ref.delegateType});
        }
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[]{MethodWriter.getType(this.captured.clazz)};
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.variable, this.call);
    }
}

