/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.TimeDifference;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.WholeNumberField;

public abstract class DistanceTimeLimitFunction
extends GenericFunction {
    protected JDialog _dialog = null;
    private JRadioButton _distLimitRadio = null;
    private JRadioButton _timeLimitRadio = null;
    private JComboBox<String> _distUnitsDropdown = null;
    private WholeNumberField _distanceField = null;
    private WholeNumberField _limitHourField = null;
    private WholeNumberField _limitMinField = null;
    private JButton _okButton = null;
    private JButton _cancelButton = null;

    public DistanceTimeLimitFunction(App app) {
        super(app);
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.enableOkButton();
        boolean bl = this._app.getTrackInfo().getTrack().hasData(Field.TIMESTAMP);
        this._timeLimitRadio.setEnabled(bl);
        if (!bl) {
            this._distLimitRadio.setSelected(true);
        }
        this._cancelButton.requestFocus();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        this._distLimitRadio = new JRadioButton(String.valueOf(I18nManager.getText("dialog.correlate.options.distancelimit")) + ": ");
        this._timeLimitRadio = new JRadioButton(String.valueOf(I18nManager.getText("dialog.correlate.options.timelimit")) + ": ");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._distLimitRadio);
        buttonGroup.add(this._timeLimitRadio);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(Box.createVerticalStrut(8));
        ChangeListener changeListener = new ChangeListener(this){

            public void optionsChanged() {
                this.enableOkButton();
            }
        };
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        this._distLimitRadio.setSelected(true);
        this._distLimitRadio.addItemListener(changeListener);
        jPanel3.add(this._distLimitRadio);
        this._distanceField = new WholeNumberField(3);
        this._distanceField.addKeyListener(changeListener);
        jPanel3.add(this._distanceField);
        String[] stringArray = new String[]{I18nManager.getText("units.kilometres"), I18nManager.getText("units.metres"), I18nManager.getText("units.miles")};
        this._distUnitsDropdown = new JComboBox<String>(stringArray);
        this._distUnitsDropdown.addItemListener(changeListener);
        jPanel3.add(this._distUnitsDropdown);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        this._timeLimitRadio.addItemListener(changeListener);
        jPanel4.add(this._timeLimitRadio);
        this._limitHourField = new WholeNumberField(2);
        this._limitHourField.addKeyListener(changeListener);
        jPanel4.add(this._limitHourField);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.hours")));
        this._limitMinField = new WholeNumberField(3);
        this._limitMinField.addKeyListener(changeListener);
        jPanel4.add(this._limitMinField);
        jPanel4.add(new JLabel(I18nManager.getText("units.minutes")));
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DistanceTimeLimitFunction.this.performFunction();
            }
        });
        jPanel5.add(this._okButton);
        this._cancelButton = new JButton(I18nManager.getText("button.cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DistanceTimeLimitFunction.this._dialog.dispose();
            }
        });
        this._cancelButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DistanceTimeLimitFunction.this._dialog.dispose();
                }
            }
        });
        jPanel5.add(this._cancelButton);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void enableOkButton() {
        boolean bl = false;
        if (this._distLimitRadio.isSelected()) {
            bl = this._distanceField.getValue() > 0;
        } else if (this._timeLimitRadio.isSelected()) {
            bl = this._limitHourField.getValue() > 0 || this._limitMinField.getValue() > 0;
        }
        this._okButton.setEnabled(bl);
        this._distanceField.setEnabled(this._distLimitRadio.isSelected());
        this._distUnitsDropdown.setEnabled(this._distLimitRadio.isSelected());
        this._limitHourField.setEnabled(this._timeLimitRadio.isSelected());
        this._limitMinField.setEnabled(this._timeLimitRadio.isSelected());
    }

    protected int getTimeLimitInSeconds() {
        int n;
        if (this._timeLimitRadio.isSelected() && (this._limitHourField.getValue() > 0 || this._limitMinField.getValue() > 0) && (n = this._limitHourField.getValue() * 60 * 60 + this._limitMinField.getValue() * 60) > 0) {
            return n;
        }
        return 0;
    }

    protected double getDistanceLimitRadians() {
        if (this._distLimitRadio.isSelected() && this._distanceField.getValue() > 0) {
            Unit[] unitArray = new Unit[]{UnitSetLibrary.UNITS_KILOMETRES, UnitSetLibrary.UNITS_METRES, UnitSetLibrary.UNITS_MILES};
            Unit unit = unitArray[this._distUnitsDropdown.getSelectedIndex()];
            double d = Distance.convertDistanceToRadians(this._distanceField.getValue(), unit);
            return d;
        }
        return 0.0;
    }

    protected abstract void performFunction();

    protected String createLimitDescription(int n) {
        if (this._distLimitRadio.isSelected() && this._distanceField.getValue() > 0) {
            int n2 = n * this._distanceField.getValue();
            String[] stringArray = new String[]{"kilometres", "metres", "miles"};
            String string = "units." + stringArray[this._distUnitsDropdown.getSelectedIndex()] + ".short";
            return n2 + " " + I18nManager.getText(string);
        }
        if (this._timeLimitRadio.isSelected()) {
            long l = (long)this.getTimeLimitInSeconds() * (long)n;
            return new TimeDifference(l).getDescription();
        }
        return null;
    }

    private abstract class ChangeListener
    extends KeyAdapter
    implements ItemListener {
        private ChangeListener() {
        }

        public abstract void optionsChanged();

        public void itemStateChanged(ItemEvent itemEvent) {
            this.optionsChanged();
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.optionsChanged();
        }
    }
}

