/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jnr.posix.util.Platform;
import org.jruby.CompatVersion;
import org.jruby.Profile;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.util.ClassesLoader;
import org.jruby.util.ClasspathLauncher;
import org.jruby.util.FileResource;
import org.jruby.util.InputStreamMarkCursor;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.Loader;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.StringSupport;
import org.jruby.util.UriLikePathHelper;
import org.jruby.util.cli.ArgumentProcessor;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class RubyInstanceConfig {
    private static final Pattern RUBY_SHEBANG = Pattern.compile("#!.*ruby.*");
    private final List<String> extraLoadPaths = new LinkedList<String>();
    private final List<String> extraGemPaths = new LinkedList<String>();
    private final List<Loader> extraLoaders = new LinkedList<Loader>();
    private final boolean isSecurityRestricted;
    private boolean xFlag = Options.CLI_STRIP_HEADER.load();
    private boolean hasShebangLine;
    private InputStream input = System.in;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private Profile profile = Profile.DEFAULT;
    private boolean objectSpaceEnabled = Options.OBJECTSPACE_ENABLED.load();
    private boolean siphashEnabled = Options.SIPHASH_ENABLED.load();
    private CompileMode compileMode = CompileMode.OFF;
    private boolean runRubyInProcess = true;
    private String currentDirectory;
    private Map<String, String> environment;
    private String[] argv = new String[0];
    private final boolean jitLogging;
    private final boolean jitDumping;
    private final boolean jitLoggingVerbose;
    private int jitLogEvery;
    private int jitThreshold;
    private int jitMax;
    private int jitMaxSize;
    private String internalEncoding = Options.CLI_ENCODING_INTERNAL.load();
    private String externalEncoding = Options.CLI_ENCODING_EXTERNAL.load();
    private String sourceEncoding = Options.CLI_ENCODING_SOURCE.load();
    private ProfilingMode profilingMode = Options.CLI_PROFILING_MODE.load();
    private ProfileOutput profileOutput = new ProfileOutput(System.err);
    private String profilingService = Options.CLI_PROFILING_SERVICE.load();
    private ClassLoader loader = RubyInstanceConfig.defaultClassLoader();
    private List<String> loadPaths = new ArrayList<String>();
    private Set<String> excludedMethods = new HashSet<String>();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private String scriptFileName = null;
    private Collection<String> requiredLibraries = new LinkedHashSet<String>();
    private boolean argvGlobalsOn = false;
    private boolean assumeLoop = Options.CLI_ASSUME_LOOP.load();
    private boolean assumePrinting = Options.CLI_ASSUME_PRINT.load();
    private Map<String, String> optionGlobals = new HashMap<String, String>();
    private boolean processLineEnds = Options.CLI_PROCESS_LINE_ENDS.load();
    private boolean split = Options.CLI_AUTOSPLIT.load();
    private Verbosity verbosity = Options.CLI_WARNING_LEVEL.load();
    private boolean debug = Options.CLI_DEBUG.load();
    private boolean showVersion = Options.CLI_VERSION.load();
    private boolean showBytecode = Options.CLI_BYTECODE.load();
    private boolean showCopyright = Options.CLI_COPYRIGHT.load();
    private boolean shouldRunInterpreter = true;
    private boolean shouldPrintUsage = Options.CLI_HELP.load();
    private boolean shouldPrintProperties = Options.CLI_PROPERTIES.load();
    private boolean dumpConfig = false;
    private KCode kcode = Options.CLI_KCODE.load();
    private String recordSeparator = Options.CLI_RECORD_SEPARATOR.load();
    private boolean shouldCheckSyntax = Options.CLI_CHECK_SYNTAX.load();
    private String inputFieldSeparator = Options.CLI_AUTOSPLIT_SEPARATOR.load();
    private boolean managementEnabled = false;
    private String inPlaceBackupExtension = Options.CLI_BACKUP_EXTENSION.load();
    private boolean parserDebug = false;
    private String threadDumpSignal = null;
    private boolean hardExit = false;
    private boolean disableGems = Options.CLI_RUBYGEMS_ENABLE.load() == false;
    private boolean disableDidYouMean = Options.CLI_DID_YOU_MEAN_ENABLE.load() == false;
    private boolean disableRUBYOPT = Options.CLI_RUBYOPT_ENABLE.load() == false;
    private boolean updateNativeENVEnabled = true;
    private boolean kernelGsubDefined;
    private boolean hasScriptArgv = false;
    private boolean frozenStringLiteral = false;
    private boolean debuggingFrozenStringLiteral = false;
    private String jrubyHome;
    private boolean _nativeEnabled = NATIVE_ENABLED;
    private boolean _classloaderDelegate = Options.CLASSLOADER_DELEGATE.load();
    private TraceType traceType = TraceType.traceTypeFor(Options.BACKTRACE_STYLE.load());
    private boolean backtraceMask = Options.BACKTRACE_MASK.load();
    private boolean backtraceColor = Options.BACKTRACE_COLOR.load();
    private LoadServiceCreator creator = LoadServiceCreator.DEFAULT;
    private boolean globalRequireLock = Options.GLOBAL_REQUIRE_LOCK.load();
    private boolean jitBackground = Options.JIT_BACKGROUND.load();
    private boolean loadGemfile = Options.CLI_LOAD_GEMFILE.load();
    private int profileMaxMethods = Options.PROFILE_MAX_METHODS.load();
    private boolean allowUppercasePackageNames = Options.JI_UPPER_CASE_PACKAGE_NAME_ALLOWED.load();
    private boolean forceStdin = false;
    public static final int JAVA_VERSION = RubyInstanceConfig.initGlobalJavaVersion();
    public static final int CHAINED_COMPILE_LINE_COUNT = Options.COMPILE_CHAINSIZE.load();
    public static final boolean PEEPHOLE_OPTZ = Options.COMPILE_PEEPHOLE.load();
    public static boolean NOGUARDS_COMPILE_ENABLED = Options.COMPILE_NOGUARDS.load();
    public static boolean FASTEST_COMPILE_ENABLED = Options.COMPILE_FASTEST.load();
    public static boolean FASTOPS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || Options.COMPILE_FASTOPS.load() != false;
    public static boolean THREADLESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || Options.COMPILE_THREADLESS.load() != false;
    public static boolean FASTSEND_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || Options.COMPILE_FASTSEND.load() != false;
    public static boolean FAST_MULTIPLE_ASSIGNMENT = Options.COMPILE_FASTMASGN.load();
    public static final boolean POOLING_ENABLED = false;
    public static final int POOL_MAX = Options.THREADPOOL_MAX.load();
    public static final int POOL_MIN = Options.THREADPOOL_MIN.load();
    public static final int POOL_TTL = Options.THREADPOOL_TTL.load();
    public static final int FIBER_POOL_TTL = Options.FIBER_THREADPOOL_TTL.load();
    public static final boolean NATIVE_NET_PROTOCOL = Options.NATIVE_NET_PROTOCOL.load();
    public static boolean FULL_TRACE_ENABLED = Options.DEBUG_FULLTRACE.load();
    public static final String COMPILE_EXCLUDE = Options.JIT_EXCLUDE.load();
    public static final boolean NATIVE_ENABLED = Options.NATIVE_ENABLED.load();
    @Deprecated
    public static final boolean CEXT_ENABLED = false;
    public static final boolean REIFY_RUBY_CLASSES = Options.REIFY_CLASSES.load();
    public static final boolean REIFY_LOG_ERRORS = Options.REIFY_LOGERRORS.load();
    public static final boolean USE_GENERATED_HANDLES = Options.JAVA_HANDLES.load();
    public static final boolean DEBUG_LOAD_SERVICE = Options.DEBUG_LOADSERVICE.load();
    public static final boolean DEBUG_LOAD_TIMINGS = Options.DEBUG_LOADSERVICE_TIMING.load();
    public static final boolean DEBUG_LAUNCHING = Options.DEBUG_LAUNCH.load();
    public static final boolean DEBUG_SCRIPT_RESOLUTION = Options.DEBUG_SCRIPTRESOLUTION.load();
    public static final boolean DEBUG_PARSER = Options.DEBUG_PARSER.load();
    public static final boolean JUMPS_HAVE_BACKTRACE = Options.JUMP_BACKTRACE.load();
    @Deprecated
    public static final boolean JIT_CACHE_ENABLED = Options.JIT_CACHE.load();
    public static final boolean REFLECTED_HANDLES = Options.REFLECTED_HANDLES.load();
    public static final boolean NO_UNWRAP_PROCESS_STREAMS = Options.PROCESS_NOUNWRAP.load();
    public static final boolean INTERFACES_USE_PROXY = Options.INTERFACES_USEPROXY.load();
    public static final boolean JIT_LOADING_DEBUG = Options.JIT_DEBUG.load();
    public static final boolean CAN_SET_ACCESSIBLE = Options.JI_SETACCESSIBLE.load();
    public static final boolean LOG_EXCEPTIONS = Options.LOG_EXCEPTIONS.load();
    public static final boolean LOG_BACKTRACES = Options.LOG_BACKTRACES.load();
    public static final boolean LOG_CALLERS = Options.LOG_CALLERS.load();
    public static final boolean LOG_WARNINGS = Options.LOG_WARNINGS.load();
    public static final boolean ERRNO_BACKTRACE = Options.ERRNO_BACKTRACE.load();
    public static final boolean STOPITERATION_BACKTRACE = Options.STOPITERATION_BACKTRACE.load();
    public static boolean IR_DEBUG = Options.IR_DEBUG.load();
    public static String IR_DEBUG_IGV = Options.IR_DEBUG_IGV.load();
    public static boolean IR_PROFILE = Options.IR_PROFILE.load();
    public static boolean IR_COMPILER_DEBUG = Options.IR_COMPILER_DEBUG.load();
    public static boolean IR_WRITING = Options.IR_WRITING.load();
    public static boolean IR_READING = Options.IR_READING.load();
    public static boolean IR_READING_DEBUG = Options.IR_READING_DEBUG.load();
    public static boolean IR_WRITING_DEBUG = Options.IR_WRITING_DEBUG.load();
    public static boolean IR_VISUALIZER = Options.IR_VISUALIZER.load();
    public static boolean IR_UNBOXING = Options.IR_UNBOXING.load();
    public static String IR_COMPILER_PASSES = Options.IR_COMPILER_PASSES.load();
    public static String IR_JIT_PASSES = Options.IR_JIT_PASSES.load();
    public static String IR_INLINE_COMPILER_PASSES = Options.IR_INLINE_COMPILER_PASSES.load();
    public static boolean RECORD_LEXICAL_HIERARCHY = Options.RECORD_LEXICAL_HIERARCHY.load();
    public static final boolean COROUTINE_FIBERS = Options.FIBER_COROUTINES.load();
    public static final boolean CONSISTENT_HASHING_ENABLED = Options.CONSISTENT_HASHING.load();
    private static volatile boolean loadedNativeExtensions = false;
    @Deprecated
    public static final int JIT_MAX_METHODS_LIMIT = 4096;
    @Deprecated
    public static final int JIT_MAX_SIZE_LIMIT = 2000;
    @Deprecated
    public static final int JIT_THRESHOLD = 50;
    @Deprecated
    public static final int CHAINED_COMPILE_LINE_COUNT_DEFAULT = 500;
    @Deprecated
    public static final boolean nativeEnabled = NATIVE_ENABLED;
    @Deprecated
    public static final String JIT_CODE_CACHE = "";

    public RubyInstanceConfig() {
        this(Ruby.isSecurityRestricted());
    }

    public RubyInstanceConfig(boolean isSecurityRestricted) {
        this.isSecurityRestricted = isSecurityRestricted;
        String string2 = this.currentDirectory = isSecurityRestricted ? "/" : JRubyFile.getFileProperty("user.dir");
        if (isSecurityRestricted) {
            this.compileMode = CompileMode.OFF;
            this.jitLogging = false;
            this.jitDumping = false;
            this.jitLoggingVerbose = false;
            this.jitLogEvery = 0;
            this.jitThreshold = -1;
            this.jitMax = 0;
            this.jitMaxSize = -1;
            this.managementEnabled = false;
        } else {
            if (COMPILE_EXCLUDE != null) {
                this.excludedMethods.addAll(StringSupport.split(COMPILE_EXCLUDE, ','));
            }
            this.managementEnabled = Options.MANAGEMENT_ENABLED.load();
            this.runRubyInProcess = Options.LAUNCH_INPROC.load();
            this.compileMode = Options.COMPILE_MODE.load();
            this.jitLogging = Options.JIT_LOGGING.load();
            this.jitDumping = Options.JIT_DUMPING.load();
            this.jitLoggingVerbose = Options.JIT_LOGGING_VERBOSE.load();
            this.jitLogEvery = Options.JIT_LOGEVERY.load();
            this.jitThreshold = Options.JIT_THRESHOLD.load();
            this.jitMax = Options.JIT_MAX.load();
            this.jitMaxSize = Options.JIT_MAXSIZE.load();
        }
        this.threadDumpSignal = Options.THREAD_DUMP_SIGNAL.load();
        this.initEnvironment();
    }

    public RubyInstanceConfig(RubyInstanceConfig parentConfig) {
        this.isSecurityRestricted = parentConfig.isSecurityRestricted;
        this.currentDirectory = parentConfig.getCurrentDirectory();
        this.compileMode = parentConfig.getCompileMode();
        this.jitLogging = parentConfig.jitLogging;
        this.jitDumping = parentConfig.jitDumping;
        this.jitLoggingVerbose = parentConfig.jitLoggingVerbose;
        this.jitLogEvery = parentConfig.jitLogEvery;
        this.jitThreshold = parentConfig.jitThreshold;
        this.jitMax = parentConfig.jitMax;
        this.jitMaxSize = parentConfig.jitMaxSize;
        this.managementEnabled = parentConfig.managementEnabled;
        this.runRubyInProcess = parentConfig.runRubyInProcess;
        this.excludedMethods = parentConfig.excludedMethods;
        this.threadDumpSignal = parentConfig.threadDumpSignal;
        this.updateNativeENVEnabled = parentConfig.updateNativeENVEnabled;
        this.profilingService = parentConfig.profilingService;
        this.profilingMode = parentConfig.profilingMode;
        this.initEnvironment();
    }

    private void initEnvironment() {
        this.environment = new HashMap<String, String>();
        try {
            this.environment.putAll(System.getenv());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setupEnvironment(this.getJRubyHome());
    }

    public RubyInstanceConfig(InputStream in, PrintStream out, PrintStream err) {
        this();
        this.setInput(in);
        this.setOutput(out);
        this.setError(err);
    }

    public LoadService createLoadService(Ruby runtime2) {
        return this.creator.create(runtime2);
    }

    public void processArguments(String[] arguments) {
        new ArgumentProcessor(arguments, this).processArguments();
        this.tryProcessArgumentsWithRubyopts();
    }

    public void tryProcessArgumentsWithRubyopts() {
        try {
            this.processArgumentsWithRubyopts();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void processArgumentsWithRubyopts() {
        String rubyoptObj = this.environment.get("RUBYOPT");
        if (rubyoptObj == null) {
            return;
        }
        String rubyopt = rubyoptObj.toString().trim();
        if (rubyopt.length() == 0) {
            return;
        }
        String[] rubyoptArgs = rubyopt.split("\\s+");
        if (rubyoptArgs.length != 0) {
            new ArgumentProcessor(rubyoptArgs, false, true, true, this).processArguments();
        }
    }

    private boolean isShebang(InputStreamMarkCursor cursor) throws IOException {
        if (cursor.read() == 35) {
            int c = cursor.read();
            if (c == 33) {
                cursor.endPoint(-2);
                return true;
            }
            if (c == 10) {
                cursor.rewind();
            }
        } else {
            cursor.rewind();
        }
        return false;
    }

    private boolean skipToNextLine(InputStreamMarkCursor cursor) throws IOException {
        int c = cursor.read();
        do {
            if (c != 10) continue;
            return true;
        } while ((c = cursor.read()) != -1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eatToShebang(InputStream in) {
        InputStreamMarkCursor cursor = new InputStreamMarkCursor(in, 8192);
        try {
            do {
                if (!this.isShebang(cursor)) continue;
                break;
            } while (this.skipToNextLine(cursor));
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                cursor.finish();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] parseShebangOptions(InputStream in) {
        String[] result2 = StringSupport.EMPTY_STRING_ARRAY;
        if (in == null) {
            return result2;
        }
        if (this.isXFlag()) {
            this.eatToShebang(in);
        }
        try {
            InputStreamMarkCursor cursor = new InputStreamMarkCursor(in, 8192);
            try {
                if (!this.isShebang(cursor)) {
                    String[] stringArray = result2;
                    return stringArray;
                }
            }
            finally {
                cursor.finish();
            }
            in.mark(8192);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "iso-8859-1"), 8192);
            String firstLine = reader.readLine();
            boolean usesEnv = false;
            if (firstLine.length() > 2 && firstLine.charAt(0) == '#' && firstLine.charAt(1) == '!') {
                int i2;
                String[] options2 = firstLine.substring(2).split("\\s+");
                for (i2 = 0; i2 < options2.length; ++i2) {
                    String basename2;
                    if (i2 == 0 && options2[i2].endsWith("/env")) {
                        usesEnv = true;
                        continue;
                    }
                    if (!(usesEnv && options2[i2].indexOf(61) > 0 || usesEnv && options2[i2].startsWith("-") || (basename2 = new File(options2[i2]).getName()).indexOf("ruby") <= 0)) break;
                }
                this.setHasShebangLine(true);
                System.arraycopy(options2, i2, result2, 0, options2.length - i2);
            } else {
                this.setHasShebangLine(false);
            }
        }
        catch (Exception exception2) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
        return result2;
    }

    protected static boolean isRubyShebangLine(String line) {
        return RUBY_SHEBANG.matcher(line).matches();
    }

    private String calculateJRubyHome() {
        String newJRubyHome = null;
        if (!this.isSecurityRestricted) {
            newJRubyHome = SafePropertyAccessor.getProperty("jruby.home");
        }
        if (newJRubyHome == null && this.getLoader().getResource("META-INF/jruby.home/.jrubydir") != null) {
            newJRubyHome = "uri:classloader://META-INF/jruby.home";
        }
        if (newJRubyHome != null) {
            newJRubyHome = RubyInstanceConfig.verifyHome(newJRubyHome, this.error);
        } else {
            try {
                newJRubyHome = SafePropertyAccessor.getenv("JRUBY_HOME");
            }
            catch (Exception exception2) {
                // empty catch block
            }
            newJRubyHome = newJRubyHome != null ? RubyInstanceConfig.verifyHome(newJRubyHome, this.error) : SafePropertyAccessor.getProperty("java.io.tmpdir");
        }
        if (Platform.IS_WINDOWS && !RubyFile.PROTOCOL_PATTERN.matcher(newJRubyHome).matches()) {
            try {
                newJRubyHome = new File(newJRubyHome).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return newJRubyHome == null ? null : JRubyFile.normalizeSeps(newJRubyHome);
    }

    private static String verifyHome(String home2, PrintStream error2) {
        if ("uri:classloader://META-INF/jruby.home".equals(home2) || "uri:classloader:/META-INF/jruby.home".equals(home2)) {
            return home2;
        }
        if (home2.equals(".")) {
            home2 = SafePropertyAccessor.getProperty("user.dir");
        } else if (home2.startsWith("cp:")) {
            home2 = home2.substring(3);
        }
        if (home2.startsWith("jar:") || home2.startsWith("file:") && home2.contains(".jar!/") || home2.startsWith("classpath:") || home2.startsWith("uri:")) {
            error2.println("Warning: JRuby home with uri like paths may not have full functionality - use at your own risk");
        } else if (!home2.contains(".jar!/") && !home2.startsWith("uri:")) {
            File file2 = new File(home2);
            if (!file2.exists()) {
                String tmpdir = SafePropertyAccessor.getProperty("java.io.tmpdir");
                error2.println("Warning: JRuby home \"" + file2 + "\" does not exist, using " + tmpdir);
                return tmpdir;
            }
            if (!file2.isAbsolute()) {
                home2 = file2.getAbsolutePath();
            }
        }
        return home2;
    }

    public boolean isUpdateNativeENVEnabled() {
        return this.updateNativeENVEnabled;
    }

    public void setUpdateNativeENVEnabled(boolean updateNativeENVEnabled) {
        this.updateNativeENVEnabled = updateNativeENVEnabled;
    }

    public byte[] inlineScript() {
        return this.inlineScript.toString().getBytes();
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isForceStdin() || this.getScriptFileName() == null) {
                if (this.isShowVersion()) {
                    return null;
                }
                return this.getInput();
            }
            String script = this.getScriptFileName();
            FileResource resource2 = JRubyFile.createRestrictedResource(this.getCurrentDirectory(), this.getScriptFileName());
            if (resource2 != null && resource2.exists()) {
                if (resource2.canRead() && !resource2.isDirectory()) {
                    if (this.isXFlag()) {
                        return RubyInstanceConfig.findScript(resource2.inputStream());
                    }
                    return resource2.inputStream();
                }
                throw new FileNotFoundException(script + " (Not a file)");
            }
            throw new FileNotFoundException(script + " (No such file or directory)");
        }
        catch (IOException e) {
            throw new MainExitException(1, "Error opening script file: " + e.getMessage());
        }
    }

    private static InputStream findScript(InputStream is) throws IOException {
        StringBuilder buf = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String currentLine = br.readLine();
        while (currentLine != null && !RubyInstanceConfig.isRubyShebangLine(currentLine)) {
            currentLine = br.readLine();
        }
        buf.append(currentLine);
        buf.append("\n");
        do {
            if ((currentLine = br.readLine()) == null) continue;
            buf.append(currentLine);
            buf.append("\n");
        } while (currentLine != null && !currentLine.contains("__END__") && !currentLine.contains("\u0016"));
        return new BufferedInputStream(new ByteArrayInputStream(buf.toString().getBytes()), 8192);
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.isForceStdin() || this.getScriptFileName() == null) {
            return "-";
        }
        return this.getScriptFileName();
    }

    public static boolean hasLoadedNativeExtensions() {
        return loadedNativeExtensions;
    }

    public static void setLoadedNativeExtensions(boolean loadedNativeExtensions) {
        RubyInstanceConfig.loadedNativeExtensions = loadedNativeExtensions;
    }

    public LoadServiceCreator getLoadServiceCreator() {
        return this.creator;
    }

    public void setLoadServiceCreator(LoadServiceCreator creator) {
        this.creator = creator;
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            this.jrubyHome = this.calculateJRubyHome();
        }
        return this.jrubyHome;
    }

    public void setJRubyHome(String home2) {
        this.jrubyHome = RubyInstanceConfig.verifyHome(home2, this.error);
        this.setupEnvironment(this.jrubyHome);
    }

    public CompileMode getCompileMode() {
        return this.compileMode;
    }

    public void setCompileMode(CompileMode compileMode) {
        this.compileMode = compileMode;
    }

    public boolean isJitLogging() {
        return this.jitLogging;
    }

    public boolean isJitDumping() {
        return this.jitDumping;
    }

    public boolean isJitLoggingVerbose() {
        return this.jitLoggingVerbose;
    }

    public int getJitLogEvery() {
        return this.jitLogEvery;
    }

    public void setJitLogEvery(int jitLogEvery) {
        this.jitLogEvery = jitLogEvery;
    }

    public int getJitThreshold() {
        return this.jitThreshold;
    }

    public void setJitThreshold(int jitThreshold) {
        this.jitThreshold = jitThreshold;
    }

    public int getJitMax() {
        return this.jitMax;
    }

    public void setJitMax(int jitMax) {
        this.jitMax = jitMax;
    }

    public int getJitMaxSize() {
        return this.jitMaxSize;
    }

    public void setJitMaxSize(int jitMaxSize) {
        this.jitMaxSize = jitMaxSize;
    }

    public boolean isRunRubyInProcess() {
        return this.runRubyInProcess;
    }

    public void setRunRubyInProcess(boolean flag) {
        this.runRubyInProcess = flag;
    }

    public void setInput(InputStream newInput) {
        this.input = newInput;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setOutput(PrintStream newOutput) {
        this.output = newOutput;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setError(PrintStream newError) {
        this.error = newError;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setObjectSpaceEnabled(boolean newObjectSpaceEnabled) {
        this.objectSpaceEnabled = newObjectSpaceEnabled;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setSiphashEnabled(boolean newSiphashEnabled) {
        this.siphashEnabled = newSiphashEnabled;
    }

    public boolean isSiphashEnabled() {
        return this.siphashEnabled;
    }

    public void setEnvironment(Map<String, String> newEnvironment) {
        this.environment = new HashMap<String, String>();
        if (newEnvironment != null) {
            this.environment.putAll(newEnvironment);
        }
        this.setupEnvironment(this.getJRubyHome());
    }

    private void setupEnvironment(String jrubyHome) {
        if (RubyFile.PROTOCOL_PATTERN.matcher(jrubyHome).matches() && !this.environment.containsKey("RUBY")) {
            this.environment.put("RUBY", ClasspathLauncher.jrubyCommand(RubyInstanceConfig.defaultClassLoader()));
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public List<String> getExtraLoadPaths() {
        return this.extraLoadPaths;
    }

    public List<String> getExtraGemPaths() {
        return this.extraGemPaths;
    }

    public List<Loader> getExtraLoaders() {
        return this.extraLoaders;
    }

    public void addLoader(ClassLoader loader) {
        this.addLoader(new ClassesLoader(loader));
    }

    public void addLoader(Loader bundle) {
        UriLikePathHelper helper = new UriLikePathHelper(bundle);
        String uri = helper.getUriLikePath();
        if (uri != null) {
            this.extraLoadPaths.add(uri);
        }
        if ((uri = helper.getUriLikeGemPath()) != null) {
            this.extraGemPaths.add(uri);
        }
        this.extraLoaders.add(bundle);
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void setArgv(String[] argv2) {
        this.argv = argv2;
    }

    public StringBuffer getInlineScript() {
        return this.inlineScript;
    }

    public void setHasInlineScript(boolean hasInlineScript) {
        this.hasScriptArgv = true;
        this.hasInlineScript = hasInlineScript;
    }

    public boolean hasInlineScript() {
        return this.hasInlineScript;
    }

    public Collection<String> getRequiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> getLoadPaths() {
        return this.loadPaths;
    }

    public void setLoadPaths(List<String> loadPaths) {
        this.loadPaths = loadPaths;
    }

    public void setShouldPrintUsage(boolean shouldPrintUsage) {
        this.shouldPrintUsage = shouldPrintUsage;
    }

    public boolean getShouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    public void setShouldPrintProperties(boolean shouldPrintProperties) {
        this.shouldPrintProperties = shouldPrintProperties;
    }

    public boolean getShouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    public boolean isForceStdin() {
        return this.forceStdin;
    }

    public void setForceStdin(boolean forceStdin) {
        this.forceStdin = forceStdin;
    }

    public void setScriptFileName(String scriptFileName) {
        this.hasScriptArgv = true;
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public void setAssumeLoop(boolean assumeLoop) {
        this.assumeLoop = assumeLoop;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public void setAssumePrinting(boolean assumePrinting) {
        this.assumePrinting = assumePrinting;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public void setProcessLineEnds(boolean processLineEnds) {
        this.processLineEnds = processLineEnds;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public void setSplit(boolean split2) {
        this.split = split2;
    }

    public boolean isSplit() {
        return this.split;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public boolean isVerbose() {
        return this.verbosity == Verbosity.TRUE;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isParserDebug() {
        return this.parserDebug;
    }

    public void setParserDebug(boolean parserDebug) {
        this.parserDebug = parserDebug;
    }

    public boolean getParserDebug() {
        return this.parserDebug;
    }

    public void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowBytecode(boolean showBytecode) {
        this.showBytecode = showBytecode;
    }

    public boolean isShowBytecode() {
        return this.showBytecode;
    }

    public void setShowCopyright(boolean showCopyright) {
        this.showCopyright = showCopyright;
    }

    public boolean isShowCopyright() {
        return this.showCopyright;
    }

    public void setShouldRunInterpreter(boolean shouldRunInterpreter) {
        this.shouldRunInterpreter = shouldRunInterpreter;
    }

    public boolean getShouldRunInterpreter() {
        return this.shouldRunInterpreter && (this.hasScriptArgv || !this.showVersion);
    }

    public void setShouldCheckSyntax(boolean shouldSetSyntax) {
        this.shouldCheckSyntax = shouldSetSyntax;
    }

    public boolean getShouldCheckSyntax() {
        return this.shouldCheckSyntax;
    }

    public void setInputFieldSeparator(String inputFieldSeparator) {
        this.inputFieldSeparator = inputFieldSeparator;
    }

    public String getInputFieldSeparator() {
        return this.inputFieldSeparator;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    public void setInternalEncoding(String internalEncoding) {
        this.internalEncoding = internalEncoding;
    }

    public String getInternalEncoding() {
        return this.internalEncoding;
    }

    public void setExternalEncoding(String externalEncoding) {
        this.externalEncoding = externalEncoding;
    }

    public String getExternalEncoding() {
        return this.externalEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public int getSafeLevel() {
        return 0;
    }

    public void setInPlaceBackupExtension(String inPlaceBackupExtension) {
        this.inPlaceBackupExtension = inPlaceBackupExtension;
    }

    public String getInPlaceBackupExtension() {
        return this.inPlaceBackupExtension;
    }

    public Map<String, String> getOptionGlobals() {
        return this.optionGlobals;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public Set<String> getExcludedMethods() {
        return this.excludedMethods;
    }

    public boolean isArgvGlobalsOn() {
        return this.argvGlobalsOn;
    }

    public void setArgvGlobalsOn(boolean argvGlobalsOn) {
        this.argvGlobalsOn = argvGlobalsOn;
    }

    public String getThreadDumpSignal() {
        return this.threadDumpSignal;
    }

    public boolean isHardExit() {
        return this.hardExit;
    }

    public void setHardExit(boolean hardExit) {
        this.hardExit = hardExit;
    }

    public boolean isProfiling() {
        return this.profilingMode != ProfilingMode.OFF;
    }

    public boolean isProfilingEntireRun() {
        return this.profilingMode != ProfilingMode.OFF && this.profilingMode != ProfilingMode.API;
    }

    public void setProfilingMode(ProfilingMode profilingMode) {
        this.profilingMode = profilingMode;
    }

    public ProfilingMode getProfilingMode() {
        return this.profilingMode;
    }

    public void setProfileOutput(ProfileOutput output) {
        this.profileOutput = output;
    }

    public ProfileOutput getProfileOutput() {
        return this.profileOutput;
    }

    public boolean hasShebangLine() {
        return this.hasShebangLine;
    }

    public void setHasShebangLine(boolean hasShebangLine) {
        this.hasShebangLine = hasShebangLine;
    }

    public boolean isDisableGems() {
        return this.disableGems;
    }

    public boolean isDisableDidYouMean() {
        return this.disableDidYouMean;
    }

    public void setDisableRUBYOPT(boolean dr) {
        this.disableRUBYOPT = dr;
    }

    public void setDisableGems(boolean dg) {
        this.disableGems = dg;
    }

    public void setDisableDidYouMean(boolean ddym) {
        this.disableDidYouMean = ddym;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public void setHasScriptArgv(boolean argvRemains) {
        this.hasScriptArgv = argvRemains;
    }

    public boolean getHasScriptArgv() {
        return this.hasScriptArgv;
    }

    public boolean getBacktraceMask() {
        return this.backtraceMask;
    }

    public void setBacktraceMask(boolean backtraceMask) {
        this.backtraceMask = backtraceMask;
    }

    public void setNativeEnabled(boolean b2) {
        this._nativeEnabled = b2;
    }

    public boolean isNativeEnabled() {
        return this._nativeEnabled;
    }

    public void setClassloaderDelegate(boolean b2) {
        this._classloaderDelegate = b2;
    }

    public boolean isClassloaderDelegate() {
        return this._classloaderDelegate;
    }

    public void setXFlag(boolean xFlag) {
        this.xFlag = xFlag;
    }

    public boolean isXFlag() {
        return this.xFlag;
    }

    public boolean getBacktraceColor() {
        return this.backtraceColor;
    }

    public void setBacktraceColor(boolean backtraceColor) {
        this.backtraceColor = backtraceColor;
    }

    public boolean isGlobalRequireLock() {
        return this.globalRequireLock;
    }

    public void setGlobalRequireLock(boolean globalRequireLock) {
        this.globalRequireLock = globalRequireLock;
    }

    public void setJitBackground(boolean jitBackground) {
        this.jitBackground = jitBackground;
    }

    public boolean getJitBackground() {
        return this.jitBackground;
    }

    public void setLoadGemfile(boolean loadGemfile) {
        this.loadGemfile = loadGemfile;
    }

    public boolean getLoadGemfile() {
        return this.loadGemfile;
    }

    public void setProfileMaxMethods(int profileMaxMethods) {
        this.profileMaxMethods = profileMaxMethods;
    }

    public int getProfileMaxMethods() {
        return this.profileMaxMethods;
    }

    public void setKernelGsubDefined(boolean setDefineKernelGsub) {
        this.kernelGsubDefined = setDefineKernelGsub;
    }

    public boolean getKernelGsubDefined() {
        return this.kernelGsubDefined;
    }

    public boolean getAllowUppercasePackageNames() {
        return this.allowUppercasePackageNames;
    }

    public void setAllowUppercasePackageNames(boolean allow) {
        this.allowUppercasePackageNames = allow;
    }

    public String getProfilingService() {
        return this.profilingService;
    }

    public void setProfilingService(String service) {
        this.profilingService = service;
    }

    public boolean isFrozenStringLiteral() {
        return this.frozenStringLiteral;
    }

    public void setFrozenStringLiteral(boolean frozenStringLiteral) {
        this.frozenStringLiteral = frozenStringLiteral;
    }

    public boolean isDebuggingFrozenStringLiteral() {
        return this.debuggingFrozenStringLiteral;
    }

    public void setDebuggingFrozenStringLiteral(boolean debuggingFrozenStringLiteral) {
        this.debuggingFrozenStringLiteral = debuggingFrozenStringLiteral;
    }

    public static ClassLoader defaultClassLoader() {
        ClassLoader loader = RubyInstanceConfig.class.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public ClassLoader getCurrentThreadClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static int initGlobalJavaVersion() {
        String specVersion;
        switch (specVersion = Options.BYTECODE_VERSION.load()) {
            case "1.6": 
            case "1.7": {
                throw new UnsupportedClassVersionError("JRuby requires Java 8 or higher");
            }
            case "1.8": 
            case "8": {
                return 52;
            }
        }
        return 53;
    }

    @Deprecated
    public void setSafeLevel(int safeLevel) {
    }

    @Deprecated
    public String getInPlaceBackupExtention() {
        return this.inPlaceBackupExtension;
    }

    @Deprecated
    public String getBasicUsageHelp() {
        return OutputStrings.getBasicUsageHelp();
    }

    @Deprecated
    public String getExtendedHelp() {
        return OutputStrings.getExtendedHelp();
    }

    @Deprecated
    public String getPropertyHelp() {
        return OutputStrings.getPropertyHelp();
    }

    @Deprecated
    public String getVersionString() {
        return OutputStrings.getVersionString();
    }

    @Deprecated
    public String getCopyrightString() {
        return OutputStrings.getCopyrightString();
    }

    @Deprecated
    public Collection<String> requiredLibraries() {
        return this.requiredLibraries;
    }

    @Deprecated
    public List<String> loadPaths() {
        return this.loadPaths;
    }

    @Deprecated
    public boolean shouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    @Deprecated
    public boolean shouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    @Deprecated
    public Boolean getVerbose() {
        return this.isVerbose();
    }

    @Deprecated
    public boolean shouldRunInterpreter() {
        return this.isShouldRunInterpreter();
    }

    @Deprecated
    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    @Deprecated
    public boolean isxFlag() {
        return this.xFlag;
    }

    @Deprecated
    public boolean isSamplingEnabled() {
        return false;
    }

    @Deprecated
    public void setBenchmarking(boolean benchmarking) {
    }

    @Deprecated
    public boolean isBenchmarking() {
        return false;
    }

    @Deprecated
    public void setCextEnabled(boolean b2) {
    }

    @Deprecated
    public boolean isCextEnabled() {
        return false;
    }

    @Deprecated
    public boolean getIPv4Preferred() {
        return Options.PREFER_IPV4.load();
    }

    @Deprecated
    public CompatVersion getCompatVersion() {
        return CompatVersion.RUBY2_1;
    }

    @Deprecated
    public void setCompatVersion(CompatVersion compatVersion) {
    }

    public static enum CompileMode {
        JIT,
        FORCE,
        OFF;


        public boolean shouldPrecompileCLI() {
            return this == JIT || this == FORCE;
        }

        public boolean shouldJIT() {
            return this == JIT || this == FORCE;
        }

        public boolean shouldPrecompileAll() {
            return this == FORCE;
        }
    }

    public static enum ProfilingMode {
        OFF,
        API,
        FLAT,
        GRAPH,
        HTML,
        JSON,
        SERVICE;

    }

    public static interface LoadServiceCreator {
        public static final LoadServiceCreator DEFAULT = new LoadServiceCreator(){

            @Override
            public LoadService create(Ruby runtime2) {
                return new LoadService(runtime2);
            }
        };

        public LoadService create(Ruby var1);
    }

    public static enum Verbosity {
        NIL,
        FALSE,
        TRUE;

    }
}

