/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.compiler.Compilable;
import org.jruby.compiler.JITCompiler;
import org.jruby.ir.interpreter.InterpreterContext;

class FullBuildTask
implements Runnable {
    private JITCompiler jitCompiler;
    private final Compilable<InterpreterContext> method;

    FullBuildTask(JITCompiler jitCompiler, Compilable<InterpreterContext> method2) {
        this.jitCompiler = jitCompiler;
        this.method = method2;
    }

    @Override
    public void run() {
        block3: {
            try {
                this.method.getIRScope().getRootLexicalScope().prepareFullBuild();
                this.method.completeBuild(this.method.getIRScope().prepareFullBuild());
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.method.getName(), "done building", new String[0]);
                }
            }
            catch (Throwable t) {
                if (!this.jitCompiler.config.isJitLogging()) break block3;
                JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.method.getName(), "Could not build; passes run: " + this.method.getIRScope().getExecutedPasses(), t.getMessage());
                if (!this.jitCompiler.config.isJitLoggingVerbose()) break block3;
                t.printStackTrace();
            }
        }
    }
}

