/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyMarshal;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.thread.Mutex;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"ConditionVariable"})
public class ConditionVariable
extends RubyObject {
    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static ConditionVariable newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        ConditionVariable result2 = new ConditionVariable(context.runtime, (RubyClass)recv2);
        result2.callInit(context, args2, block);
        return result2;
    }

    public ConditionVariable(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static void setup(Ruby runtime2) {
        RubyClass cConditionVariable = runtime2.getThread().defineClassUnder("ConditionVariable", runtime2.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new ConditionVariable(runtime2, klass);
            }
        });
        cConditionVariable.undefineMethod("initialize_copy");
        cConditionVariable.setReifiedClass(ConditionVariable.class);
        cConditionVariable.defineAnnotatedMethods(ConditionVariable.class);
        runtime2.getObject().setConstant("ConditionVariable", cConditionVariable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"wait"}, required=1, optional=1)
    public IRubyObject wait_ruby(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        if (args2.length < 1) {
            throw runtime2.newArgumentError(args2.length, 1);
        }
        if (args2.length > 2) {
            throw runtime2.newArgumentError(args2.length, 2);
        }
        if (!(args2[0] instanceof Mutex)) {
            throw context.runtime.newTypeError(args2[0], runtime2.getClass("Mutex"));
        }
        Mutex mutex = (Mutex)args2[0];
        Double timeout2 = null;
        if (args2.length > 1 && !args2[1].isNil() && (timeout2 = Double.valueOf(args2[1].convertToFloat().getDoubleValue())) < 0.0) {
            throw runtime2.newArgumentError("time interval must be positive");
        }
        if (Thread.interrupted()) {
            throw runtime2.newConcurrencyError("thread interrupted");
        }
        boolean success = false;
        try {
            ConditionVariable conditionVariable = this;
            synchronized (conditionVariable) {
                mutex.unlock(context);
                try {
                    success = context.getThread().wait_timeout(this, timeout2);
                }
                catch (InterruptedException ie) {
                    throw runtime2.newConcurrencyError(ie.getLocalizedMessage());
                }
                finally {
                    if (!success) {
                        this.notify();
                    }
                }
            }
        }
        finally {
            mutex.lock(context);
        }
        if (timeout2 != null) {
            return runtime2.newBoolean(success);
        }
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject broadcast(ThreadContext context) {
        this.notifyAll();
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject signal(ThreadContext context) {
        this.notify();
        return this;
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        return RubyMarshal.undumpable(context, this);
    }
}

