/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import java.util.ArrayList;
import java.util.List;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ByteVector;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleHashesAttribute
extends Attribute {
    public String algorithm;
    public List<String> modules;
    public List<byte[]> hashes;

    public ModuleHashesAttribute(String algorithm, List<String> modules, List<byte[]> hashes) {
        super("ModuleHashes");
        this.algorithm = algorithm;
        this.modules = modules;
        this.hashes = hashes;
    }

    public ModuleHashesAttribute() {
        this(null, null, null);
    }

    @Override
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        String hashAlgorithm = cr.readUTF8(off, buf);
        int count2 = cr.readUnsignedShort(off + 2);
        ArrayList<String> modules = new ArrayList<String>(count2);
        ArrayList<byte[]> hashes = new ArrayList<byte[]>(count2);
        off += 4;
        for (int i2 = 0; i2 < count2; ++i2) {
            String module = cr.readModule(off, buf);
            int hashLength = cr.readUnsignedShort(off + 2);
            off += 4;
            byte[] hash2 = new byte[hashLength];
            for (int j = 0; j < hashLength; ++j) {
                hash2[j] = (byte)(cr.readByte(off + j) & 0xFF);
            }
            off += hashLength;
            modules.add(module);
            hashes.add(hash2);
        }
        return new ModuleHashesAttribute(hashAlgorithm, modules, hashes);
    }

    @Override
    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector v = new ByteVector();
        int index2 = cw.newUTF8(this.algorithm);
        v.putShort(index2);
        int count2 = this.modules == null ? 0 : this.modules.size();
        v.putShort(count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            String module = this.modules.get(i2);
            v.putShort(cw.newModule(module));
            byte[] hash2 = this.hashes.get(i2);
            v.putShort(hash2.length);
            for (byte b2 : hash2) {
                v.putByte(b2);
            }
        }
        return v;
    }
}

