/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jruby.org.objectweb.asm.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String desc) {
        this(393216, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int api, String desc) {
        super(api);
        this.desc = desc;
    }

    AnnotationNode(List<Object> values2) {
        super(393216);
        this.values = values2;
    }

    @Override
    public void visit(String name2, Object value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        if (value2 instanceof byte[]) {
            byte[] v = (byte[])value2;
            ArrayList<Byte> l = new ArrayList<Byte>(v.length);
            for (byte b2 : v) {
                l.add(b2);
            }
            this.values.add(l);
        } else if (value2 instanceof boolean[]) {
            boolean[] v = (boolean[])value2;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v.length);
            for (boolean b3 : v) {
                l.add(b3);
            }
            this.values.add(l);
        } else if (value2 instanceof short[]) {
            short[] v = (short[])value2;
            ArrayList<Short> l = new ArrayList<Short>(v.length);
            for (short s2 : v) {
                l.add(s2);
            }
            this.values.add(l);
        } else if (value2 instanceof char[]) {
            char[] v = (char[])value2;
            ArrayList<Character> l = new ArrayList<Character>(v.length);
            for (char c : v) {
                l.add(Character.valueOf(c));
            }
            this.values.add(l);
        } else if (value2 instanceof int[]) {
            int[] v = (int[])value2;
            ArrayList<Integer> l = new ArrayList<Integer>(v.length);
            for (int i2 : v) {
                l.add(i2);
            }
            this.values.add(l);
        } else if (value2 instanceof long[]) {
            long[] v = (long[])value2;
            ArrayList<Long> l = new ArrayList<Long>(v.length);
            for (long lng : v) {
                l.add(lng);
            }
            this.values.add(l);
        } else if (value2 instanceof float[]) {
            float[] v = (float[])value2;
            ArrayList<Float> l = new ArrayList<Float>(v.length);
            for (float f : v) {
                l.add(Float.valueOf(f));
            }
            this.values.add(l);
        } else if (value2 instanceof double[]) {
            double[] v = (double[])value2;
            ArrayList<Double> l = new ArrayList<Double>(v.length);
            for (double d : v) {
                l.add(d);
            }
            this.values.add(l);
        } else {
            this.values.add(value2);
        }
    }

    @Override
    public void visitEnum(String name2, String desc, String value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        this.values.add(new String[]{desc, value2});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name2, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        AnnotationNode annotation2 = new AnnotationNode(desc);
        this.values.add(annotation2);
        return annotation2;
    }

    @Override
    public AnnotationVisitor visitArray(String name2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        ArrayList<Object> array2 = new ArrayList<Object>();
        this.values.add(array2);
        return new AnnotationNode(array2);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int api) {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i2 = 0; i2 < this.values.size(); i2 += 2) {
                    String name2 = (String)this.values.get(i2);
                    Object value2 = this.values.get(i2 + 1);
                    AnnotationNode.accept(av, name2, value2);
                }
            }
            av.visitEnd();
        }
    }

    static void accept(AnnotationVisitor av, String name2, Object value2) {
        if (av != null) {
            if (value2 instanceof String[]) {
                String[] typeconst = (String[])value2;
                av.visitEnum(name2, typeconst[0], typeconst[1]);
            } else if (value2 instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value2;
                an.accept(av.visitAnnotation(name2, an.desc));
            } else if (value2 instanceof List) {
                AnnotationVisitor v = av.visitArray(name2);
                if (v != null) {
                    List array2 = (List)value2;
                    for (int j = 0; j < array2.size(); ++j) {
                        AnnotationNode.accept(v, null, array2.get(j));
                    }
                    v.visitEnd();
                }
            } else {
                av.visit(name2, value2);
            }
        }
    }
}

