/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.tree.AbstractInsnNode;
import org.jruby.org.objectweb.asm.tree.IincInsnNode;
import org.jruby.org.objectweb.asm.tree.InsnList;
import org.jruby.org.objectweb.asm.tree.JumpInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jruby.org.objectweb.asm.tree.VarInsnNode;
import org.jruby.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jruby.org.objectweb.asm.tree.analysis.Frame;
import org.jruby.org.objectweb.asm.tree.analysis.Interpreter;
import org.jruby.org.objectweb.asm.tree.analysis.Subroutine;
import org.jruby.org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private int n;
    private InsnList insns;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String owner2, MethodNode m) throws AnalyzerException {
        if ((m.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.n = m.instructions.size();
        this.insns = m.instructions;
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (int i2 = 0; i2 < m.tryCatchBlocks.size(); ++i2) {
            TryCatchBlockNode tcb = m.tryCatchBlocks.get(i2);
            int begin2 = this.insns.indexOf(tcb.start);
            int end2 = this.insns.indexOf(tcb.end);
            for (int j = begin2; j < end2; ++j) {
                List<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Subroutine main2 = new Subroutine(null, m.maxLocals, null);
        ArrayList<AbstractInsnNode> subroutineCalls = new ArrayList<AbstractInsnNode>();
        HashMap<LabelNode, Subroutine> subroutineHeads = new HashMap<LabelNode, Subroutine>();
        this.findSubroutine(0, main2, subroutineCalls);
        while (!subroutineCalls.isEmpty()) {
            JumpInsnNode jsr = (JumpInsnNode)subroutineCalls.remove(0);
            Subroutine sub3 = (Subroutine)subroutineHeads.get(jsr.label);
            if (sub3 == null) {
                sub3 = new Subroutine(jsr.label, m.maxLocals, jsr);
                subroutineHeads.put(jsr.label, sub3);
                this.findSubroutine(this.insns.indexOf(jsr.label), sub3, subroutineCalls);
                continue;
            }
            sub3.callers.add(jsr);
        }
        for (int i3 = 0; i3 < this.n; ++i3) {
            if (this.subroutines[i3] == null || this.subroutines[i3].start != null) continue;
            this.subroutines[i3] = null;
        }
        Frame<V> current2 = this.newFrame(m.maxLocals, m.maxStack);
        Frame<V> handler = this.newFrame(m.maxLocals, m.maxStack);
        current2.setReturn(this.interpreter.newValue(Type.getReturnType(m.desc)));
        Type[] args2 = Type.getArgumentTypes(m.desc);
        int local2 = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType(owner2);
            current2.setLocal(local2++, this.interpreter.newValue(ctype));
        }
        for (int i4 = 0; i4 < args2.length; ++i4) {
            current2.setLocal(local2++, this.interpreter.newValue(args2[i4]));
            if (args2[i4].getSize() != 2) continue;
            current2.setLocal(local2++, this.interpreter.newValue(null));
        }
        while (local2 < m.maxLocals) {
            current2.setLocal(local2++, this.interpreter.newValue(null));
        }
        this.merge(0, current2, null);
        this.init(owner2, m);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame<V> f = this.frames[insn];
            Subroutine subroutine = this.subroutines[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List<TryCatchBlockNode> insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insn + 1, f, subroutine);
                    this.newControlFlowEdge(insn, insn + 1);
                } else {
                    LabelNode label2;
                    int j;
                    int jump;
                    current2.init(f).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current2, subroutine);
                            this.newControlFlowEdge(insn, insn + 1);
                        }
                        jump = this.insns.indexOf(j2.label);
                        if (insnOpcode == 168) {
                            this.merge(jump, current2, new Subroutine(j2.label, m.maxLocals, j2));
                        } else {
                            this.merge(jump, current2, subroutine);
                        }
                        this.newControlFlowEdge(insn, jump);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        jump = this.insns.indexOf(lsi.dflt);
                        this.merge(jump, current2, subroutine);
                        this.newControlFlowEdge(insn, jump);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            label2 = lsi.labels.get(j);
                            jump = this.insns.indexOf(label2);
                            this.merge(jump, current2, subroutine);
                            this.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        jump = this.insns.indexOf(tsi.dflt);
                        this.merge(jump, current2, subroutine);
                        this.newControlFlowEdge(insn, jump);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            label2 = tsi.labels.get(j);
                            jump = this.insns.indexOf(label2);
                            this.merge(jump, current2, subroutine);
                            this.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i5 = 0; i5 < subroutine.callers.size(); ++i5) {
                            JumpInsnNode caller2 = subroutine.callers.get(i5);
                            int call2 = this.insns.indexOf(caller2);
                            if (this.frames[call2] == null) continue;
                            this.merge(call2 + 1, this.frames[call2], current2, this.subroutines[call2], subroutine.access);
                            this.newControlFlowEdge(insn, call2 + 1);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.access[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                            }
                        }
                        this.merge(insn + 1, current2, subroutine);
                        this.newControlFlowEdge(insn, insn + 1);
                    }
                }
                if ((insnHandlers = this.handlers[insn]) == null) continue;
                for (int i6 = 0; i6 < insnHandlers.size(); ++i6) {
                    TryCatchBlockNode tcb = insnHandlers.get(i6);
                    Type type2 = tcb.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tcb.type);
                    int jump = this.insns.indexOf(tcb.handler);
                    if (!this.newControlFlowExceptionEdge(insn, tcb)) continue;
                    handler.init(f);
                    handler.clearStack();
                    handler.push(this.interpreter.newValue(type2));
                    this.merge(jump, handler, subroutine);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int insn, Subroutine sub3, List<AbstractInsnNode> calls) throws AnalyzerException {
        while (true) {
            LabelNode l;
            int i2;
            if (insn < 0 || insn >= this.n) {
                throw new AnalyzerException(null, "Execution can fall off end of the code");
            }
            if (this.subroutines[insn] != null) {
                return;
            }
            this.subroutines[insn] = sub3.copy();
            AbstractInsnNode node = this.insns.get(insn);
            if (node instanceof JumpInsnNode) {
                if (node.getOpcode() == 168) {
                    calls.add(node);
                } else {
                    JumpInsnNode jnode = (JumpInsnNode)node;
                    this.findSubroutine(this.insns.indexOf(jnode.label), sub3, calls);
                }
            } else if (node instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tsnode = (TableSwitchInsnNode)node;
                this.findSubroutine(this.insns.indexOf(tsnode.dflt), sub3, calls);
                for (i2 = tsnode.labels.size() - 1; i2 >= 0; --i2) {
                    l = tsnode.labels.get(i2);
                    this.findSubroutine(this.insns.indexOf(l), sub3, calls);
                }
            } else if (node instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lsnode = (LookupSwitchInsnNode)node;
                this.findSubroutine(this.insns.indexOf(lsnode.dflt), sub3, calls);
                for (i2 = lsnode.labels.size() - 1; i2 >= 0; --i2) {
                    l = lsnode.labels.get(i2);
                    this.findSubroutine(this.insns.indexOf(l), sub3, calls);
                }
            }
            List<TryCatchBlockNode> insnHandlers = this.handlers[insn];
            if (insnHandlers != null) {
                for (i2 = 0; i2 < insnHandlers.size(); ++i2) {
                    TryCatchBlockNode tcb = insnHandlers.get(i2);
                    this.findSubroutine(this.insns.indexOf(tcb.handler), sub3, calls);
                }
            }
            switch (node.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++insn;
        }
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int insn) {
        return this.handlers[insn];
    }

    protected void init(String owner2, MethodNode m) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> src) {
        return new Frame<V>(src);
    }

    protected void newControlFlowEdge(int insn, int successor) {
    }

    protected boolean newControlFlowExceptionEdge(int insn, int successor) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
        return this.newControlFlowExceptionEdge(insn, this.insns.indexOf(tcb.handler));
    }

    private void merge(int insn, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, this.interpreter);
        }
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insn] = subroutine.copy();
                changes = true;
            }
        } else if (subroutine != null) {
            changes |= oldSubroutine.merge(subroutine);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    private void merge(int insn, Frame<V> beforeJSR, Frame<V> afterRET, Subroutine subroutineBeforeJSR, boolean[] access) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        afterRET.merge(beforeJSR, access);
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(afterRET);
            changes = true;
        } else {
            changes = oldFrame.merge(afterRET, this.interpreter);
        }
        if (oldSubroutine != null && subroutineBeforeJSR != null) {
            changes |= oldSubroutine.merge(subroutineBeforeJSR);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }
}

