/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common;

import de.tuberlin.polymake.common.PolymakeControl;
import de.tuberlin.polymake.common.PolymakeViewer;
import de.tuberlin.polymake.common.SelectorThread;
import de.tuberlin.polymake.common.geometry.EmbeddedGeometries;
import de.tuberlin.polymake.common.geometry.PointSet;
import de.tuberlin.polymake.common.ui.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public abstract class PolymakeFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 6476686808978198094L;
    protected static int id = 1;
    private static Vector<PolymakeFrame> framesById = new Vector(4, 4);
    protected int number;
    public static JFrame helpFrame = null;
    protected JButton helpButton;
    protected Properties parameters;
    protected Properties iparameters;
    protected PolymakeControl parentControl;
    protected String geomTitle;
    protected JPanel northPanel = new JPanel(new BorderLayout());
    protected PolymakeViewer pViewer = null;
    protected Box southBox = Box.createVerticalBox();
    protected ParameterPanel paramPanel = null;
    protected JLabel statusBar = new JLabel(" ");
    protected EmbeddedGeometries geometry;
    private final int FRAME_WIDTH = 800;
    private final int FRAME_HEIGHT = 600;

    public PolymakeFrame(EmbeddedGeometries embeddedGeometries, String string, Properties properties, Properties properties2, PolymakeControl polymakeControl) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace(SelectorThread.newErr);
        }
        this.number = id++;
        this.parentControl = polymakeControl;
        framesById.setSize(id);
        framesById.set(this.number, this);
        this.geometry = (EmbeddedGeometries)embeddedGeometries.clone();
        this.geomTitle = string;
        this.geomTitle = this.geomTitle.replaceAll("^.+:", "");
        this.setName(embeddedGeometries.getName());
        if (this.geomTitle.equalsIgnoreCase("unnamed") || this.geomTitle.equalsIgnoreCase("")) {
            this.setTitle("* polymake *");
        } else {
            this.setTitle("polymake - " + this.geomTitle);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(new Rectangle((dimension.width - 800) / 2, (dimension.height - 600) / 2, 800, 600));
        if (properties != null) {
            this.parameters = (Properties)properties.clone();
        }
        if (properties2 != null) {
            this.iparameters = (Properties)properties2.clone();
        }
        this.addWindowListener(this);
        helpFrame = this.createHelpFrame();
        if (helpFrame != null) {
            this.helpButton = new JButton("Help");
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!helpFrame.isVisible() || helpFrame.getState() == 1) {
                        helpFrame.setLocation(PolymakeFrame.this.getX() + 20, PolymakeFrame.this.getY() + 20);
                    }
                    helpFrame.setState(0);
                    helpFrame.setVisible(true);
                }
            });
            this.northPanel.add((Component)this.helpButton, "East");
            this.helpButton.setAlignmentY(0.5f);
            this.helpButton.setMinimumSize(new Dimension(20, 20));
            this.helpButton.setPreferredSize(new Dimension(70, 20));
        }
        try {
            this.parentControl.putMessage("n " + this.number + "\n", 'P', false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SelectorThread.newErr);
        }
    }

    public String getGeomTitle() {
        return this.geomTitle;
    }

    public static PolymakeFrame getById(int n) {
        try {
            return framesById.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void forget() {
        try {
            framesById.set(this.number, null);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace(SelectorThread.newErr);
        }
    }

    public void setupFrame() {
        JComponent jComponent;
        if (this.southBox.getComponentCount() != 0) {
            jComponent = new JSplitPane(0, this.pViewer.getViewingComponent(), this.southBox);
            ((JSplitPane)jComponent).setContinuousLayout(true);
            ((JSplitPane)jComponent).setOneTouchExpandable(true);
            ((JSplitPane)jComponent).setResizeWeight(1.0);
            this.getContentPane().add((Component)jComponent, "Center");
        } else {
            this.getContentPane().add((Component)this.pViewer.getViewingComponent(), "Center");
        }
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)this.statusBar, "Center");
        if (this.helpButton != null) {
            jComponent.add((Component)this.helpButton, "East");
        }
        this.getContentPane().add((Component)jComponent, "South");
    }

    public abstract void update(PointSet var1, Properties var2);

    public void setStatus(String string) {
        this.statusBar.setText(string);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        windowEvent.getWindow().dispose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        try {
            this.parentControl.removeFrame(this.geomTitle);
            this.parentControl.putMessage("c " + this.number + "\nx\n", 'P', false);
            this.parentControl.removeFrame(this.getName());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SelectorThread.newErr);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public void encompass() {
        this.pViewer.encompass();
    }

    public void setMenuBar(Object object) {
        if (object instanceof MenuBar) {
            this.setMenuBar((MenuBar)object);
        } else if (object instanceof JMenuBar) {
            this.setJMenuBar((JMenuBar)object);
        }
    }

    public abstract JFrame createHelpFrame();
}

